/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.streams;

import com.vaadin.flow.dom.Element;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinResponse;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.streams.ClassDownloadHandler;
import com.vaadin.flow.server.streams.DownloadEvent;
import com.vaadin.flow.server.streams.ElementRequestHandler;
import com.vaadin.flow.server.streams.FileDownloadHandler;
import com.vaadin.flow.server.streams.InputStreamDownloadCallback;
import com.vaadin.flow.server.streams.InputStreamDownloadHandler;
import com.vaadin.flow.server.streams.ServletResourceDownloadHandler;
import com.vaadin.flow.server.streams.TransferProgressListener;
import java.io.File;
import java.io.IOException;

@FunctionalInterface
public interface DownloadHandler
extends ElementRequestHandler {
    public void handleDownloadRequest(DownloadEvent var1) throws IOException;

    @Override
    default public void handleRequest(VaadinRequest request, VaadinResponse response, VaadinSession session, Element owner) throws IOException {
        DownloadEvent downloadEvent = new DownloadEvent(request, response, session, owner);
        this.handleDownloadRequest(downloadEvent);
    }

    public static FileDownloadHandler forFile(File file) {
        return new FileDownloadHandler(file);
    }

    public static FileDownloadHandler forFile(File file, String fileNameOverride) {
        return new FileDownloadHandler(file, fileNameOverride);
    }

    public static FileDownloadHandler forFile(File file, String fileNameOverride, TransferProgressListener listener) {
        FileDownloadHandler handler = new FileDownloadHandler(file, fileNameOverride);
        handler.addTransferProgressListener(listener);
        return handler;
    }

    public static FileDownloadHandler forFile(File file, TransferProgressListener listener) {
        FileDownloadHandler handler = new FileDownloadHandler(file);
        handler.addTransferProgressListener(listener);
        return handler;
    }

    public static ClassDownloadHandler forClassResource(Class<?> clazz, String resourceName) {
        return new ClassDownloadHandler(clazz, resourceName);
    }

    public static ClassDownloadHandler forClassResource(Class<?> clazz, String resourceName, String fileNameOverride) {
        return new ClassDownloadHandler(clazz, resourceName, fileNameOverride);
    }

    public static ClassDownloadHandler forClassResource(Class<?> clazz, String resourceName, String fileNameOverride, TransferProgressListener listener) {
        ClassDownloadHandler handler = new ClassDownloadHandler(clazz, resourceName, fileNameOverride);
        handler.addTransferProgressListener(listener);
        return handler;
    }

    public static ClassDownloadHandler forClassResource(Class<?> clazz, String resourceName, TransferProgressListener listener) {
        ClassDownloadHandler handler = new ClassDownloadHandler(clazz, resourceName);
        handler.addTransferProgressListener(listener);
        return handler;
    }

    public static ServletResourceDownloadHandler forServletResource(String path) {
        return new ServletResourceDownloadHandler(path);
    }

    public static ServletResourceDownloadHandler forServletResource(String path, String fileNameOverride) {
        return new ServletResourceDownloadHandler(path, fileNameOverride);
    }

    public static ServletResourceDownloadHandler forServletResource(String path, String fileNameOverride, TransferProgressListener listener) {
        ServletResourceDownloadHandler handler = new ServletResourceDownloadHandler(path, fileNameOverride);
        handler.addTransferProgressListener(listener);
        return handler;
    }

    public static ServletResourceDownloadHandler forServletResource(String path, TransferProgressListener listener) {
        ServletResourceDownloadHandler handler = new ServletResourceDownloadHandler(path);
        handler.addTransferProgressListener(listener);
        return handler;
    }

    public static InputStreamDownloadHandler fromInputStream(InputStreamDownloadCallback callback) {
        return new InputStreamDownloadHandler(callback);
    }

    public static InputStreamDownloadHandler fromInputStream(InputStreamDownloadCallback callback, TransferProgressListener listener) {
        InputStreamDownloadHandler downloadHandler = new InputStreamDownloadHandler(callback);
        downloadHandler.addTransferProgressListener(listener);
        return downloadHandler;
    }
}

