/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.experimental.Feature;
import com.vaadin.flow.server.frontend.AbstractTaskClientGenerator;
import com.vaadin.flow.server.frontend.Options;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class TaskGenerateFeatureFlags
extends AbstractTaskClientGenerator {
    private final Options options;

    TaskGenerateFeatureFlags(Options options) {
        this.options = options;
    }

    @Override
    protected String getFileContent() {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("// @ts-nocheck");
        lines.add("window.Vaadin = window.Vaadin || {};");
        lines.add("window.Vaadin.featureFlags = window.Vaadin.featureFlags || {};");
        List<Feature> featureFlags = this.options.getFeatureFlags().getFeatures();
        if (!featureFlags.isEmpty()) {
            lines.add("if (Object.keys(window.Vaadin.featureFlags).length === 0) {");
            featureFlags.forEach(feature -> lines.add(String.format("window.Vaadin.featureFlags.%s = false;", feature.getId())));
            lines.add("};");
        }
        lines.add("if (window.Vaadin.featureFlagsUpdaters) { ");
        lines.add("const activator = (id) => window.Vaadin.featureFlags[id] = true;");
        lines.add("window.Vaadin.featureFlagsUpdaters.forEach(updater => updater(activator));");
        lines.add("delete window.Vaadin.featureFlagsUpdaters;");
        lines.add("} ");
        lines.add("export {};");
        return String.join((CharSequence)System.lineSeparator(), lines);
    }

    @Override
    protected File getGeneratedFile() {
        File frontendGeneratedDirectory = new File(this.options.getFrontendDirectory(), "generated/");
        return new File(frontendGeneratedDirectory, "vaadin-featureflags.js");
    }

    @Override
    protected boolean shouldGenerate() {
        return true;
    }
}

