/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.internal.JacksonUtils;
import com.vaadin.flow.internal.JsonDecodingException;
import com.vaadin.flow.server.frontend.FallibleCommand;
import com.vaadin.flow.server.frontend.FileIOUtils;
import com.vaadin.flow.server.frontend.FrontendUtils;
import com.vaadin.flow.server.frontend.FrontendVersion;
import com.vaadin.flow.server.frontend.Options;
import com.vaadin.flow.server.frontend.VersionsJsonConverter;
import com.vaadin.flow.server.frontend.VersionsJsonFilter;
import com.vaadin.flow.server.frontend.scanner.ClassFinder;
import com.vaadin.flow.server.frontend.scanner.FrontendDependenciesScanner;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.ObjectNode;

public abstract class NodeUpdater
implements FallibleCommand {
    private static final String VAADIN_FORM_PKG_LEGACY_VERSION = "flow-frontend/form";
    private static final String VAADIN_FORM_PKG = "@vaadin/form";
    private static final String VAADIN_JSON = ".vaadin/vaadin.json";
    static final String DEPENDENCIES = "dependencies";
    static final String VAADIN_DEP_KEY = "vaadin";
    static final String HASH_KEY = "hash";
    static final String DEV_DEPENDENCIES = "devDependencies";
    static final String OVERRIDES = "overrides";
    static final String PNPM = "pnpm";
    private static final String DEP_LICENSE_KEY = "license";
    private static final String DEP_LICENSE_DEFAULT = "UNLICENSED";
    private static final String DEP_NAME_KEY = "name";
    private static final String DEP_NAME_DEFAULT = "no-name";
    private static final String FRONTEND_RESOURCES_PATH = NodeUpdater.class.getPackage().getName().replace('.', '/') + "/";
    @Deprecated
    protected static final String DEP_NAME_FLOW_DEPS = "@vaadin/flow-deps";
    @Deprecated
    protected static final String DEP_NAME_FLOW_JARS = "@vaadin/flow-frontend";
    static final String VAADIN_VERSION = "vaadinVersion";
    static final String PROJECT_FOLDER = "projectFolder";
    protected final FrontendDependenciesScanner frontDeps;
    final ClassFinder finder;
    boolean modified;
    ObjectNode versionsJson;
    protected Options options;

    protected NodeUpdater(FrontendDependenciesScanner frontendDependencies, Options options) {
        this.finder = options.getClassFinder();
        this.frontDeps = frontendDependencies;
        this.options = options;
    }

    protected File getPackageJsonFile() {
        return new File(this.options.getNpmFolder(), "package.json");
    }

    protected File getPackageLockFile() {
        return new File(this.options.getNpmFolder(), "package-lock.json");
    }

    ObjectNode getPlatformPinnedDependencies() throws IOException {
        URL coreVersionsResource = this.finder.getResource("vaadin-core-versions.json");
        if (coreVersionsResource == null) {
            this.log().info("Couldn't find {} file to pin dependency versions for core components. Transitive dependencies won't be pinned for npm/pnpm/bun.", (Object)"vaadin-core-versions.json");
            return JacksonUtils.createObjectNode();
        }
        ObjectNode versionsJson = this.getFilteredVersionsFromResource(coreVersionsResource, "vaadin-core-versions.json");
        URL vaadinVersionsResource = this.finder.getResource("vaadin-versions.json");
        if (vaadinVersionsResource == null) {
            return versionsJson;
        }
        ObjectNode vaadinVersionsJson = this.getFilteredVersionsFromResource(vaadinVersionsResource, "vaadin-versions.json");
        for (String key : JacksonUtils.getKeys((JsonNode)vaadinVersionsJson)) {
            versionsJson.put(key, vaadinVersionsJson.get(key).textValue());
        }
        return versionsJson;
    }

    private ObjectNode getFilteredVersionsFromResource(URL versionsResource, String versionsOrigin) throws IOException {
        ObjectNode versionsJson;
        try (InputStream content = versionsResource.openStream();){
            VersionsJsonConverter convert = new VersionsJsonConverter((JsonNode)JacksonUtils.readTree(IOUtils.toString((InputStream)content, (Charset)StandardCharsets.UTF_8)), this.options.isReactEnabled() && FrontendUtils.isReactModuleAvailable(this.options), this.options.isNpmExcludeWebComponents());
            versionsJson = convert.getConvertedJson();
            versionsJson = new VersionsJsonFilter(this.getPackageJson(), DEPENDENCIES).getFilteredVersions(versionsJson, versionsOrigin);
        }
        return versionsJson;
    }

    static Set<String> getGeneratedModules(File frontendFolder) {
        Function<String, String> unixPath = str -> str.replace("\\", "/");
        File generatedImportsFolder = FrontendUtils.getFlowGeneratedFolder(frontendFolder);
        File webComponentsFolder = FrontendUtils.getFlowGeneratedWebComponentsFolder(frontendFolder);
        URI baseDir = generatedImportsFolder.toURI();
        if (!webComponentsFolder.exists()) {
            return Collections.emptySet();
        }
        return FileUtils.listFiles((File)webComponentsFolder, (String[])new String[]{"js"}, (boolean)true).stream().map(file -> (String)unixPath.apply(baseDir.relativize(file.toURI()).getPath())).collect(Collectors.toSet());
    }

    ObjectNode getPackageJson() throws IOException {
        ObjectNode packageJson = NodeUpdater.getJsonFileContent(this.getPackageJsonFile());
        if (packageJson == null) {
            packageJson = JacksonUtils.createObjectNode();
            packageJson.put(DEP_NAME_KEY, DEP_NAME_DEFAULT);
            packageJson.put(DEP_LICENSE_KEY, DEP_LICENSE_DEFAULT);
            packageJson.put("type", "module");
        }
        this.addDefaultObjects(packageJson);
        this.addVaadinDefaultsToJson(packageJson);
        this.removePlugins(packageJson);
        return packageJson;
    }

    private void addDefaultObjects(ObjectNode json) {
        NodeUpdater.computeIfAbsent(json, DEPENDENCIES, JacksonUtils::createObjectNode);
        NodeUpdater.computeIfAbsent(json, DEV_DEPENDENCIES, JacksonUtils::createObjectNode);
    }

    private void removePlugins(ObjectNode packageJson) {
        Path targetFolder = Paths.get(this.options.getNpmFolder().toString(), this.options.getBuildDirectoryName(), "plugins");
        if (!packageJson.has(DEV_DEPENDENCIES)) {
            return;
        }
        ObjectNode devDependencies = (ObjectNode)packageJson.get(DEV_DEPENDENCIES);
        String atVaadinPrefix = "@vaadin/";
        String pluginTargetPrefix = "./" + (this.options.getNpmFolder().toPath().relativize(targetFolder) + "/").replace('\\', '/');
        for (String depKey : JacksonUtils.getKeys((JsonNode)devDependencies)) {
            String depVersion = devDependencies.get(depKey).textValue();
            if (!depKey.startsWith(atVaadinPrefix) || !depVersion.startsWith(pluginTargetPrefix)) continue;
            devDependencies.remove(depKey);
        }
    }

    static ObjectNode getJsonFileContent(File packageFile) throws IOException {
        ObjectNode jsonContent = null;
        if (packageFile.exists()) {
            String fileContent = FileUtils.readFileToString((File)packageFile, (String)StandardCharsets.UTF_8.name());
            try {
                jsonContent = JacksonUtils.readTree(fileContent);
            }
            catch (JsonDecodingException e) {
                throw new RuntimeException(String.format("Cannot parse package file '%s'", packageFile));
            }
        }
        return jsonContent;
    }

    void addVaadinDefaultsToJson(ObjectNode json) {
        ObjectNode vaadinPackages = NodeUpdater.computeIfAbsent(json, VAADIN_DEP_KEY, JacksonUtils::createObjectNode);
        NodeUpdater.computeIfAbsent(vaadinPackages, DEPENDENCIES, () -> {
            ObjectNode dependencies = JacksonUtils.createObjectNode();
            this.getDefaultDependencies().forEach((arg_0, arg_1) -> ((ObjectNode)dependencies).put(arg_0, arg_1));
            return dependencies;
        });
        NodeUpdater.computeIfAbsent(vaadinPackages, DEV_DEPENDENCIES, () -> {
            ObjectNode devDependencies = JacksonUtils.createObjectNode();
            this.getDefaultDevDependencies().forEach((arg_0, arg_1) -> ((ObjectNode)devDependencies).put(arg_0, arg_1));
            return devDependencies;
        });
        NodeUpdater.computeIfAbsent(vaadinPackages, HASH_KEY, () -> JacksonUtils.createNode(""));
    }

    private static <T extends JsonNode> T computeIfAbsent(ObjectNode jsonObject, String key, Supplier<T> valueSupplier) {
        JsonNode result = jsonObject.get(key);
        if (result == null) {
            result = (JsonNode)valueSupplier.get();
            jsonObject.set(key, result);
        }
        return (T)result;
    }

    Map<String, String> getDefaultDependencies() {
        Map<String, String> dependencies = this.readDependencies("default", DEPENDENCIES);
        if (!this.isPolymerTemplateModuleAvailable(this.options)) {
            dependencies.remove("@polymer/polymer");
        }
        if (this.options.isReactEnabled()) {
            dependencies.putAll(this.readDependencies("react-router", DEPENDENCIES));
        } else {
            dependencies.putAll(this.readDependencies("vaadin-router", DEPENDENCIES));
        }
        this.putHillaComponentsDependencies(dependencies, DEPENDENCIES);
        return dependencies;
    }

    Map<String, String> readDependencies(String id, String packageJsonKey) {
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            JsonNode dependencies = this.readPackageJson(id).get(packageJsonKey);
            if (dependencies == null) {
                this.log().error("Unable to find " + packageJsonKey + " from '" + id + "'");
                return new HashMap<String, String>();
            }
            for (String key : JacksonUtils.getKeys(dependencies)) {
                map.put(key, dependencies.get(key).textValue());
            }
            return map;
        }
        catch (IOException e) {
            this.log().error("Unable to read " + packageJsonKey + " from '" + id + "'", (Throwable)e);
            return new HashMap<String, String>();
        }
    }

    JsonNode readPackageJson(String id) throws IOException {
        URL resource = this.options.getClassFinder().getResource(FRONTEND_RESOURCES_PATH + "dependencies/" + id + "/package.json");
        if (resource == null) {
            this.log().error("Unable to find package.json from '" + id + "'");
            return JacksonUtils.readTree("{\"%s\":{},\"%s\":{}}".formatted(DEPENDENCIES, DEV_DEPENDENCIES));
        }
        return JacksonUtils.readTree(IOUtils.toString((URL)resource, (Charset)StandardCharsets.UTF_8));
    }

    boolean hasPackageJson(String id) {
        return this.options.getClassFinder().getResource(FRONTEND_RESOURCES_PATH + "dependencies/" + id + "/package.json") != null;
    }

    Map<String, String> readDependenciesIfAvailable(String id, String packageJsonKey) {
        if (this.hasPackageJson(id)) {
            return this.readDependencies(id, packageJsonKey);
        }
        return new HashMap<String, String>();
    }

    Map<String, String> getDefaultDevDependencies() {
        HashMap<String, String> defaults = new HashMap<String, String>();
        defaults.putAll(this.readDependencies("default", DEV_DEPENDENCIES));
        defaults.putAll(this.readDependencies("vite", DEV_DEPENDENCIES));
        this.putHillaComponentsDependencies(defaults, DEV_DEPENDENCIES);
        if (this.options.isReactEnabled()) {
            defaults.putAll(this.readDependencies("react-router", DEV_DEPENDENCIES));
        }
        return defaults;
    }

    boolean updateDefaultDependencies(ObjectNode packageJson) {
        int added = 0;
        for (Map.Entry<String, String> entry : this.getDefaultDependencies().entrySet()) {
            added += this.addDependency(packageJson, DEPENDENCIES, entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, String> entry : this.getDefaultDevDependencies().entrySet()) {
            added += this.addDependency(packageJson, DEV_DEPENDENCIES, entry.getKey(), entry.getValue());
        }
        if (added > 0) {
            this.log().debug("Added {} default dependencies to main package.json", (Object)added);
        }
        return added > 0;
    }

    int addDependency(ObjectNode json, String key, String pkg, String version) {
        Objects.requireNonNull(json, "Json object need to be given");
        Objects.requireNonNull(key, "Json sub object needs to be give.");
        Objects.requireNonNull(pkg, "dependency package needs to be defined");
        ObjectNode vaadinDeps = (ObjectNode)json.get(VAADIN_DEP_KEY);
        if (!json.has(key)) {
            json.set(key, (JsonNode)JacksonUtils.createObjectNode());
        }
        json = (ObjectNode)json.get(key);
        if ((vaadinDeps = (ObjectNode)vaadinDeps.get(key)).has(pkg)) {
            if (version == null) {
                version = vaadinDeps.get(pkg).textValue();
            }
            return this.handleExistingVaadinDep(json, pkg, version, vaadinDeps);
        }
        vaadinDeps.put(pkg, version);
        if (!json.has(pkg) || this.isNewerVersion((JsonNode)json, pkg, version)) {
            json.put(pkg, version);
            this.log().debug("Added \"{}\": \"{}\" line.", (Object)pkg, (Object)version);
            return 1;
        }
        return 0;
    }

    private boolean isNewerVersion(JsonNode json, String pkg, String version) {
        try {
            FrontendVersion newVersion = new FrontendVersion(version);
            FrontendVersion existingVersion = NodeUpdater.toVersion(json, pkg);
            return newVersion.isNewerThan(existingVersion);
        }
        catch (NumberFormatException e) {
            if (VAADIN_FORM_PKG.equals(pkg) && json.get(pkg).textValue().contains(VAADIN_FORM_PKG_LEGACY_VERSION)) {
                return true;
            }
            this.log().warn("Package {} has unparseable version: {}", (Object)pkg, (Object)e.getMessage());
            return false;
        }
    }

    private int handleExistingVaadinDep(ObjectNode json, String pkg, String version, ObjectNode vaadinDeps) {
        boolean added = false;
        boolean updatedVaadinVersionSection = false;
        try {
            FrontendVersion vaadinVersion = NodeUpdater.toVersion((JsonNode)vaadinDeps, pkg);
            if (json.has(pkg)) {
                FrontendVersion packageVersion = NodeUpdater.toVersion((JsonNode)json, pkg);
                FrontendVersion newVersion = new FrontendVersion(version);
                if (vaadinVersion.isEqualTo(packageVersion) && !vaadinVersion.isEqualTo(newVersion)) {
                    json.put(pkg, version);
                    added = true;
                } else if (newVersion.isNewerThan(packageVersion)) {
                    json.put(pkg, version);
                    added = true;
                }
            } else {
                json.put(pkg, version);
                added = true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (!version.equals(vaadinDeps.get(pkg).textValue())) {
            vaadinDeps.put(pkg, version);
            updatedVaadinVersionSection = true;
        }
        if (added) {
            this.log().debug("Added \"{}\": \"{}\" line.", (Object)pkg, (Object)version);
        } else {
            added = updatedVaadinVersionSection;
        }
        return added ? 1 : 0;
    }

    private static FrontendVersion toVersion(JsonNode json, String key) {
        return new FrontendVersion(json.get(key).textValue());
    }

    String writePackageFile(JsonNode packageJson) throws IOException {
        return this.writePackageFile(packageJson, new File(this.options.getNpmFolder(), "package.json"));
    }

    String writePackageFile(JsonNode json, File packageFile) throws IOException {
        String content = JacksonUtils.toFileJson(json);
        if (packageFile.exists() || this.options.isFrontendHotdeploy() || this.options.isBundleBuild()) {
            this.log().debug("writing file {}.", (Object)packageFile.getAbsolutePath());
            FileUtils.forceMkdirParent((File)packageFile);
            FileIOUtils.writeIfChanged(packageFile, content);
        }
        return content;
    }

    File getVaadinJsonFile() {
        return new File(new File(this.options.getNpmFolder(), "node_modules/"), VAADIN_JSON);
    }

    ObjectNode getVaadinJsonContents() throws IOException {
        File vaadinJsonFile = this.getVaadinJsonFile();
        if (vaadinJsonFile.exists()) {
            String fileContent = FileUtils.readFileToString((File)vaadinJsonFile, (String)StandardCharsets.UTF_8.name());
            return JacksonUtils.readTree(fileContent);
        }
        return JacksonUtils.createObjectNode();
    }

    void updateVaadinJsonContents(Map<String, String> newContent) throws IOException {
        ObjectNode fileContent = this.getVaadinJsonContents();
        newContent.forEach((arg_0, arg_1) -> ((ObjectNode)fileContent).put(arg_0, arg_1));
        File vaadinJsonFile = this.getVaadinJsonFile();
        FileUtils.forceMkdirParent((File)vaadinJsonFile);
        String content = fileContent.toPrettyString() + "\n";
        FileIOUtils.writeIfChanged(vaadinJsonFile, content);
    }

    Logger log() {
        return LoggerFactory.getLogger(this.getClass());
    }

    protected void generateVersionsJson(ObjectNode packageJson) throws IOException {
        this.versionsJson = this.getPlatformPinnedDependencies();
        ObjectNode packageJsonVersions = this.generateVersionsFromPackageJson((JsonNode)packageJson);
        if (JacksonUtils.getKeys((JsonNode)this.versionsJson).isEmpty()) {
            this.versionsJson = packageJsonVersions;
        } else {
            for (String key : JacksonUtils.getKeys((JsonNode)packageJsonVersions)) {
                if (this.versionsJson.has(key)) continue;
                this.versionsJson.put(key, packageJsonVersions.get(key).textValue());
            }
        }
    }

    private ObjectNode generateVersionsFromPackageJson(JsonNode packageJson) {
        ObjectNode versionsJson = JacksonUtils.createObjectNode();
        JsonNode dependencies = packageJson.get(DEPENDENCIES);
        if (dependencies != null) {
            for (String key : JacksonUtils.getKeys(dependencies)) {
                versionsJson.put(key, dependencies.get(key).textValue());
            }
        }
        return versionsJson;
    }

    private void putHillaComponentsDependencies(Map<String, String> dependencies, String packageJsonKey) {
        if (FrontendUtils.isHillaUsed(this.options.getFrontendDirectory(), this.options.getClassFinder())) {
            if (this.options.isReactEnabled()) {
                dependencies.putAll(this.readDependenciesIfAvailable("hilla/components/react", packageJsonKey));
                if (this.options.isNpmExcludeWebComponents()) {
                    dependencies.remove("@vaadin/hilla-react-crud");
                }
            } else {
                dependencies.putAll(this.readDependenciesIfAvailable("hilla/components/lit", packageJsonKey));
            }
        }
    }

    private boolean isPolymerTemplateModuleAvailable(Options options) {
        try {
            options.getClassFinder().loadClass("com.vaadin.flow.component.polymertemplate.PolymerTemplate");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

