/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.page;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.router.Location;
import com.vaadin.flow.router.NavigationTrigger;
import java.io.Serializable;
import java.util.EventObject;
import java.util.Optional;
import tools.jackson.databind.node.BaseJsonNode;

public class History
implements Serializable {
    private final UI ui;
    private HistoryStateChangeHandler historyStateChangeHandler;

    public History(UI ui) {
        assert (ui != null);
        this.ui = ui;
    }

    public UI getUI() {
        return this.ui;
    }

    public void pushState(BaseJsonNode state, String location) {
        this.pushState(state, (Location)Optional.ofNullable(location).map(Location::new).orElse(null));
    }

    public void pushState(BaseJsonNode state, String location, boolean callback) {
        this.pushState(state, (Location)Optional.ofNullable(location).map(Location::new).orElse(null), callback);
    }

    public void pushState(BaseJsonNode state, Location location) {
        this.pushState(state, location, false);
    }

    public void pushState(BaseJsonNode state, Location location, boolean callback) {
        String pathWithQueryParameters = this.getPathWithQueryParameters(location);
        if (this.ui.getSession().getService().getDeploymentConfiguration().isReactEnabled()) {
            this.ui.getPage().executeJs("window.dispatchEvent(new CustomEvent('vaadin-navigate', { detail: { state: $0, url: $1, replace: false, callback: $2 } }));", new Serializable[]{state, pathWithQueryParameters, Boolean.valueOf(callback)});
        } else {
            this.ui.getPage().executeJs("setTimeout(() => { window.history.pushState($0, '', $1); window.dispatchEvent(new CustomEvent('vaadin-navigated')); })", new Serializable[]{state, pathWithQueryParameters});
        }
    }

    public void replaceState(BaseJsonNode state, String location) {
        this.replaceState(state, (Location)Optional.ofNullable(location).map(Location::new).orElse(null));
    }

    public void replaceState(BaseJsonNode state, String location, boolean callback) {
        this.replaceState(state, (Location)Optional.ofNullable(location).map(Location::new).orElse(null), callback);
    }

    public void replaceState(BaseJsonNode state, Location location) {
        this.replaceState(state, location, false);
    }

    public void replaceState(BaseJsonNode state, Location location, boolean callback) {
        String pathWithQueryParameters = this.getPathWithQueryParameters(location);
        if (this.ui.getSession().getService().getDeploymentConfiguration().isReactEnabled()) {
            this.ui.getPage().executeJs("window.dispatchEvent(new CustomEvent('vaadin-navigate', { detail: { state: $0, url: $1, replace: true, callback: $2 } }));", new Serializable[]{state, pathWithQueryParameters, Boolean.valueOf(callback)});
        } else {
            this.ui.getPage().executeJs("setTimeout(() => { window.history.replaceState($0, '', $1); window.dispatchEvent(new CustomEvent('vaadin-navigated')); })", new Serializable[]{state, pathWithQueryParameters});
        }
    }

    public void setHistoryStateChangeHandler(HistoryStateChangeHandler historyStateChangeHandler) {
        this.historyStateChangeHandler = historyStateChangeHandler;
    }

    public HistoryStateChangeHandler getHistoryStateChangeHandler() {
        return this.historyStateChangeHandler;
    }

    public void back() {
        this.ui.getPage().executeJs("history.back()", new Serializable[0]);
    }

    public void forward() {
        this.ui.getPage().executeJs("history.forward()", new Serializable[0]);
    }

    public void go(int steps) {
        this.ui.getPage().executeJs("history.go($0)", Integer.valueOf(steps));
    }

    private String getPathWithQueryParameters(Location location) {
        return Optional.ofNullable(location).map(Location::getPathWithQueryParameters).map(path -> path.isEmpty() ? "." : path).orElse(null);
    }

    @FunctionalInterface
    public static interface HistoryStateChangeHandler
    extends Serializable {
        public void onHistoryStateChange(HistoryStateChangeEvent var1);
    }

    public static class HistoryStateChangeEvent
    extends EventObject {
        private final Location location;
        private final transient BaseJsonNode state;
        private final NavigationTrigger trigger;

        public HistoryStateChangeEvent(History history, BaseJsonNode state, Location location, NavigationTrigger trigger) {
            super(history);
            assert (location != null);
            assert (trigger != null);
            this.location = location;
            this.state = state;
            this.trigger = trigger;
        }

        @Override
        public History getSource() {
            return (History)super.getSource();
        }

        public Location getLocation() {
            return this.location;
        }

        public Optional<BaseJsonNode> getState() {
            return Optional.ofNullable(this.state);
        }

        public NavigationTrigger getTrigger() {
            return this.trigger;
        }
    }
}

