/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.UIDetachedException;
import com.vaadin.flow.function.SerializableBiConsumer;
import com.vaadin.flow.server.ErrorEvent;
import com.vaadin.flow.shared.Registration;
import com.vaadin.signals.Signal;
import com.vaadin.signals.SignalEnvironment;
import com.vaadin.signals.impl.Effect;
import java.util.Objects;

public final class ComponentEffect {
    private final Runnable effectFunction;
    private boolean closed = false;
    private Effect effect = null;

    private <C extends Component> ComponentEffect(C owner, Runnable effectFunction) {
        Objects.requireNonNull(owner, "Owner component cannot be null");
        Objects.requireNonNull(effectFunction, "Effect function cannot be null");
        this.effectFunction = effectFunction;
        owner.addAttachListener(attach -> {
            this.enableEffect((Component)attach.getSource());
            owner.addDetachListener(detach -> {
                this.disableEffect();
                detach.unregisterListener();
            });
        });
        if (owner.isAttached()) {
            this.enableEffect(owner);
        }
    }

    public static <C extends Component> Registration effect(C owner, Runnable effectFunction) {
        ComponentEffect effect = new ComponentEffect(owner, effectFunction);
        return effect::close;
    }

    public static <C extends Component, T> Registration bind(C owner, Signal<T> signal, SerializableBiConsumer<C, T> setter) {
        return ComponentEffect.effect(owner, () -> setter.accept(owner, signal.value()));
    }

    private void enableEffect(Component owner) {
        if (this.closed) {
            return;
        }
        UI ui = owner.getUI().get();
        Runnable errorHandlingEffectFunction = () -> {
            try {
                this.effectFunction.run();
            }
            catch (Exception e) {
                ui.getSession().getErrorHandler().error(new ErrorEvent(e, owner.getElement().getNode()));
            }
        };
        assert (this.effect == null);
        this.effect = new Effect(errorHandlingEffectFunction, command -> {
            if (UI.getCurrent() == ui) {
                command.run();
            } else {
                SignalEnvironment.getDefaultEffectDispatcher().execute(() -> {
                    try {
                        if (this.effect != null) {
                            ui.access(command::run);
                        }
                    }
                    catch (UIDetachedException uIDetachedException) {
                        // empty catch block
                    }
                });
            }
        });
    }

    private void disableEffect() {
        if (this.effect != null) {
            this.effect.dispose();
            this.effect = null;
        }
    }

    private void close() {
        this.disableEffect();
        this.closed = true;
    }
}

