/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.vaadin.flow.internal.Pair;
import com.vaadin.flow.server.ExecutionFailedException;
import com.vaadin.flow.server.frontend.FallibleCommand;
import com.vaadin.flow.server.frontend.FrontendTools;
import com.vaadin.flow.server.frontend.FrontendToolsSettings;
import com.vaadin.flow.server.frontend.FrontendUtils;
import com.vaadin.flow.server.frontend.NodeUpdater;
import com.vaadin.flow.server.frontend.Options;
import com.vaadin.flow.server.frontend.TaskGeneratePackageJson;
import com.vaadin.flow.server.frontend.TaskUpdatePackages;
import com.vaadin.flow.shared.util.SharedUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;

public class TaskRunNpmInstall
implements FallibleCommand {
    private static final String MODULES_YAML = ".modules.yaml";
    private static final String NPM_VALIDATION_FAIL_MESSAGE = "%n%n======================================================================================================%nThe path to npm cache contains whitespaces, and the currently installed npm version doesn't accept this.%nMost likely your Windows user home path contains whitespaces.%nTo workaround it, please change the npm cache path by using the following command:%n    npm config set cache [path-to-npm-cache] --global%n(you may also want to exclude the whitespaces with 'dir /x' to use the same dir),%nor upgrade the npm version to 7 (or newer) by:%n 1) Running 'npm-windows-upgrade' tool with Windows PowerShell:%n        Set-ExecutionPolicy Unrestricted -Scope CurrentUser -Force%n        npm install -g npm-windows-upgrade%n        npm-windows-upgrade%n 2) Manually installing a newer version of npx: npm install -g npx%n 3) Manually installing a newer version of pnpm: npm install -g pnpm%n 4) Deleting the following files from your Vaadin project's folder (if present):%n        node_modules, package-lock.json, vite.generated.ts, webpack.generated.js, pnpm-lock.yaml%n======================================================================================================%n";
    private final NodeUpdater packageUpdater;
    private final List<String> ignoredNodeFolders = Arrays.asList(".bin", "pnpm", ".ignored_pnpm", ".pnpm", ".staging", ".vaadin", ".modules.yaml");
    private final Options options;

    TaskRunNpmInstall(NodeUpdater packageUpdater, Options options) {
        this.packageUpdater = packageUpdater;
        this.options = options;
    }

    @Override
    public void execute() throws ExecutionFailedException {
        String toolName = TaskRunNpmInstall.getToolName(this.options);
        Object command = "install";
        if (this.options.isCiBuild()) {
            command = this.options.isEnablePnpm() || this.options.isEnableBun() ? (String)command + " --frozen-lockfile" : "ci";
        }
        if (this.packageUpdater.modified || this.shouldRunNpmInstall()) {
            this.packageUpdater.log().info("Running `" + toolName + " " + (String)command + "` to resolve and optionally download frontend dependencies. This may take a moment, please stand by...");
            this.runNpmInstall();
            this.updateLocalHash();
        } else {
            this.packageUpdater.log().info("Skipping `{} {}` because the frontend packages are already installed in the folder '{}' and the hash in the file '{}' is the same as in '{}'", new Object[]{toolName, command, this.options.getNodeModulesFolder().getAbsolutePath(), this.packageUpdater.getVaadinJsonFile().getAbsolutePath(), "package.json"});
        }
    }

    private void updateLocalHash() {
        try {
            JsonNode vaadin = this.packageUpdater.getPackageJson().get("vaadin");
            if (vaadin == null) {
                this.packageUpdater.log().warn("No vaadin object in package.json");
                return;
            }
            String hash = vaadin.get("hash").textValue();
            HashMap<String, String> updates = new HashMap<String, String>();
            updates.put("hash", hash);
            TaskUpdatePackages.getVaadinVersion(this.packageUpdater.finder).ifPresent(s -> updates.put("vaadinVersion", (String)s));
            updates.put("projectFolder", this.options.getNpmFolder().getAbsolutePath());
            this.packageUpdater.updateVaadinJsonContents(updates);
        }
        catch (IOException e) {
            this.packageUpdater.log().warn("Failed to update node_modules hash.", (Throwable)e);
        }
    }

    private boolean shouldRunNpmInstall() {
        if (!this.options.getNodeModulesFolder().isDirectory()) {
            return true;
        }
        File[] installedPackages = this.options.getNodeModulesFolder().listFiles((dir, name) -> !this.ignoredNodeFolders.contains(name));
        assert (installedPackages != null);
        if (installedPackages.length == 0) {
            return true;
        }
        return this.isVaadinHashOrProjectFolderUpdated();
    }

    boolean isVaadinHashOrProjectFolderUpdated() {
        try {
            ObjectNode nodeModulesVaadinJson = this.packageUpdater.getVaadinJsonContents();
            if (nodeModulesVaadinJson.has("hash")) {
                ObjectNode packageJson = this.packageUpdater.getPackageJson();
                if (!nodeModulesVaadinJson.get("hash").textValue().equals(packageJson.get("vaadin").get("hash").textValue())) {
                    return true;
                }
                return nodeModulesVaadinJson.has("projectFolder") && !this.options.getNpmFolder().getAbsolutePath().equals(nodeModulesVaadinJson.get("projectFolder").textValue());
            }
        }
        catch (IOException e) {
            this.packageUpdater.log().warn("Failed to load hashes forcing npm execution", (Throwable)e);
        }
        return true;
    }

    private void runNpmInstall() throws ExecutionFailedException {
        ArrayList<String> postinstallCommand;
        ArrayList<String> npmInstallCommand;
        this.cleanUp();
        Logger logger = this.packageUpdater.log();
        String baseDir = this.options.getNpmFolder().getAbsolutePath();
        FrontendToolsSettings settings = new FrontendToolsSettings(baseDir, () -> FrontendUtils.getVaadinHomeDirectory().getAbsolutePath());
        settings.setNodeDownloadRoot(this.options.getNodeDownloadRoot());
        settings.setForceAlternativeNode(this.options.isRequireHomeNodeExec());
        settings.setUseGlobalPnpm(this.options.isUseGlobalPnpm());
        settings.setAutoUpdate(this.options.isNodeAutoUpdate());
        settings.setNodeVersion(this.options.getNodeVersion());
        settings.setIgnoreVersionChecks(this.options.isFrontendIgnoreVersionChecks());
        FrontendTools tools = new FrontendTools(settings);
        tools.validateNodeAndNpmVersion();
        if (this.options.isEnablePnpm()) {
            try {
                this.createNpmRcFile();
            }
            catch (IOException exception) {
                logger.warn(".npmrc generation failed; pnpm package installation may require manually passing the --shamefully-hoist flag", (Throwable)exception);
            }
        }
        try {
            List<String> npmExecutable;
            if (this.options.isRequireHomeNodeExec()) {
                tools.forceAlternativeNodeExecutable();
            }
            if (this.options.isEnableBun()) {
                npmExecutable = tools.getBunExecutable();
            } else if (this.options.isEnablePnpm()) {
                this.validateInstalledNpm(tools);
                npmExecutable = tools.getPnpmExecutable();
            } else {
                npmExecutable = tools.getNpmExecutable();
            }
            npmInstallCommand = new ArrayList<String>(npmExecutable);
            postinstallCommand = new ArrayList<String>(npmExecutable);
            postinstallCommand.remove("--shamefully-hoist=true");
        }
        catch (IllegalStateException exception) {
            throw new ExecutionFailedException(exception.getMessage(), exception);
        }
        npmInstallCommand.add("--ignore-scripts");
        if (this.options.isCiBuild()) {
            if (this.options.isEnablePnpm() || this.options.isEnableBun()) {
                npmInstallCommand.add("install");
                npmInstallCommand.add("--frozen-lockfile");
            } else {
                npmInstallCommand.add("ci");
            }
        } else {
            npmInstallCommand.add("install");
        }
        postinstallCommand.add("run");
        postinstallCommand.add("postinstall");
        if (logger.isDebugEnabled()) {
            logger.debug(FrontendUtils.commandToString(this.options.getNpmFolder().getAbsolutePath(), npmInstallCommand));
        }
        String toolName = TaskRunNpmInstall.getToolName(this.options);
        String commandString = npmInstallCommand.stream().collect(Collectors.joining(" "));
        logger.info("using '{}' for frontend package installation", (Object)String.join((CharSequence)" ", npmInstallCommand));
        File packageLockFile = this.packageUpdater.getPackageLockFile();
        if (!(this.options.isEnableBun() || this.options.isEnablePnpm() || packageLockFile.exists())) {
            this.packageUpdater.log().warn("package-lock.json is missing from this project. This may cause the npm package installation to take several minutes. It is recommended to keep the package-lock.json file persistently in your project. Please stand by...");
        }
        Process process = null;
        try {
            process = this.runNpmCommand(npmInstallCommand, this.options.getNpmFolder());
            logger.debug("Output of `{}`:", (Object)commandString);
            StringBuilder toolOutput = new StringBuilder();
            this.consumeProcessOutput(process, stdoutLine -> {
                logger.debug(stdoutLine);
                toolOutput.append((String)stdoutLine).append(System.lineSeparator());
            });
            int errorCode = process.waitFor();
            if (errorCode != 0) {
                logger.error("Command `{}` failed:\n{}", (Object)commandString, (Object)toolOutput);
                logger.error(">>> Dependency ERROR. Check that all required dependencies are deployed in {} repositories.", (Object)toolName);
                throw new ExecutionFailedException(SharedUtil.capitalize(toolName) + " install has exited with non zero status. Some dependencies are not installed. Check " + toolName + " command output");
            }
            logger.info("Frontend dependencies resolved successfully.");
        }
        catch (IOException | UncheckedIOException | InterruptedException e) {
            logger.error("Error when running `{} install`", (Object)toolName, (Object)e);
            Throwable cause = e;
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            if (e instanceof UncheckedIOException) {
                cause = e.getCause();
            }
            throw new ExecutionFailedException("Command '" + toolName + " install' failed to finish", cause);
        }
        finally {
            if (process != null) {
                process.destroyForcibly();
            }
        }
        ArrayList<String> postinstallPackages = new ArrayList<String>();
        postinstallPackages.add(".");
        postinstallPackages.add("esbuild");
        postinstallPackages.add("@vaadin/vaadin-usage-statistics");
        postinstallPackages.addAll(this.options.getPostinstallPackages());
        for (String postinstallPackage : postinstallPackages) {
            File packageFolder;
            block33: {
                File packageJsonFile = this.getPackageJsonForModule(postinstallPackage);
                if (packageJsonFile == null || !packageJsonFile.exists()) continue;
                packageFolder = packageJsonFile.getParentFile();
                try {
                    ObjectNode packageJson = TaskGeneratePackageJson.getJsonFileContent(packageJsonFile);
                    if (!this.containsPostinstallScript((JsonNode)packageJson)) {
                        logger.debug("Skipping postinstall for '{}' as no postinstall script was found in the package.json", (Object)postinstallPackage);
                    }
                    break block33;
                }
                catch (IOException ioe) {
                    logger.error("Couldn't read package.json for {}. Skipping postinstall", (Object)postinstallPackage, (Object)ioe);
                }
                continue;
            }
            logger.debug("Running postinstall for '{}'", (Object)postinstallPackage);
            try {
                process = this.runNpmCommand(postinstallCommand, packageFolder);
                logger.debug("Output of postinstall `{}`:", (Object)postinstallPackage);
                this.consumeProcessOutput(process, arg_0 -> ((Logger)logger).debug(arg_0));
                process.waitFor();
            }
            catch (IOException | InterruptedException e) {
                if (e instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                throw new ExecutionFailedException("Error when running postinstall script for '" + postinstallPackage + "'", e);
            }
        }
    }

    static String getToolName(Options options) {
        if (options.isEnableBun()) {
            return "bun";
        }
        if (options.isEnablePnpm()) {
            return "pnpm";
        }
        return "npm";
    }

    private void consumeProcessOutput(Process process, Consumer<String> consumer) throws IOException, InterruptedException {
        try {
            Pair<String, String> outputs = FrontendUtils.consumeProcessStreams(process).get();
            outputs.getFirst().lines().forEach(consumer);
        }
        catch (ExecutionException e) {
            Throwable cause = e;
            if (e.getCause() != null) {
                cause = e.getCause();
            }
            if (cause instanceof IOException) {
                IOException ioException = (IOException)cause;
                throw ioException;
            }
            throw new IOException(cause);
        }
    }

    private File getPackageJsonForModule(String module) {
        if (module.trim().equals("")) {
            return null;
        }
        if (module.equals(".")) {
            return new File(this.options.getNpmFolder(), "package.json");
        }
        return new File(new File(this.options.getNodeModulesFolder(), module), "package.json");
    }

    private boolean containsPostinstallScript(JsonNode packageJson) {
        return packageJson != null && packageJson.has("scripts") && packageJson.get("scripts").has("postinstall");
    }

    private Process runNpmCommand(List<String> command, File workingDirectory) throws IOException {
        ProcessBuilder builder = FrontendUtils.createProcessBuilder(command);
        builder.environment().put("ADBLOCK", "1");
        builder.environment().put("NO_UPDATE_NOTIFIER", "1");
        builder.directory(workingDirectory);
        builder.redirectInput(ProcessBuilder.Redirect.PIPE);
        builder.redirectErrorStream(true);
        Process process = builder.start();
        Runtime.getRuntime().addShutdownHook(new Thread(process::destroyForcibly));
        return process;
    }

    private void createNpmRcFile() throws IOException {
        boolean shouldWrite;
        File npmrcFile = new File(this.options.getNpmFolder().getAbsolutePath(), ".npmrc");
        if (npmrcFile.exists()) {
            List lines = FileUtils.readLines((File)npmrcFile, (Charset)StandardCharsets.UTF_8);
            if (lines.stream().anyMatch(line -> line.contains("NOTICE: this is an auto-generated file"))) {
                shouldWrite = true;
            } else {
                if (lines.stream().noneMatch(line -> line.contains("shamefully-hoist"))) {
                    String message = "Custom .npmrc file ({}) found in project; pnpm package installation may require passing the --shamefully-hoist flag";
                    this.packageUpdater.log().info(message, (Object)npmrcFile);
                }
                shouldWrite = false;
            }
        } else {
            shouldWrite = true;
        }
        if (shouldWrite) {
            try (InputStream content = TaskRunNpmInstall.class.getResourceAsStream("/npmrc");){
                if (content == null) {
                    throw new IOException("Couldn't find template npmrc in the classpath");
                }
                FileUtils.copyInputStreamToFile((InputStream)content, (File)npmrcFile);
                this.packageUpdater.log().debug("Generated pnpm configuration: '{}'", (Object)npmrcFile);
            }
        }
    }

    private void cleanUp() throws ExecutionFailedException {
        if (!this.options.getNodeModulesFolder().exists()) {
            return;
        }
        if (this.options.isCiBuild()) {
            this.deleteNodeModules(this.options.getNodeModulesFolder());
        } else {
            File staging;
            boolean hasModulesYaml;
            File modulesYaml = new File(this.options.getNodeModulesFolder(), MODULES_YAML);
            boolean bl = hasModulesYaml = modulesYaml.exists() && modulesYaml.isFile();
            if (!this.options.isEnablePnpm() && hasModulesYaml) {
                this.deleteNodeModules(this.options.getNodeModulesFolder());
            } else if (!(!this.options.isEnablePnpm() || hasModulesYaml || (staging = new File(this.options.getNodeModulesFolder(), ".staging")).isDirectory() && staging.listFiles((dir, name) -> name.startsWith("pnpm-")).length != 0)) {
                this.deleteNodeModules(this.options.getNodeModulesFolder());
            }
        }
    }

    private void deleteNodeModules(File nodeModulesFolder) throws ExecutionFailedException {
        try {
            FrontendUtils.deleteNodeModules(nodeModulesFolder);
        }
        catch (IOException exception) {
            Logger log = this.packageUpdater.log();
            log.debug("Exception removing node_modules", (Throwable)exception);
            log.error("Failed to remove '" + this.options.getNodeModulesFolder().getAbsolutePath() + "'. Please remove it manually.");
            throw new ExecutionFailedException("Exception removing node_modules. Please remove it manually.");
        }
    }

    private void validateInstalledNpm(FrontendTools tools) throws IllegalStateException {
        File npmCacheDir = null;
        try {
            npmCacheDir = tools.getNpmCacheDir();
        }
        catch (FrontendUtils.CommandExecutionException | IllegalStateException e) {
            this.packageUpdater.log().warn("Failed to get npm cache directory", (Throwable)e);
        }
        if (npmCacheDir != null && !tools.folderIsAcceptableByNpm(npmCacheDir)) {
            throw new IllegalStateException(String.format(NPM_VALIDATION_FAIL_MESSAGE, new Object[0]));
        }
    }
}

