/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;

public class JavaScriptSemantics {
    private JavaScriptSemantics() {
    }

    public static boolean isTrueish(Object value) {
        if (value == null || value instanceof NullNode) {
            return false;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof ObjectNode) {
            return ((JsonNode)value).asBoolean(true);
        }
        if (value instanceof JsonNode) {
            return ((JsonNode)value).asBoolean();
        }
        if (value instanceof Number) {
            double number = ((Number)value).doubleValue();
            return !Double.isNaN(number) && Double.doubleToLongBits(number) != 0L;
        }
        if (value instanceof String) {
            return !((String)value).isEmpty();
        }
        throw new IllegalStateException("Unsupported type: " + value.getClass());
    }
}

