/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.core.util.Separators;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BaseJsonNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.ValueNode;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.vaadin.flow.internal.JsonDecodingException;
import elemental.json.Json;
import elemental.json.JsonArray;
import elemental.json.JsonBoolean;
import elemental.json.JsonNull;
import elemental.json.JsonNumber;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.DoubleStream;
import java.util.stream.Stream;

public final class JacksonUtils {
    private static final String CANNOT_CONVERT_NULL_TO_A_JSON_OBJECT = "Cannot convert null to JSON";
    private static final String CANNOT_CONVERT_NULL_TO_OBJECT = "Cannot convert null to Java object";
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private static final Set<Collector.Characteristics> arrayCollectorCharacteristics;

    public static ObjectMapper getMapper() {
        return objectMapper;
    }

    public static ObjectNode createObjectNode() {
        return objectMapper.createObjectNode();
    }

    public static ArrayNode createArrayNode() {
        return objectMapper.createArrayNode();
    }

    public static ValueNode nullNode() {
        return (ValueNode)objectMapper.nullNode();
    }

    public static ArrayNode mapElemental(JsonArray jsonArray) {
        if (jsonArray == null || jsonArray instanceof JsonNull) {
            return null;
        }
        try {
            return (ArrayNode)objectMapper.readTree(jsonArray.toJson());
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static ObjectNode mapElemental(JsonObject jsonObject) {
        if (jsonObject == null) {
            return null;
        }
        try {
            return (ObjectNode)objectMapper.readTree(jsonObject.toJson());
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static BaseJsonNode mapElemental(JsonValue jsonValue) {
        if (jsonValue == null || jsonValue instanceof JsonNull) {
            return JacksonUtils.nullNode();
        }
        if (jsonValue instanceof JsonObject) {
            return JacksonUtils.mapElemental((JsonObject)jsonValue);
        }
        if (jsonValue instanceof JsonArray) {
            return JacksonUtils.mapElemental((JsonArray)jsonValue);
        }
        if (jsonValue instanceof JsonNumber) {
            return (BaseJsonNode)objectMapper.valueToTree((Object)jsonValue.asNumber());
        }
        if (jsonValue instanceof JsonBoolean) {
            return (BaseJsonNode)objectMapper.valueToTree((Object)jsonValue.asBoolean());
        }
        return (BaseJsonNode)objectMapper.valueToTree((Object)jsonValue.asString());
    }

    public static JsonArray createElementalArray(ArrayNode jsonNodes) {
        return (JsonArray)JacksonUtils.parseNode((JsonNode)jsonNodes);
    }

    private static JsonValue parseNode(JsonNode node) {
        if (node instanceof ArrayNode) {
            JsonArray jsonArray = Json.createArray();
            node.forEach(arrayNode -> JacksonUtils.parseArrayNode(arrayNode, jsonArray));
            return jsonArray;
        }
        return Json.parse((String)node.toString());
    }

    private static void parseArrayNode(JsonNode node, JsonArray jsonArray) {
        if (JsonNodeType.NUMBER.equals((Object)node.getNodeType())) {
            jsonArray.set(jsonArray.length(), (JsonValue)Json.create((double)node.doubleValue()));
        } else if (JsonNodeType.STRING.equals((Object)node.getNodeType())) {
            jsonArray.set(jsonArray.length(), (JsonValue)Json.create((String)node.textValue()));
        } else if (JsonNodeType.ARRAY.equals((Object)node.getNodeType())) {
            JsonArray array = Json.createArray();
            node.forEach(arrayNode -> JacksonUtils.parseArrayNode(arrayNode, array));
            jsonArray.set(jsonArray.length(), (JsonValue)array);
        } else if (JsonNodeType.BOOLEAN.equals((Object)node.getNodeType())) {
            jsonArray.set(jsonArray.length(), (JsonValue)Json.create((boolean)node.booleanValue()));
        } else if (JsonNodeType.NULL.equals((Object)node.getNodeType())) {
            jsonArray.set(jsonArray.length(), (JsonValue)Json.createNull());
        } else {
            jsonArray.set(jsonArray.length(), (JsonValue)Json.parse((String)node.toString()));
        }
    }

    public static ObjectNode readTree(String json) {
        try {
            return (ObjectNode)objectMapper.readTree(json);
        }
        catch (JsonProcessingException e) {
            throw new JsonDecodingException("Could not parse json content", e);
        }
    }

    public static JsonNode createNode(Object value) {
        return objectMapper.valueToTree(value);
    }

    private JacksonUtils() {
    }

    public static boolean jsonEquals(JsonNode a, JsonNode b) {
        assert (a != null);
        assert (b != null);
        if (a == b) {
            return true;
        }
        JsonNodeType type = a.getNodeType();
        if (type != b.getNodeType()) {
            return false;
        }
        return switch (type) {
            case JsonNodeType.NULL -> true;
            case JsonNodeType.BOOLEAN -> JacksonUtils.booleanEqual(a, b);
            case JsonNodeType.NUMBER -> JacksonUtils.numbersEqual(a, b);
            case JsonNodeType.STRING -> JacksonUtils.stringEqual(a, b);
            case JsonNodeType.OBJECT -> JacksonUtils.jsonObjectEquals(a, b);
            case JsonNodeType.ARRAY -> JacksonUtils.jsonArrayEquals((ArrayNode)a, (ArrayNode)b);
            default -> throw new IllegalArgumentException("Unsupported JsonType: " + type);
        };
    }

    public static boolean stringEqual(JsonNode a, JsonNode b) {
        assert (a.getNodeType() == JsonNodeType.STRING);
        assert (b.getNodeType() == JsonNodeType.STRING);
        return a.asText().equals(b.asText());
    }

    public static boolean booleanEqual(JsonNode a, JsonNode b) {
        assert (a.getNodeType() == JsonNodeType.BOOLEAN);
        assert (b.getNodeType() == JsonNodeType.BOOLEAN);
        return a.asBoolean() == b.asBoolean();
    }

    public static boolean numbersEqual(JsonNode a, JsonNode b) {
        assert (a.getNodeType() == JsonNodeType.NUMBER);
        assert (b.getNodeType() == JsonNodeType.NUMBER);
        return Double.doubleToRawLongBits(a.doubleValue()) == Double.doubleToRawLongBits(b.doubleValue());
    }

    private static boolean jsonObjectEquals(JsonNode a, JsonNode b) {
        assert (a != null);
        assert (b != null);
        if (a == b) {
            return true;
        }
        List<String> keys = JacksonUtils.getKeys(a);
        List<String> bkeys = JacksonUtils.getKeys(b);
        if (keys.size() != bkeys.size()) {
            return false;
        }
        for (String key : keys) {
            JsonNode value = b.get(key);
            if (value != null && JacksonUtils.jsonEquals(a.get(key), value)) continue;
            return false;
        }
        return true;
    }

    public static List<String> getKeys(JsonNode node) {
        ArrayList<String> keys = new ArrayList<String>();
        node.fieldNames().forEachRemaining(keys::add);
        return keys;
    }

    private static boolean jsonArrayEquals(ArrayNode a, ArrayNode b) {
        assert (a != null);
        assert (b != null);
        if (a == b) {
            return true;
        }
        if (a.size() != b.size()) {
            return false;
        }
        for (int i = 0; i < a.size(); ++i) {
            if (JacksonUtils.jsonEquals(a.get(i), b.get(i))) continue;
            return false;
        }
        return true;
    }

    public static <T extends JsonNode> Stream<T> stream(final ArrayNode array) {
        if (array == null) {
            return Stream.empty();
        }
        return new AbstractList<T>(){

            @Override
            public T get(int index) {
                return array.get(index);
            }

            @Override
            public int size() {
                return array.size();
            }
        }.stream();
    }

    public static Stream<JsonNode> objectStream(ArrayNode array) {
        return JacksonUtils.stream(array);
    }

    public static DoubleStream numberStream(ArrayNode array) {
        return JacksonUtils.stream(array).mapToDouble(DoubleNode::doubleValue);
    }

    public static Collector<JsonNode, ArrayNode, ArrayNode> asArray() {
        return new ArrayNodeCollector();
    }

    public static ArrayNode createArray(JsonNode ... values) {
        return Stream.of(values).collect(JacksonUtils.asArray());
    }

    public static <T> ObjectNode createObject(Map<String, T> map, Function<T, JsonNode> itemToJson) {
        ObjectNode object = objectMapper.createObjectNode();
        map.forEach((key, value) -> object.put(key, (JsonNode)itemToJson.apply(value)));
        return object;
    }

    public static ObjectNode beanToJson(Object bean) {
        Objects.requireNonNull(bean, CANNOT_CONVERT_NULL_TO_A_JSON_OBJECT);
        return (ObjectNode)objectMapper.valueToTree(bean);
    }

    public static ArrayNode listToJson(List<?> list) {
        Objects.requireNonNull(list, CANNOT_CONVERT_NULL_TO_A_JSON_OBJECT);
        return (ArrayNode)objectMapper.valueToTree(list);
    }

    public static ObjectNode mapToJson(Map<String, ?> map) {
        Objects.requireNonNull(map, CANNOT_CONVERT_NULL_TO_A_JSON_OBJECT);
        return (ObjectNode)objectMapper.valueToTree(map);
    }

    public static <T> T readToObject(JsonNode jsonObject, Class<T> tClass) {
        Objects.requireNonNull(jsonObject, CANNOT_CONVERT_NULL_TO_OBJECT);
        try {
            return (T)objectMapper.treeToValue((TreeNode)jsonObject, tClass);
        }
        catch (JsonProcessingException e) {
            throw new JsonDecodingException("Error converting JsonObject to " + tClass.getName(), e);
        }
    }

    public static <T> T readValue(JsonNode jsonValue, Class<T> tClass) {
        return JacksonUtils.readToObject(jsonValue, tClass);
    }

    public static <T> T readValue(JsonNode jsonValue, TypeReference<T> typeReference) {
        Objects.requireNonNull(jsonValue, CANNOT_CONVERT_NULL_TO_OBJECT);
        try {
            return (T)objectMapper.treeToValue((TreeNode)jsonValue, typeReference);
        }
        catch (JsonProcessingException e) {
            throw new JsonDecodingException("Error converting ObjectNode to " + typeReference.getType().getTypeName(), e);
        }
    }

    public static BaseJsonNode writeValue(Object object) {
        return (BaseJsonNode)objectMapper.valueToTree(object);
    }

    public static String toFileJson(JsonNode node) throws JsonProcessingException {
        DefaultPrettyPrinter filePrinter = new DefaultPrettyPrinter(Separators.createDefaultInstance().withObjectFieldValueSpacing(Separators.Spacing.AFTER));
        return objectMapper.writer().with((PrettyPrinter)filePrinter).writeValueAsString((Object)node);
    }

    static {
        objectMapper.registerModule((Module)new JavaTimeModule()).enable(new JsonParser.Feature[]{JsonParser.Feature.ALLOW_SINGLE_QUOTES});
        arrayCollectorCharacteristics = Collections.unmodifiableSet(EnumSet.of(Collector.Characteristics.IDENTITY_FINISH));
    }

    private static final class ArrayNodeCollector
    implements Collector<JsonNode, ArrayNode, ArrayNode> {
        private ArrayNodeCollector() {
        }

        @Override
        public Supplier<ArrayNode> supplier() {
            return () -> ((ObjectMapper)objectMapper).createArrayNode();
        }

        @Override
        public BiConsumer<ArrayNode, JsonNode> accumulator() {
            return ArrayNode::add;
        }

        @Override
        public BinaryOperator<ArrayNode> combiner() {
            return (left, right) -> {
                for (int i = 0; i < right.size(); ++i) {
                    left.add(right.get(i));
                }
                return left;
            };
        }

        @Override
        public Function<ArrayNode, ArrayNode> finisher() {
            return Function.identity();
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            return arrayCollectorCharacteristics;
        }
    }
}

