/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.BaseJsonNode;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.webcomponent.PropertyConfiguration;
import com.vaadin.flow.component.webcomponent.WebComponent;
import com.vaadin.flow.component.webcomponent.WebComponentConfiguration;
import com.vaadin.flow.di.Instantiator;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.internal.JacksonUtils;
import com.vaadin.flow.internal.ReflectTools;
import com.vaadin.flow.server.webcomponent.PropertyConfigurationImpl;
import com.vaadin.flow.server.webcomponent.PropertyData;
import com.vaadin.flow.server.webcomponent.UnsupportedPropertyTypeException;
import com.vaadin.flow.server.webcomponent.WebComponentBinding;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class WebComponentExporter<C extends Component>
implements Serializable {
    private static final List<Class> SUPPORTED_TYPES = Collections.unmodifiableList(Arrays.asList(Boolean.class, String.class, Integer.class, Double.class, BaseJsonNode.class));
    private final String tag;
    private HashMap<String, PropertyConfigurationImpl<C, ? extends Serializable>> propertyConfigurationMap = new HashMap();
    private boolean isConfigureInstanceCall;

    protected WebComponentExporter(String tag) {
        if (tag == null) {
            throw new NullTagException("Parameter 'tag' must not be null!");
        }
        this.tag = tag;
        if (this.getComponentClass() == null) {
            throw new IllegalStateException(String.format("Failed to determine component type for '%s'. Please provide a valid type for %s as a type parameter.", this.getClass().getName(), WebComponentExporter.class.getSimpleName()));
        }
    }

    private <P extends Serializable> PropertyConfiguration<C, P> addProperty(String name, Class<P> type, P defaultValue) {
        Objects.requireNonNull(name, "Parameter 'name' cannot be null!");
        Objects.requireNonNull(type, "Parameter 'type' cannot be null!");
        if (this.isConfigureInstanceCall) {
            throw new IllegalStateException("The 'addProperty' method cannot be called within the 'configureInstance' method. All properties have to be configured in the " + this.getClass().getName() + " class constructor.");
        }
        if (!WebComponentExporter.isSupportedType(type)) {
            throw new UnsupportedPropertyTypeException(String.format("PropertyConfiguration cannot handle type %s. Use any of %s instead.", type.getCanonicalName(), SUPPORTED_TYPES.stream().map(Class::getSimpleName).collect(Collectors.joining(", "))));
        }
        PropertyConfigurationImpl<C, P> propertyConfigurationImpl = new PropertyConfigurationImpl<C, P>(this.getComponentClass(), name, type, defaultValue);
        this.propertyConfigurationMap.put(name, propertyConfigurationImpl);
        return propertyConfigurationImpl;
    }

    public final PropertyConfiguration<C, Integer> addProperty(String name, int defaultValue) {
        return this.addProperty(name, Integer.class, defaultValue);
    }

    public final PropertyConfiguration<C, Double> addProperty(String name, double defaultValue) {
        return this.addProperty(name, Double.class, defaultValue);
    }

    public final PropertyConfiguration<C, String> addProperty(String name, String defaultValue) {
        return this.addProperty(name, String.class, defaultValue);
    }

    public final PropertyConfiguration<C, Boolean> addProperty(String name, boolean defaultValue) {
        return this.addProperty(name, Boolean.class, defaultValue);
    }

    public final PropertyConfiguration<C, BaseJsonNode> addProperty(String name, BaseJsonNode defaultValue) {
        return this.addProperty(name, BaseJsonNode.class, defaultValue);
    }

    protected abstract void configureInstance(WebComponent<C> var1, C var2);

    public final void preConfigure() {
        this.isConfigureInstanceCall = true;
    }

    public final void postConfigure() {
        this.isConfigureInstanceCall = false;
    }

    public final String getTag() {
        return this.tag;
    }

    private static boolean isSupportedType(Class clazz) {
        return SUPPORTED_TYPES.contains(clazz);
    }

    protected Class<C> getComponentClass() {
        return ReflectTools.getGenericInterfaceType(this.getClass(), WebComponentExporter.class);
    }

    static class NullTagException
    extends NullPointerException {
        NullTagException(String msg) {
            super(msg);
        }
    }

    public static final class WebComponentConfigurationFactory
    implements Serializable {
        public <T extends Component> WebComponentConfiguration<T> create(WebComponentExporter<T> exporter) {
            Objects.requireNonNull(exporter, "Parameter 'exporter' cannot be null!");
            return new WebComponentConfigurationImpl<T>(exporter);
        }
    }

    private static final class WebComponentConfigurationImpl<C extends Component>
    implements WebComponentConfiguration<C> {
        private WebComponentExporter<C> exporter;
        private final Map<String, PropertyConfigurationImpl<C, ? extends Serializable>> immutablePropertyMap;

        private WebComponentConfigurationImpl(WebComponentExporter<C> exporter) {
            this.exporter = exporter;
            WebComponentExporter<C> wcExporter = exporter;
            this.immutablePropertyMap = Collections.unmodifiableMap(wcExporter.propertyConfigurationMap);
        }

        @Override
        public boolean hasProperty(String propertyName) {
            return this.immutablePropertyMap.containsKey(propertyName);
        }

        @Override
        public Class<? extends Serializable> getPropertyType(String propertyName) {
            if (this.hasProperty(propertyName)) {
                return this.immutablePropertyMap.get(propertyName).getPropertyData().getType();
            }
            return null;
        }

        @Override
        public Class<C> getComponentClass() {
            return this.exporter.getComponentClass();
        }

        @Override
        public Set<PropertyData<? extends Serializable>> getPropertyDataSet() {
            return this.immutablePropertyMap.values().stream().map(PropertyConfigurationImpl::getPropertyData).collect(Collectors.toSet());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public WebComponentBinding<C> createWebComponentBinding(Instantiator instantiator, Element element, JsonNode newAttributeDefaults) {
            assert (instantiator != null);
            C componentReference = instantiator.createComponent(this.getComponentClass());
            if (componentReference == null) {
                throw new RuntimeException("Failed to instantiate a new " + this.getComponentClass().getCanonicalName());
            }
            String componentTag = ((Component)componentReference).getElement().getTag();
            if (this.exporter.getTag().equals(componentTag)) {
                throw new IllegalStateException(String.format("WebComponentExporter '%s' cannot share a tag with the %s instance being exported! Change the tag from '%s' to something else.", this.getClass().getCanonicalName(), componentReference.getClass().getCanonicalName(), this.exporter.getTag()));
            }
            WebComponentBinding binding = new WebComponentBinding(componentReference);
            Map<String, JsonNode> newDefaultValues = JacksonUtils.getKeys(newAttributeDefaults).stream().collect(Collectors.toMap(key -> key, arg_0 -> ((JsonNode)newAttributeDefaults).get(arg_0)));
            this.immutablePropertyMap.values().forEach(propertyConfiguration -> {
                String key = propertyConfiguration.getPropertyData().getName();
                binding.bindProperty((PropertyConfigurationImpl)propertyConfiguration, newDefaultValues.containsKey(key), (JsonNode)newDefaultValues.get(key));
            });
            this.exporter.preConfigure();
            try {
                this.exporter.configureInstance(new WebComponent(binding, element), binding.getComponent());
            }
            finally {
                this.exporter.postConfigure();
            }
            binding.updatePropertiesToComponent();
            return binding;
        }

        @Override
        public String getTag() {
            return this.exporter.getTag();
        }

        @Override
        public Class<? extends WebComponentExporter<C>> getExporterClass() {
            return this.exporter.getClass();
        }

        public int hashCode() {
            Object[] objs = new Object[this.immutablePropertyMap.size() + 1];
            objs[0] = this.getTag();
            int place = 1;
            for (PropertyConfiguration propertyConfiguration : this.immutablePropertyMap.values()) {
                objs[place] = propertyConfiguration;
                ++place;
            }
            return Objects.hash(objs);
        }

        public boolean equals(Object obj) {
            if (obj instanceof WebComponentConfigurationImpl) {
                WebComponentConfigurationImpl other = (WebComponentConfigurationImpl)obj;
                boolean isSame = this.getTag().equals(other.getTag());
                boolean bl = isSame = isSame && this.immutablePropertyMap.size() == other.immutablePropertyMap.size();
                if (!isSame) {
                    return false;
                }
                for (String key : this.immutablePropertyMap.keySet()) {
                    PropertyConfiguration otherConf = other.immutablePropertyMap.get(key);
                    if (this.immutablePropertyMap.get(key).equals(otherConf)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
    }
}

