/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.webcomponent;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BaseJsonNode;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.WebComponentExporter;
import com.vaadin.flow.component.WebComponentExporterFactory;
import com.vaadin.flow.component.webcomponent.WebComponentConfiguration;
import com.vaadin.flow.server.webcomponent.PropertyData;
import com.vaadin.flow.server.webcomponent.UnsupportedPropertyTypeException;
import com.vaadin.flow.shared.util.SharedUtil;
import elemental.json.JsonArray;
import elemental.json.JsonValue;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.io.IOUtils;

public class WebComponentGenerator {
    private static final String TOKEN_DEFAULT_VALUE = "_DefaultValue_";
    private static final String TOKEN_JS_TYPE = "_JSType_";
    private static final String TOKEN_ATTRIBUTE_NAME = "_AttributeName_";
    private static final String TOKEN_CHANGE_EVENT_NAME = "_ChangeEventName_";
    private static final String TOKEN_PROPERTY_NAME = "_PropertyName_";
    private static final String JS_TEMPLATE = "webcomponent-template.js";
    private static final String SCRIPT_TEMPLATE = "webcomponent-script-template.js";
    private static final String CODE_PROPERTY_DEFAULT = "webcomponent-property-default.js";
    private static final String CODE_PROPERTY_VALUES = "webcomponent-property-values.js";
    private static final String CODE_ATTRIBUTE_CHANGE = "webcomponent-attribute-change.js";
    private static final String CODE_PROPERTY_METHODS = "webcomponent-property-methods.js";

    private WebComponentGenerator() {
    }

    private static String getStringResource(String name) {
        String string;
        block8: {
            InputStream resourceStream = WebComponentGenerator.class.getResourceAsStream(name);
            try {
                string = IOUtils.toString((InputStream)resourceStream, (Charset)StandardCharsets.UTF_8);
                if (resourceStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (resourceStream != null) {
                        try {
                            resourceStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Couldn't load string resource '" + name + "'!", e);
                }
            }
            resourceStream.close();
        }
        return string;
    }

    private static String getTemplate() {
        String templateHead = WebComponentGenerator.getStringResource(JS_TEMPLATE);
        String scriptTemplate = WebComponentGenerator.getStringResource(SCRIPT_TEMPLATE);
        return templateHead.replace("_script_template_", scriptTemplate);
    }

    public static String generateModule(WebComponentExporterFactory<? extends Component> factory, String frontendURI, String themeName) {
        Objects.requireNonNull(factory);
        Objects.requireNonNull(frontendURI);
        WebComponentConfiguration<? extends Component> config = new WebComponentExporter.WebComponentConfigurationFactory().create(factory.create());
        return WebComponentGenerator.generateModule(config, frontendURI, false, themeName);
    }

    public static String generateModule(WebComponentConfiguration<? extends Component> webComponentConfiguration, String frontendURI, String themeName) {
        Objects.requireNonNull(webComponentConfiguration);
        Objects.requireNonNull(frontendURI);
        return WebComponentGenerator.generateModule(webComponentConfiguration, frontendURI, true, themeName);
    }

    private static String generateModule(WebComponentConfiguration<? extends Component> webComponentConfiguration, String frontendURI, boolean generateUiImport, String themeName) {
        Objects.requireNonNull(webComponentConfiguration);
        Objects.requireNonNull(frontendURI);
        Set<PropertyData<? extends Serializable>> propertyDataSet = webComponentConfiguration.getPropertyDataSet();
        Map<String, String> replacements = WebComponentGenerator.getReplacementsMap(webComponentConfiguration.getTag(), propertyDataSet, frontendURI, generateUiImport, themeName);
        String template = WebComponentGenerator.getTemplate();
        for (Map.Entry<String, String> replacement : replacements.entrySet()) {
            template = template.replace("_" + replacement.getKey() + "_", replacement.getValue());
        }
        return template;
    }

    static Map<String, String> getReplacementsMap(String tag, Set<PropertyData<? extends Serializable>> propertyDataSet, String frontendURI, boolean generateUiImport, String themeName) {
        HashMap<String, String> replacements = new HashMap<String, String>();
        if (themeName != null && !themeName.isEmpty()) {
            replacements.put("ThemeImport", "import {applyTheme} from 'Frontend/generated/theme.js';\n\n");
            replacements.put("ApplyTheme", "applyTheme(shadow);\n    ");
        } else {
            replacements.put("ThemeImport", "import {applyCss} from 'Frontend/generated/css.generated.js';\n\n");
            replacements.put("ApplyTheme", "applyCss(shadow);\n    ");
        }
        replacements.put("TagDash", tag);
        replacements.put("TagCamel", SharedUtil.capitalize(SharedUtil.dashSeparatedToCamelCase(tag)));
        replacements.put("AttributeChange", WebComponentGenerator.getAttributeChange(WebComponentGenerator.getStringResource(CODE_ATTRIBUTE_CHANGE), propertyDataSet));
        replacements.put("PropertyMethods", WebComponentGenerator.getPropertyMethods(WebComponentGenerator.getStringResource(CODE_PROPERTY_METHODS), propertyDataSet));
        replacements.put("PropertyDefaults", WebComponentGenerator.getPropertyDefaults(WebComponentGenerator.getStringResource(CODE_PROPERTY_DEFAULT), propertyDataSet));
        replacements.put("PropertyValues", WebComponentGenerator.getPropertyValues(WebComponentGenerator.getStringResource(CODE_PROPERTY_VALUES), propertyDataSet));
        replacements.put("frontend_resources", frontendURI);
        replacements.put("ui_import", generateUiImport ? "<link rel='import' href='web-component-ui.html'>" : "");
        return replacements;
    }

    private static String getPropertyMethods(String codePropertyMethods, Set<PropertyData<?>> properties) {
        StringBuilder setters = new StringBuilder();
        for (PropertyData<?> property : properties) {
            setters.append(WebComponentGenerator.createPropertySetterGetter(codePropertyMethods, property));
        }
        return setters.toString();
    }

    private static String getPropertyDefaults(String codePropertyDefault, Set<PropertyData<?>> properties) {
        StringBuilder setters = new StringBuilder();
        for (PropertyData<?> property : properties) {
            setters.append(WebComponentGenerator.createPropertyDefault(codePropertyDefault, property));
        }
        return setters.toString();
    }

    private static String getPropertyValues(String codePropertyValues, Set<PropertyData<?>> properties) {
        if (properties.isEmpty()) {
            return "{}";
        }
        StringBuilder sync = new StringBuilder();
        sync.append("{");
        for (PropertyData<?> property : properties) {
            sync.append(codePropertyValues.replace(TOKEN_PROPERTY_NAME, property.getName()));
            sync.append(",");
        }
        sync.delete(sync.length() - 1, sync.length());
        sync.append("}");
        return sync.toString();
    }

    private static String getAttributeChange(String codeAttributeChange, Set<PropertyData<?>> properties) {
        StringBuilder sync = new StringBuilder();
        for (PropertyData<?> property : properties) {
            sync.append(codeAttributeChange.replace(TOKEN_ATTRIBUTE_NAME, WebComponentGenerator.getAttributeName(property)).replace(TOKEN_PROPERTY_NAME, property.getName()).replace(TOKEN_JS_TYPE, WebComponentGenerator.getJSTypeName(property)));
        }
        return sync.toString();
    }

    private static String createPropertyDefault(String code, PropertyData<?> property) {
        return code.replace(TOKEN_PROPERTY_NAME, property.getName()).replace(TOKEN_DEFAULT_VALUE, WebComponentGenerator.getDefaultJsValue(property));
    }

    private static String getDefaultJsValue(PropertyData<?> property) {
        Object value;
        if (property.getDefaultValue() == null) {
            value = "undefined";
        } else if (property.getType() == Boolean.class) {
            value = String.valueOf(property.getDefaultValue());
        } else if (property.getType() == Double.class) {
            value = String.valueOf(property.getDefaultValue());
        } else if (property.getType() == Integer.class) {
            value = String.valueOf(property.getDefaultValue());
        } else if (property.getType() == String.class) {
            value = "'" + ((String)property.getDefaultValue()).replaceAll("'", "\\'") + "'";
        } else if (JsonValue.class.isAssignableFrom(property.getType())) {
            value = ((JsonValue)property.getDefaultValue()).toJson();
        } else if (JsonNode.class.isAssignableFrom(property.getType())) {
            value = property.getDefaultValue().toString();
        } else {
            throw new UnsupportedPropertyTypeException(String.format("%s is not a currently supported type for a Property. Please use %s or %s instead.", property.getType().getSimpleName(), JsonNode.class.getSimpleName(), JsonValue.class.getSimpleName()));
        }
        if (value == null) {
            value = "null";
        }
        return value;
    }

    private static String createPropertySetterGetter(String codePropertyMethods, PropertyData<?> property) {
        return codePropertyMethods.replace(TOKEN_PROPERTY_NAME, property.getName()).replace(TOKEN_CHANGE_EVENT_NAME, WebComponentGenerator.getAttributeName(property) + "-changed");
    }

    private static String getAttributeName(PropertyData<?> propertyData) {
        return SharedUtil.camelCaseToDashSeparated(propertyData.getName());
    }

    private static String getJSTypeName(PropertyData<?> propertyData) {
        if (propertyData.getType() == Boolean.class) {
            return "Boolean";
        }
        if (propertyData.getType() == Double.class || propertyData.getType() == Integer.class) {
            return "Number";
        }
        if (propertyData.getType() == String.class) {
            return "String";
        }
        if (JsonArray.class.isAssignableFrom(propertyData.getType()) || ArrayNode.class.isAssignableFrom(propertyData.getType())) {
            return "Array";
        }
        if (JsonValue.class.isAssignableFrom(propertyData.getType()) || BaseJsonNode.class.isAssignableFrom(propertyData.getType())) {
            return "Object";
        }
        throw new IllegalStateException("Unsupported type: " + propertyData.getType());
    }
}

