/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.communication.rpc;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.vaadin.flow.server.communication.rpc.RpcDecodeException;
import com.vaadin.flow.server.communication.rpc.RpcDecoder;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;

public class StringToNumberDecoder
implements RpcDecoder {
    @Override
    public boolean isApplicable(JsonNode value, Class<?> type) {
        return value.getNodeType().equals((Object)JsonNodeType.STRING) && Number.class.isAssignableFrom(type) && type.getPackage().equals(Integer.class.getPackage());
    }

    @Override
    public <T> T decode(JsonNode value, Class<T> type) throws RpcDecodeException {
        String stringValue = value.asText();
        try {
            Number number = this.parseNumber(stringValue);
            if (Number.class.equals(type)) {
                return type.cast(number);
            }
            Field requiredType = type.getField("TYPE");
            Class primitiveRequiredType = (Class)requiredType.get(null);
            Method method = Number.class.getMethod(primitiveRequiredType + "Value", new Class[0]);
            T result = type.cast(method.invoke((Object)number, new Object[0]));
            if (number.equals(this.parseNumber(result.toString()))) {
                return result;
            }
            throw new RpcDecodeException(String.format("Can't decode '%s' to type '%s'", stringValue, type.getName()));
        }
        catch (ParseException exception) {
            throw new RpcDecodeException(exception);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            throw new RuntimeException(exception);
        }
    }

    private Number parseNumber(String value) throws ParseException {
        return NumberFormat.getInstance(Locale.ENGLISH).parse(value);
    }
}

