/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal;

import com.vaadin.flow.internal.MessageDigestUtil;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.UUID;

public final class StringUtil {
    public static String removeComments(String code) {
        return StringUtil.removeComments(code, false);
    }

    public static String removeComments(String code, boolean useStringApostrophe) {
        State state = State.NORMAL;
        StringBuilder result = new StringBuilder();
        HashMap<String, Character> replacements = new HashMap<String, Character>();
        Scanner scanner = new Scanner(StringUtil.normalize(code, replacements));
        scanner.useDelimiter("");
        while (scanner.hasNext()) {
            String character = scanner.next();
            switch (state) {
                case NORMAL: {
                    if (character.equals("/") && scanner.hasNext()) {
                        String nextCharacter = scanner.next();
                        if (nextCharacter.equals("/")) {
                            state = State.IN_LINE_COMMENT;
                            break;
                        }
                        if (nextCharacter.equals("*")) {
                            state = State.IN_BLOCK_COMMENT;
                            break;
                        }
                        result.append(character).append(nextCharacter);
                        break;
                    }
                    result.append(character);
                    if (character.equals("\"")) {
                        state = State.IN_STRING;
                        break;
                    }
                    if (!useStringApostrophe || !character.equals("'")) break;
                    state = State.IN_STRING_APOSTROPHE;
                    break;
                }
                case IN_STRING: {
                    result.append(character);
                    if (character.equals("\"")) {
                        state = State.NORMAL;
                        break;
                    }
                    if (!character.equals("\\") || !scanner.hasNext()) break;
                    result.append(scanner.next());
                    break;
                }
                case IN_STRING_APOSTROPHE: {
                    result.append(character);
                    if (character.equals("'")) {
                        state = State.NORMAL;
                        break;
                    }
                    if (!character.equals("\\") || !scanner.hasNext()) break;
                    result.append(scanner.next());
                    break;
                }
                case IN_LINE_COMMENT: {
                    if (!character.equals("\n")) break;
                    result.append(character);
                    state = State.NORMAL;
                    break;
                }
                case IN_BLOCK_COMMENT: {
                    if (!character.equals("*") || !scanner.hasNext("/")) break;
                    scanner.next();
                    state = State.NORMAL;
                }
            }
        }
        scanner.close();
        String handled = result.toString();
        for (Map.Entry entry : replacements.entrySet()) {
            handled = handled.replace((CharSequence)entry.getKey(), String.valueOf(entry.getValue()));
        }
        return handled;
    }

    private static String normalize(String str, Map<String, Character> replacements) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (!Character.isHighSurrogate(ch) && !Character.isLowSurrogate(ch)) {
                builder.append(str.charAt(i));
                continue;
            }
            String replacement = StringUtil.generateReplacement(str);
            replacements.put(replacement, Character.valueOf(ch));
            builder.append(replacement);
        }
        return builder.toString();
    }

    private static String generateReplacement(String str) {
        String replacement = UUID.randomUUID().toString();
        if (str.contains(replacement)) {
            return StringUtil.generateReplacement(str);
        }
        return replacement;
    }

    public static String stripSuffix(String string, String suffix) {
        if (string.endsWith(suffix)) {
            return string.substring(0, string.length() - suffix.length());
        }
        return string;
    }

    public static String getHash(String content) {
        return StringUtil.getHash(content, StandardCharsets.UTF_16);
    }

    public static String getHash(String content, Charset charset) {
        return StringUtil.getHash(content, null, charset);
    }

    public static String getHash(String content, byte[] salt, Charset charset) {
        if (content == null || content.isEmpty()) {
            return "";
        }
        return StringUtil.bytesToHex(MessageDigestUtil.sha256(content, salt, charset));
    }

    private static String bytesToHex(byte[] hash) {
        StringBuilder result = new StringBuilder();
        for (byte hashByte : hash) {
            String hex = Integer.toHexString(0xFF & hashByte);
            if (hex.length() == 1) {
                result.append('0');
            }
            result.append(hex);
        }
        return result.toString();
    }

    private static enum State {
        NORMAL,
        IN_LINE_COMMENT,
        IN_BLOCK_COMMENT,
        IN_STRING,
        IN_STRING_APOSTROPHE;

    }
}

