/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.vaadin.flow.component.JsonSerializable;
import com.vaadin.flow.internal.JacksonUtils;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.RecordComponent;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public final class JacksonSerializer {
    private JacksonSerializer() {
    }

    public static JsonNode toJson(Object bean) {
        if (bean == null) {
            return JacksonUtils.nullNode();
        }
        if (bean instanceof Collection) {
            return JacksonSerializer.toJson((Collection)bean);
        }
        if (bean.getClass().isArray()) {
            return JacksonSerializer.toJsonArray(bean);
        }
        if (bean instanceof JsonSerializable) {
            return ((JsonSerializable)bean).toJson();
        }
        Optional<JsonNode> simpleType = JacksonSerializer.tryToConvertToSimpleType(bean);
        if (simpleType.isPresent()) {
            return simpleType.get();
        }
        try {
            ObjectNode json = JacksonUtils.createObjectNode();
            Class<?> type = bean.getClass();
            if (type.isRecord()) {
                for (RecordComponent rc : type.getRecordComponents()) {
                    json.put(rc.getName(), JacksonSerializer.toJson(rc.getAccessor().invoke(bean, new Object[0])));
                }
            } else {
                BeanInfo info = Introspector.getBeanInfo(type);
                for (PropertyDescriptor pd : info.getPropertyDescriptors()) {
                    Method reader;
                    if ("class".equals(pd.getName()) || (reader = pd.getReadMethod()) == null) continue;
                    json.put(pd.getName(), JacksonSerializer.toJson(reader.invoke(bean, new Object[0])));
                }
            }
            return json;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not serialize object of type " + bean.getClass() + " to JsonNode", e);
        }
    }

    public static ArrayNode toJson(Collection<?> beans) {
        ArrayNode array = JacksonUtils.createArrayNode();
        if (beans == null) {
            return array;
        }
        beans.stream().map(JacksonSerializer::toJson).forEachOrdered(json -> array.add(json));
        return array;
    }

    private static ArrayNode toJsonArray(Object javaArray) {
        int length = Array.getLength(javaArray);
        ArrayNode array = JacksonUtils.createArrayNode();
        for (int i = 0; i < length; ++i) {
            array.set(i, JacksonSerializer.toJson(Array.get(javaArray, i)));
        }
        return array;
    }

    private static Optional<JsonNode> tryToConvertToSimpleType(Object bean) {
        if (bean instanceof String) {
            return Optional.of(JacksonUtils.createNode((String)bean));
        }
        if (bean instanceof Number) {
            return Optional.of(JacksonUtils.createNode(((Number)bean).doubleValue()));
        }
        if (bean instanceof Boolean) {
            return Optional.of(JacksonUtils.createNode((Boolean)bean));
        }
        if (bean instanceof Character) {
            return Optional.of(JacksonUtils.createNode(Character.toString(((Character)bean).charValue())));
        }
        if (bean instanceof Enum) {
            return Optional.of(JacksonUtils.createNode(((Enum)bean).name()));
        }
        if (bean instanceof JsonNode) {
            return Optional.of((JsonNode)bean);
        }
        return Optional.empty();
    }

    public static <T> T toObject(Class<T> type, JsonNode json) {
        return JacksonSerializer.toObject(type, null, json);
    }

    private static <T> T toObject(Class<T> type, Type genericType, JsonNode json) {
        T instance;
        if (json == null || json instanceof NullNode) {
            return null;
        }
        Optional<?> simpleType = JacksonSerializer.tryToConvertFromSimpleType(type, json);
        if (simpleType.isPresent()) {
            return (T)simpleType.get();
        }
        if (Collection.class.isAssignableFrom(type)) {
            return JacksonSerializer.toCollection(type, genericType, json);
        }
        if (type.isRecord()) {
            return JacksonSerializer.toRecord(type, json);
        }
        try {
            instance = type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not create an instance of type " + type + ". Make sure it contains a default public constructor and the class is accessible.", e);
        }
        try {
            if (instance instanceof JsonSerializable && json instanceof JsonNode) {
                return type.cast(((JsonSerializable)JsonSerializable.class.cast(instance)).readJson(json));
            }
            JsonNode jsonObject = json;
            List<String> keys = JacksonUtils.getKeys(jsonObject);
            if (keys == null) {
                return instance;
            }
            BeanInfo info = Introspector.getBeanInfo(type);
            HashMap<String, Method> writers = new HashMap<String, Method>();
            for (PropertyDescriptor pd : info.getPropertyDescriptors()) {
                Method writer = pd.getWriteMethod();
                if (writer == null) continue;
                writers.put(pd.getName(), writer);
            }
            for (String key : keys) {
                JsonNode jsonValue = jsonObject.get(key);
                Method method = (Method)writers.get(key);
                if (method == null) continue;
                Class<?> parameterType = method.getParameterTypes()[0];
                Type genericParameterType = method.getGenericParameterTypes()[0];
                Object value = JacksonSerializer.toObject(parameterType, genericParameterType, jsonValue);
                method.invoke(instance, value);
            }
            return instance;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not deserialize object of type " + type + " from JsonNode", e);
        }
    }

    private static <T> T toRecord(Class<T> type, JsonNode json) {
        try {
            RecordComponent[] components = type.getRecordComponents();
            Class[] componentTypes = new Class[components.length];
            Object[] values = new Object[components.length];
            for (int i = 0; i < components.length; ++i) {
                componentTypes[i] = components[i].getType();
                values[i] = JacksonSerializer.toObject(componentTypes[i], json.get(components[i].getName()));
            }
            return type.getDeclaredConstructor(componentTypes).newInstance(values);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not deserialize record of type " + type + " from JsonNode", e);
        }
    }

    private static <T> T toCollection(Class<T> type, Type genericType, JsonNode json) {
        if (json.getNodeType() != JsonNodeType.ARRAY) {
            return null;
        }
        if (!(genericType instanceof ParameterizedType)) {
            throw new IllegalArgumentException("Cloud not infer the generic parameterized type of the collection of class: " + type.getName() + ". The type is no subclass of ParameterizedType: " + genericType);
        }
        ArrayNode array = (ArrayNode)json;
        Collection<?> collection = JacksonSerializer.tryToCreateCollection(type, array.size());
        if (array.size() > 0) {
            ParameterizedType parameterizedType = (ParameterizedType)genericType;
            Class parameterizedClass = (Class)parameterizedType.getActualTypeArguments()[0];
            collection.addAll(JacksonSerializer.toObjects(parameterizedClass, (ArrayNode)json));
        }
        return (T)collection;
    }

    public static <T> List<T> toObjects(Class<T> type, ArrayNode json) {
        if (json == null) {
            return new ArrayList(0);
        }
        ArrayList<T> list = new ArrayList<T>(json.size());
        for (int i = 0; i < json.size(); ++i) {
            list.add(JacksonSerializer.toObject(type, json.get(i)));
        }
        return list;
    }

    private static Optional<?> tryToConvertFromSimpleType(Class<?> type, JsonNode json) {
        if (type.isAssignableFrom(String.class)) {
            return Optional.of(json.asText());
        }
        if (type.isAssignableFrom(Integer.TYPE) || type.isAssignableFrom(Integer.class)) {
            return Optional.of(json.intValue());
        }
        if (type.isAssignableFrom(Double.TYPE) || type.isAssignableFrom(Double.class)) {
            return Optional.of(json.doubleValue());
        }
        if (type.isAssignableFrom(Long.TYPE) || type.isAssignableFrom(Long.class)) {
            return Optional.of(json.longValue());
        }
        if (type.isAssignableFrom(Short.TYPE) || type.isAssignableFrom(Short.class)) {
            return Optional.of(json.shortValue());
        }
        if (type.isAssignableFrom(Byte.TYPE) || type.isAssignableFrom(Byte.class)) {
            return Optional.of(json.numberValue().byteValue());
        }
        if (type.isAssignableFrom(Character.TYPE) || type.isAssignableFrom(Character.class)) {
            return Optional.of(Character.valueOf(json.asText().charAt(0)));
        }
        if (type.isAssignableFrom(Boolean.class) || type.isAssignableFrom(Boolean.TYPE)) {
            return Optional.of(json.asBoolean());
        }
        if (type.isEnum()) {
            return Optional.of(Enum.valueOf(type, json.asText()));
        }
        if (JsonNode.class.isAssignableFrom(type)) {
            return Optional.of(json);
        }
        return Optional.empty();
    }

    private static Collection<?> tryToCreateCollection(Class<?> collectionType, int initialCapacity) {
        if (collectionType.isInterface()) {
            if (List.class.isAssignableFrom(collectionType)) {
                return new ArrayList(initialCapacity);
            }
            if (Set.class.isAssignableFrom(collectionType)) {
                return new LinkedHashSet(initialCapacity);
            }
            throw new IllegalArgumentException("Collection type not supported: '" + collectionType.getName() + "'. Use Lists, Sets or concrete classes that implement java.util.Collection.");
        }
        try {
            return (Collection)collectionType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not create an instance of the collection of type " + collectionType + ". Make sure it contains a default public constructor and the class is accessible.", e);
        }
    }
}

