/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.communication;

import com.vaadin.flow.server.VaadinServlet;
import com.vaadin.flow.server.communication.PushRequestHandler;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletContextEvent;
import jakarta.servlet.ServletContextListener;
import jakarta.servlet.ServletRegistration;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.util.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSR356WebsocketInitializer
implements ServletContextListener {
    private static boolean atmosphereAvailable = false;

    public void contextInitialized(ServletContextEvent sce) {
        JSR356WebsocketInitializer.getLogger().debug("Executing contextInitialized");
        ServletContext servletContext = sce.getServletContext();
        if (servletContext.getMajorVersion() < 3) {
            return;
        }
        this.init(servletContext);
    }

    public void init(ServletContext servletContext) {
        if (!atmosphereAvailable) {
            return;
        }
        JSR356WebsocketInitializer.getLogger().debug("Atmosphere available, initializing");
        Map regs = servletContext.getServletRegistrations();
        for (Map.Entry entry : regs.entrySet()) {
            String servletName = (String)entry.getKey();
            ServletRegistration servletRegistration = (ServletRegistration)entry.getValue();
            JSR356WebsocketInitializer.getLogger().debug("Checking if {} is a Vaadin Servlet", (Object)servletRegistration.getName());
            if (!this.isVaadinServlet(servletRegistration, servletContext)) continue;
            try {
                JSR356WebsocketInitializer.initAtmosphereForVaadinServlet(servletRegistration, servletContext);
            }
            catch (Exception e) {
                JSR356WebsocketInitializer.getLogger().warn("Failed to initialize Atmosphere for {}", (Object)servletName, (Object)e);
            }
        }
    }

    public static void initAtmosphereForVaadinServlet(ServletRegistration servletRegistration, ServletContext servletContext) {
        JSR356WebsocketInitializer.getLogger().debug("Initializing Atmosphere for Vaadin Servlet: {}", (Object)servletRegistration.getName());
        String servletName = servletRegistration.getName();
        String attributeName = JSR356WebsocketInitializer.getAttributeName(servletName);
        if (servletContext.getAttribute(attributeName) != null) {
            JSR356WebsocketInitializer.getLogger().warn("Atmosphere already initialized");
            return;
        }
        JSR356WebsocketInitializer.getLogger().debug("Creating AtmosphereFramework for {}", (Object)servletName);
        AtmosphereFramework framework = PushRequestHandler.initAtmosphere(new FakeServletConfig(servletRegistration, servletContext));
        servletContext.setAttribute(attributeName, (Object)framework);
        JSR356WebsocketInitializer.getLogger().debug("Created AtmosphereFramework for {}", (Object)servletName);
    }

    public static String getAttributeName(String servletName) {
        return JSR356WebsocketInitializer.class.getName() + "." + servletName;
    }

    private static boolean isAtmosphereFrameworkAttribute(String attributeName) {
        return attributeName.startsWith(JSR356WebsocketInitializer.class.getName() + ".");
    }

    protected boolean isVaadinServlet(ServletRegistration servletRegistration, ServletContext servletContext) {
        try {
            String servletClassName = servletRegistration.getClassName();
            if (servletClassName.equals("com.ibm.ws.wsoc.WsocServlet")) {
                return false;
            }
            if (servletClassName.equals("com.ibm.websphere.jaxrs.server.IBMRestServlet")) {
                return false;
            }
            Class<?> servletClass = servletContext.getClassLoader().loadClass(servletClassName);
            return VaadinServlet.class.isAssignableFrom(servletClass);
        }
        catch (Exception e) {
            return true;
        }
    }

    private static final Logger getLogger() {
        return LoggerFactory.getLogger((String)JSR356WebsocketInitializer.class.getName());
    }

    public void contextDestroyed(ServletContextEvent sce) {
        ServletContext servletContext = sce.getServletContext();
        Enumeration attributeNames = servletContext.getAttributeNames();
        while (attributeNames.hasMoreElements()) {
            Object value;
            String attributeName = (String)attributeNames.nextElement();
            if (!JSR356WebsocketInitializer.isAtmosphereFrameworkAttribute(attributeName) || !((value = servletContext.getAttribute(attributeName)) instanceof AtmosphereFramework)) continue;
            ((AtmosphereFramework)value).destroy();
        }
    }

    public static boolean isAtmosphereAvailable() {
        return atmosphereAvailable;
    }

    static {
        try {
            Version.getRawVersion();
            atmosphereAvailable = true;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }

    public static class FakeServletConfig
    implements ServletConfig {
        private ServletRegistration servletRegistration;
        private ServletContext servletContext;

        public FakeServletConfig(ServletRegistration servletRegistration, ServletContext servletContext) {
            this.servletContext = servletContext;
            this.servletRegistration = servletRegistration;
        }

        public String getServletName() {
            return this.servletRegistration.getName();
        }

        public ServletContext getServletContext() {
            return this.servletContext;
        }

        public String getInitParameter(String name) {
            return this.servletRegistration.getInitParameter(name);
        }

        public Enumeration<String> getInitParameterNames() {
            return Collections.enumeration(this.servletRegistration.getInitParameters().keySet());
        }
    }
}

