/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server;

import com.vaadin.flow.server.Command;
import com.vaadin.flow.server.DefaultErrorHandler;
import com.vaadin.flow.server.ErrorEvent;
import com.vaadin.flow.server.ErrorHandler;
import com.vaadin.flow.server.ErrorHandlingCommand;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinSession;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FutureAccess
extends FutureTask<Void> {
    private final VaadinSession session;
    private final Command command;

    public FutureAccess(VaadinSession session, Command command) {
        super(command::execute, null);
        this.session = session;
        this.command = command;
    }

    @Override
    public Void get() throws InterruptedException, ExecutionException {
        VaadinService.verifyNoOtherSessionLocked(this.session);
        return (Void)super.get();
    }

    public void handleError(Exception exception) {
        try {
            if (this.command instanceof ErrorHandlingCommand) {
                ErrorHandlingCommand errorHandlingCommand = (ErrorHandlingCommand)this.command;
                errorHandlingCommand.handleError(exception);
            } else {
                ErrorEvent errorEvent = new ErrorEvent(exception);
                ErrorHandler errorHandler = ErrorEvent.findErrorHandler(this.session);
                if (errorHandler == null) {
                    errorHandler = new DefaultErrorHandler();
                }
                errorHandler.error(errorEvent);
            }
        }
        catch (Exception e) {
            FutureAccess.getLogger().error(e.getMessage(), (Throwable)e);
        }
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger((String)FutureAccess.class.getName());
    }
}

