/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal.nodefeature;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.BaseJsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.vaadin.flow.internal.JacksonUtils;
import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.internal.nodefeature.ElementData;
import com.vaadin.flow.internal.nodefeature.StateNodeNodeList;
import java.util.Iterator;

public class VirtualChildrenList
extends StateNodeNodeList {
    public VirtualChildrenList(StateNode node) {
        super(node);
    }

    public void add(int index, StateNode node, String type, String payload) {
        this.add(index, node, type, (JsonNode)(payload == null ? null : JacksonUtils.writeValue(payload)));
    }

    public void add(int index, StateNode node, String type, JsonNode payload) {
        assert (node != null);
        ObjectNode payloadObject = JacksonUtils.createObjectNode();
        payloadObject.put("type", type);
        if (payload != null) {
            payloadObject.put("payload", payload);
        }
        node.getFeature(ElementData.class).setPayload((BaseJsonNode)payloadObject);
        super.add(index, node);
    }

    public void add(int index, StateNode node, String type) {
        this.add(index, node, type, (String)null);
    }

    public void append(StateNode node, String type, String payload) {
        this.add(this.size(), node, type, payload);
    }

    public void append(StateNode node, String type, JsonNode payload) {
        this.add(this.size(), node, type, payload);
    }

    public void append(StateNode node, String type) {
        this.append(node, type, (String)null);
    }

    @Override
    public StateNode get(int index) {
        return (StateNode)super.get(index);
    }

    @Override
    public Iterator<StateNode> iterator() {
        return super.iterator();
    }

    @Override
    public int indexOf(StateNode node) {
        return super.indexOf(node);
    }

    @Override
    public StateNode remove(int index) {
        this.get(index).getFeature(ElementData.class).remove("payload");
        return super.remove(index);
    }

    @Override
    protected void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return super.size();
    }
}

