/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component;

import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.Key;
import com.vaadin.flow.component.KeyModifier;
import com.vaadin.flow.component.ShortcutRegistration;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;

public interface ClickNotifier<T extends Component>
extends Serializable {
    default public Registration addClickListener(ComponentEventListener<ClickEvent<T>> listener) {
        if (this instanceof Component) {
            return ComponentUtil.addListener((Component)((Object)this), ClickEvent.class, listener);
        }
        throw new IllegalStateException(String.format("The class '%s' doesn't extend '%s'. Make your implementation for the method '%s'.", this.getClass().getName(), Component.class.getSimpleName(), "addClickListener"));
    }

    default public Registration addDoubleClickListener(ComponentEventListener<ClickEvent<T>> listener) {
        if (this instanceof Component) {
            return ComponentUtil.addListener((Component)((Object)this), ClickEvent.class, listener, d -> d.setFilter("event.detail == 2"));
        }
        throw new IllegalStateException(String.format("The class '%s' doesn't extend '%s'. Make your implementation for the method '%s'.", this.getClass().getName(), Component.class.getSimpleName(), "addDoubleClickListener"));
    }

    default public Registration addSingleClickListener(ComponentEventListener<ClickEvent<T>> listener) {
        if (this instanceof Component) {
            return ComponentUtil.addListener((Component)((Object)this), ClickEvent.class, listener, d -> d.setFilter("event.detail <= 1"));
        }
        throw new IllegalStateException(String.format("The class '%s' doesn't extend '%s'. Make your implementation for the method '%s'.", this.getClass().getName(), Component.class.getSimpleName(), "addSingleClickListener"));
    }

    default public ShortcutRegistration addClickShortcut(Key key, KeyModifier ... keyModifiers) {
        if (!(this instanceof Component)) {
            throw new IllegalStateException(String.format("The class '%s' doesn't extend '%s'. Make your implementation for the method '%s'.", this.getClass().getName(), Component.class.getSimpleName(), "addClickShortcut(Key, KeyModifier...)"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Parameter '%s' must not be null!", "key"));
        }
        Component thisComponent = (Component)((Object)this);
        return new ShortcutRegistration(thisComponent, () -> new Component[]{thisComponent.getUI().get()}, event -> ComponentUtil.fireEvent(thisComponent, new ClickEvent(thisComponent)), key).withModifiers(keyModifiers).allowBrowserDefault();
    }
}

