/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.streams;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.internal.streams.UploadCompleteEvent;
import com.vaadin.flow.internal.streams.UploadStartEvent;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinResponse;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.streams.TransferContext;
import com.vaadin.flow.server.streams.TransferProgressListener;
import com.vaadin.flow.server.streams.UploadEvent;
import com.vaadin.flow.server.streams.UploadHandler;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.Part;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Objects;
import org.apache.commons.fileupload2.core.FileItemInput;
import org.apache.commons.fileupload2.core.FileItemInputIterator;
import org.apache.commons.fileupload2.core.FileUploadByteCountLimitException;
import org.apache.commons.fileupload2.core.FileUploadException;
import org.apache.commons.fileupload2.core.FileUploadFileCountLimitException;
import org.apache.commons.fileupload2.core.FileUploadSizeException;
import org.apache.commons.fileupload2.jakarta.servlet6.JakartaServletFileUpload;
import org.slf4j.LoggerFactory;

public final class TransferUtil {
    public static int DEFAULT_BUFFER_SIZE = 16384;

    public static long transfer(InputStream inputStream, OutputStream outputStream, TransferContext transferContext, Collection<TransferProgressListener> listeners) throws IOException {
        int read;
        Objects.requireNonNull(inputStream, "InputStream cannot be null");
        Objects.requireNonNull(outputStream, "OutputStream cannot be null");
        Objects.requireNonNull(transferContext, "TransferRequest cannot be null");
        Objects.requireNonNull(listeners, "TransferProgressListener cannot be null");
        listeners.forEach(listener -> listener.onStart(transferContext));
        long transferred = 0L;
        HashMap<TransferProgressListener, Long> lastNotified = new HashMap<TransferProgressListener, Long>(listeners.size());
        byte[] buffer = new byte[DEFAULT_BUFFER_SIZE];
        while ((read = inputStream.read(buffer, 0, DEFAULT_BUFFER_SIZE)) >= 0) {
            outputStream.write(buffer, 0, read);
            if (transferred >= Long.MAX_VALUE) continue;
            try {
                transferred = Math.addExact(transferred, (long)read);
            }
            catch (ArithmeticException ignore) {
                transferred = Long.MAX_VALUE;
            }
            for (TransferProgressListener listener2 : listeners) {
                Long lastNotifiedLong = lastNotified.getOrDefault(listener2, 0L);
                long progressReportInterval = listener2.progressReportInterval();
                if (progressReportInterval <= -1L || transferred - lastNotifiedLong < progressReportInterval) continue;
                long finalTransferred = transferred;
                listener2.onProgress(transferContext, finalTransferred, transferContext.contentLength());
                lastNotified.put(listener2, transferred);
            }
        }
        long finalTransferred = transferred;
        listeners.forEach(listener -> listener.onComplete(transferContext, finalTransferred));
        return transferred;
    }

    static void handleUpload(UploadHandler handler, VaadinRequest request, VaadinResponse response, VaadinSession session, Element owner) {
        block19: {
            boolean isMultipartUpload = request instanceof HttpServletRequest && JakartaServletFileUpload.isMultipartContent((HttpServletRequest)((HttpServletRequest)request));
            try {
                if (isMultipartUpload) {
                    Collection parts = Collections.EMPTY_LIST;
                    try {
                        parts = ((HttpServletRequest)request).getParts();
                    }
                    catch (IOException ioe) {
                        throw new UncheckedIOException(ioe);
                    }
                    catch (ServletException | IllegalStateException ioe) {
                        LoggerFactory.getLogger(UploadHandler.class).trace("Pretending the request did not contain any parts because of exception", ioe);
                    }
                    if (!parts.isEmpty()) {
                        for (Part part : parts) {
                            UploadEvent event = new UploadEvent(request, response, session, part.getSubmittedFileName(), part.getSize(), part.getContentType(), owner, null, part);
                            TransferUtil.handleUploadRequest(handler, event);
                        }
                        handler.responseHandled(true, response);
                    } else {
                        long contentLength = request.getContentLengthLong();
                        try {
                            JakartaServletFileUpload upload = new JakartaServletFileUpload();
                            upload.setSizeMax(handler.getRequestSizeMax());
                            upload.setFileSizeMax(handler.getFileSizeMax());
                            upload.setFileCountMax(handler.getFileCountMax());
                            if (request.getCharacterEncoding() == null) {
                                upload.setHeaderCharset(StandardCharsets.UTF_8);
                            }
                            FileItemInputIterator iter = upload.getItemIterator((HttpServletRequest)request);
                            while (iter.hasNext()) {
                                FileItemInput item = iter.next();
                                UploadEvent event = new UploadEvent(request, response, session, item.getName(), contentLength, item.getContentType(), owner, item, null);
                                TransferUtil.handleUploadRequest(handler, event);
                            }
                            handler.responseHandled(true, response);
                        }
                        catch (FileUploadException e) {
                            String limitInfoStr = "{} limit exceeded. To increase the limit extend StreamRequestHandler, override {} method for UploadHandler and provide a higher limit.";
                            if (e instanceof FileUploadByteCountLimitException) {
                                LoggerFactory.getLogger(UploadHandler.class).warn(limitInfoStr, (Object)"Request size", (Object)"getRequestSizeMax");
                            } else if (e instanceof FileUploadSizeException) {
                                LoggerFactory.getLogger(UploadHandler.class).warn(limitInfoStr, (Object)"File size", (Object)"getFileSizeMax");
                            } else if (e instanceof FileUploadFileCountLimitException) {
                                LoggerFactory.getLogger(UploadHandler.class).warn(limitInfoStr, (Object)"File count", (Object)"getFileCountMax");
                            }
                            LoggerFactory.getLogger(UploadHandler.class).warn("File upload failed.", (Throwable)e);
                            handler.responseHandled(false, response);
                        }
                        catch (IOException ioe) {
                            LoggerFactory.getLogger(UploadHandler.class).warn("IO Exception during file upload", (Throwable)ioe);
                            handler.responseHandled(false, response);
                        }
                    }
                    break block19;
                }
                String fileName = "unknown";
                String contentType = "unknown";
                UploadEvent event = new UploadEvent(request, response, session, fileName, request.getContentLengthLong(), contentType, owner, null, null);
                TransferUtil.handleUploadRequest(handler, event);
                handler.responseHandled(true, response);
            }
            catch (Exception e) {
                LoggerFactory.getLogger(UploadHandler.class).error("Exception during upload", (Throwable)e);
                handler.responseHandled(false, response);
            }
        }
    }

    private static void handleUploadRequest(UploadHandler handler, UploadEvent event) throws IOException {
        Component owner = event.getOwningComponent();
        try {
            ComponentUtil.fireEvent(owner, new UploadStartEvent(owner));
            handler.handleUploadRequest(event);
        }
        finally {
            ComponentUtil.fireEvent(owner, new UploadCompleteEvent(owner));
        }
    }
}

