/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.streams;

import com.vaadin.flow.server.VaadinResponse;
import com.vaadin.flow.server.streams.DownloadEvent;
import com.vaadin.flow.server.streams.DownloadHandler;
import com.vaadin.flow.server.streams.TransferContext;
import com.vaadin.flow.server.streams.TransferProgressAwareHandler;
import java.util.Optional;

public abstract class AbstractDownloadHandler<R extends AbstractDownloadHandler>
extends TransferProgressAwareHandler<DownloadEvent, R>
implements DownloadHandler {
    private boolean inline = false;

    @Override
    protected TransferContext getTransferContext(DownloadEvent transferEvent) {
        return new TransferContext(transferEvent.getRequest(), transferEvent.getResponse(), transferEvent.getSession(), transferEvent.getFileName(), transferEvent.getOwningElement(), transferEvent.getContentLength(), transferEvent.getException());
    }

    protected String getContentType(String fileName, VaadinResponse response) {
        return Optional.ofNullable(response.getService().getMimeType(fileName)).orElse("application/octet-stream");
    }

    public R inline() {
        this.inline = true;
        return (R)this;
    }

    public boolean isInline() {
        return this.inline;
    }
}

