/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.template.internal;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.template.Id;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.ShadowRoot;
import com.vaadin.flow.internal.ReflectTools;
import com.vaadin.flow.internal.nodefeature.VirtualChildrenList;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Optional;
import java.util.function.Consumer;

public class IdMapper
implements Serializable {
    private final HashMap<String, Element> registeredElementIdToInjected = new HashMap();
    private Component template;

    public IdMapper(Component template) {
        this.template = template;
    }

    public void mapComponentOrElement(Field field, String id, String tag, Consumer<Element> beforeInject) {
        this.injectClientSideElement(tag, id, field, beforeInject);
    }

    private Class<? extends Component> getContainerClass() {
        return this.template.getClass();
    }

    private void injectClientSideElement(String tagName, String id, Field field, Consumer<Element> beforeInject) {
        Class<?> fieldType = field.getType();
        Tag tag = fieldType.getAnnotation(Tag.class);
        if (tag != null && tagName != null && !tagName.equalsIgnoreCase(tag.value())) {
            String msg = String.format("Class '%s' has field '%s' whose type '%s' is annotated with tag '%s' but the element defined in the HTML template with id '%s' has tag name '%s'", this.getContainerClass().getName(), field.getName(), fieldType.getName(), tag.value(), id, tagName);
            throw new IllegalStateException(msg);
        }
        if (tag != null) {
            tagName = tag.value();
        }
        this.attachExistingElementById(tagName, id, field, beforeInject);
    }

    public ShadowRoot getOrCreateShadowRoot() {
        return this.getElement().getShadowRoot().orElseGet(() -> this.getElement().attachShadow());
    }

    private Element getElement() {
        return this.template.getElement();
    }

    private void attachExistingElementById(String tagName, String id, Field field, Consumer<Element> beforeInject) {
        if (tagName == null) {
            throw new IllegalArgumentException("Tag name parameter cannot be null");
        }
        Element element = this.registeredElementIdToInjected.get(id);
        if (element == null) {
            element = new Element(tagName);
            VirtualChildrenList list = this.getElement().getNode().getFeature(VirtualChildrenList.class);
            list.append(element.getNode(), "@id", id);
            this.registeredElementIdToInjected.put(id, element);
        }
        this.injectTemplateElement(element, field, beforeInject);
    }

    private void injectTemplateElement(Element element, Field field, Consumer<Element> beforeInject) {
        Class<?> fieldType = field.getType();
        if (Component.class.isAssignableFrom(fieldType)) {
            Component component;
            beforeInject.accept(element);
            Optional<Component> wrappedComponent = element.getComponent();
            if (wrappedComponent.isPresent()) {
                component = wrappedComponent.get();
            } else {
                Class<?> componentType = fieldType;
                component = Component.from(element, componentType);
            }
            ReflectTools.setJavaFieldValue(this.template, field, component);
        } else if (Element.class.isAssignableFrom(fieldType)) {
            beforeInject.accept(element);
            ReflectTools.setJavaFieldValue(this.template, field, element);
        } else {
            String msg = String.format("The field '%s' in '%s' has an @'%s' annotation but the field type '%s' does not extend neither '%s' nor '%s'", field.getName(), this.getContainerClass().getName(), Id.class.getSimpleName(), fieldType.getName(), Component.class.getSimpleName(), Element.class.getSimpleName());
            throw new IllegalArgumentException(msg);
        }
    }

    public void reset() {
        this.registeredElementIdToInjected.clear();
    }

    public boolean isMapped(String id) {
        return this.registeredElementIdToInjected.containsKey(id);
    }
}

