/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.internal;

import com.vaadin.flow.component.internal.UIInternals;
import com.vaadin.flow.component.page.PendingJavaScriptResult;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.internal.StateNode;
import elemental.json.JsonValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PendingJavaScriptInvocation
implements PendingJavaScriptResult {
    private static final String EXECUTION_CANCELED = "Execution canceled";
    private final UIInternals.JavaScriptInvocation invocation;
    private final StateNode owner;
    private SerializableConsumer<JsonValue> successHandler;
    private SerializableConsumer<String> errorHandler;
    private boolean sentToBrowser = false;
    private boolean canceled = false;

    public PendingJavaScriptInvocation(StateNode owner, UIInternals.JavaScriptInvocation invocation) {
        assert (owner != null);
        assert (invocation != null);
        this.owner = owner;
        this.invocation = invocation;
    }

    public StateNode getOwner() {
        return this.owner;
    }

    public boolean isSubscribed() {
        return this.successHandler != null;
    }

    public void complete(JsonValue value) {
        assert (this.isSubscribed());
        this.successHandler.accept(value);
    }

    public void completeExceptionally(JsonValue value) {
        assert (this.isSubscribed());
        String message = value.asString();
        if (this.errorHandler != null) {
            this.errorHandler.accept(message);
        } else {
            PendingJavaScriptInvocation.getLogger().debug("Ignored error from JavaScript: {}", (Object)message);
        }
    }

    @Override
    public boolean cancelExecution() {
        if (this.sentToBrowser || this.canceled) {
            return false;
        }
        this.canceled = true;
        if (this.errorHandler != null) {
            this.errorHandler.accept(EXECUTION_CANCELED);
        }
        return true;
    }

    @Override
    public boolean isSentToBrowser() {
        return this.sentToBrowser;
    }

    void setSentToBrowser() {
        assert (!this.sentToBrowser);
        this.sentToBrowser = true;
    }

    @Override
    public void then(SerializableConsumer<JsonValue> successHandler, SerializableConsumer<String> errorHandler) {
        if (successHandler == null) {
            throw new IllegalArgumentException("Success handler cannot be null");
        }
        if (this.sentToBrowser) {
            throw new IllegalStateException("Cannot subscribe to the return value after the execution has been sent to the client.");
        }
        if (this.canceled) {
            if (errorHandler != null) {
                errorHandler.accept(EXECUTION_CANCELED);
            }
            return;
        }
        this.successHandler = PendingJavaScriptInvocation.combineHandlers(this.successHandler, successHandler);
        this.errorHandler = PendingJavaScriptInvocation.combineHandlers(this.errorHandler, errorHandler);
    }

    private static <T> SerializableConsumer<T> combineHandlers(SerializableConsumer<T> first, SerializableConsumer<T> second) {
        if (first == null) {
            return second;
        }
        if (second == null) {
            return first;
        }
        return value -> {
            first.accept(value);
            second.accept(value);
        };
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public UIInternals.JavaScriptInvocation getInvocation() {
        return this.invocation;
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger((String)PendingJavaScriptInvocation.class.getName());
    }
}

