/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal;

import java.io.IOException;
import java.net.ServerSocket;

public class NetworkUtil {
    private NetworkUtil() {
    }

    public static int getFreePort() {
        int n;
        ServerSocket s = new ServerSocket(0);
        try {
            s.setReuseAddress(true);
            n = s.getLocalPort();
        }
        catch (Throwable throwable) {
            try {
                try {
                    s.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new IllegalStateException("Unable to find a free port", e);
            }
        }
        s.close();
        return n;
    }

    public static boolean isFreePort(int port) {
        boolean bl;
        ServerSocket s = new ServerSocket(port);
        try {
            s.setReuseAddress(true);
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    s.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return false;
            }
        }
        s.close();
        return bl;
    }
}

