/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.dom.impl;

import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.Style;
import com.vaadin.flow.dom.StyleUtil;
import com.vaadin.flow.dom.impl.CustomAttribute;
import java.util.LinkedHashMap;
import java.util.stream.Collectors;

public class StyleAttributeHandler
extends CustomAttribute {
    private static final String ERROR_PARSING_STYLE = "Error parsing style '%s': %s";
    private static final char COLON = ':';
    private static final char SEMICOLON = ';';
    private static final char PARENTHESIS_OPEN = '(';
    private static final char PARENTHESIS_CLOSED = ')';

    @Override
    public boolean hasAttribute(Element element) {
        return element.getStyle().getNames().findAny().isPresent();
    }

    @Override
    public String getAttribute(Element element) {
        if (!this.hasAttribute(element)) {
            return null;
        }
        Style style = element.getStyle();
        return style.getNames().map(styleName -> StyleUtil.stylePropertyToAttribute(styleName) + ":" + style.get((String)styleName)).collect(Collectors.joining(";"));
    }

    @Override
    public void setAttribute(Element element, String attributeValue) {
        Style style = element.getStyle();
        style.clear();
        StyleAttributeHandler.parseStyles(attributeValue).forEach(style::set);
    }

    public static LinkedHashMap<String, String> parseStyles(String styleString) {
        try {
            LinkedHashMap<String, String> parsedStyles = new LinkedHashMap<String, String>();
            StringBuilder nameBuffer = new StringBuilder();
            StringBuilder valueBuffer = new StringBuilder();
            boolean nameRead = false;
            int parenthesisOpen = 0;
            for (int i = 0; i < styleString.length(); ++i) {
                char c = styleString.charAt(i);
                if (nameRead) {
                    boolean valueTerminated = false;
                    if (c == '(') {
                        ++parenthesisOpen;
                    } else if (c == ')') {
                        --parenthesisOpen;
                    } else if (parenthesisOpen == 0 && c == ';') {
                        valueTerminated = true;
                    }
                    if (valueTerminated) {
                        StyleAttributeHandler.addRule(nameBuffer, valueBuffer, parsedStyles);
                        nameBuffer = new StringBuilder();
                        valueBuffer = new StringBuilder();
                        nameRead = false;
                        continue;
                    }
                    valueBuffer.append(c);
                    continue;
                }
                if (c == ':') {
                    nameRead = true;
                    continue;
                }
                nameBuffer.append(c);
            }
            if (nameRead) {
                StyleAttributeHandler.addRule(nameBuffer, valueBuffer, parsedStyles);
            } else if (!nameBuffer.isEmpty()) {
                throw new IllegalArgumentException("Value for CSS rule was not found.");
            }
            return parsedStyles;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    protected static void addRule(StringBuilder nameBuffer, StringBuilder valueBuffer, LinkedHashMap<String, String> parsedStyles) throws IllegalArgumentException {
        String name = nameBuffer.toString().trim();
        String value = valueBuffer.toString().trim();
        if (name.isEmpty() || value.isEmpty()) {
            throw new IllegalArgumentException("Style rule must contain name and value");
        }
        parsedStyles.put(name, value);
    }

    @Override
    public void removeAttribute(Element element) {
        element.getStyle().clear();
    }
}

