/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.internal.JacksonUtils;
import com.vaadin.flow.internal.StringUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tools.jackson.databind.JsonNode;

public class CssBundler {
    private static final String WHITE_SPACE = "\\s*";
    private static final String STRING = "(.*?)";
    private static final String CSS_STRING = "('(.*?)'|\"(.*?)\"|(.*?))";
    private static final String QUOTED_CSS_STRING = "('(.*?)'|\"(.*?)\")";
    private static final String URL = "url\\s*\\(\\s*('(.*?)'|\"(.*?)\"|(.*?))\\s*\\)";
    private static final String URL_OR_STRING = "(url\\s*\\(\\s*('(.*?)'|\"(.*?)\"|(.*?))\\s*\\)|('(.*?)'|\"(.*?)\"))";
    private static final String LAYER = "(layer|layer\\s*\\((.*?)\\))";
    private static final String MEDIA_QUERY = "(\\s+[a-zA-Z].*)?";
    private static final String MAYBE_LAYER_OR_MEDIA_QUERY = "((layer|layer\\s*\\((.*?)\\))|(\\s+[a-zA-Z].*)?)";
    private static final Pattern IMPORT_PATTERN = Pattern.compile("@import\\s*(url\\s*\\(\\s*('(.*?)'|\"(.*?)\"|(.*?))\\s*\\)|('(.*?)'|\"(.*?)\"))((layer|layer\\s*\\((.*?)\\))|(\\s+[a-zA-Z].*)?)\\s*;");
    private static final Pattern PROTOCOL_PATTER_FOR_URLS = Pattern.compile("(?i)^(https?|data|ftp|file):.*");
    private static final Pattern URL_PATTERN = Pattern.compile("url\\s*\\(\\s*('(.*?)'|\"(.*?)\"|(.*?))\\s*\\)");

    public static String inlineImportsForThemes(File themeFolder, File cssFile, JsonNode themeJson) throws IOException {
        return CssBundler.inlineImports(themeFolder, cssFile, CssBundler.getThemeAssetsAliases(themeJson), BundleFor.THEMES, null, null);
    }

    public static String inlineImports(File themeFolder, File cssFile, JsonNode themeJson, File nodeModulesFolder) throws IOException {
        return CssBundler.inlineImports(themeFolder, cssFile, CssBundler.getThemeAssetsAliases(themeJson), null, "", nodeModulesFolder);
    }

    public static String inlineImportsForPublicResources(File baseFolder, File cssFile, String contextPath) throws IOException {
        return CssBundler.inlineImports(baseFolder, cssFile, new HashSet<String>(), BundleFor.STATIC_RESOURCES, contextPath, null);
    }

    private static String inlineImports(File baseFolder, File cssFile, Set<String> assetAliases, BundleFor bundleFor, String contextPath, File nodeModulesFolder) throws IOException {
        ArrayList<String> cyclicImportWarnings = new ArrayList<String>();
        String result = CssBundler.inlineImports(baseFolder, cssFile, assetAliases, bundleFor, contextPath, nodeModulesFolder, new HashSet<String>(), cyclicImportWarnings);
        if (!cyclicImportWarnings.isEmpty()) {
            CssBundler.getLogger().warn("Cyclic CSS @import statements detected and skipped:{}  - {}", (Object)System.lineSeparator(), (Object)String.join((CharSequence)(System.lineSeparator() + "  - "), cyclicImportWarnings));
        }
        return result;
    }

    private static String inlineImports(File baseFolder, File cssFile, Set<String> assetAliases, BundleFor bundleFor, String contextPath, File nodeModulesFolder, Set<String> visitedFiles, List<String> cyclicImportWarnings) throws IOException {
        String canonicalPath = cssFile.getCanonicalPath();
        if (!visitedFiles.add(canonicalPath)) {
            return "";
        }
        Object content = Files.readString(cssFile.toPath());
        if (bundleFor == BundleFor.THEMES) {
            Matcher urlMatcher = URL_PATTERN.matcher((CharSequence)content);
            content = CssBundler.rewriteCssUrlsForThemes(baseFolder, cssFile, assetAliases, urlMatcher);
        } else if (bundleFor == BundleFor.STATIC_RESOURCES) {
            content = CssBundler.rewriteCssUrlsForStaticResources(baseFolder, cssFile, contextPath, (String)content);
        }
        content = StringUtil.removeComments((String)content, true);
        ArrayList unhandledImports = new ArrayList();
        Matcher importMatcher = IMPORT_PATTERN.matcher((CharSequence)content);
        content = importMatcher.replaceAll(result -> {
            File potentialFile;
            String layerOrMediaQueryInfo = result.group(9);
            if (layerOrMediaQueryInfo != null && !layerOrMediaQueryInfo.isBlank()) {
                unhandledImports.add(result.group());
                return "";
            }
            String url = CssBundler.getNonNullGroup(result, 3, 4, 5, 7, 8);
            String sanitizedUrl = CssBundler.sanitizeUrl(url);
            if (sanitizedUrl != null && sanitizedUrl.endsWith(".css") && (potentialFile = CssBundler.resolveImportPath(sanitizedUrl, cssFile.getParentFile(), nodeModulesFolder)) != null && potentialFile.exists()) {
                try {
                    String importedPath = potentialFile.getCanonicalPath();
                    if (visitedFiles.contains(importedPath)) {
                        cyclicImportWarnings.add(String.format("'%s' imports already processed '%s'", cssFile.toPath().normalize().toAbsolutePath(), potentialFile.toPath().normalize().toAbsolutePath()));
                        return "";
                    }
                    return Matcher.quoteReplacement(CssBundler.inlineImports(baseFolder, potentialFile, assetAliases, bundleFor, contextPath, nodeModulesFolder, visitedFiles, cyclicImportWarnings));
                }
                catch (IOException e) {
                    CssBundler.getLogger().warn("Unable to inline import: {}", (Object)result.group());
                }
            }
            unhandledImports.add(result.group());
            return "";
        });
        if (!unhandledImports.isEmpty()) {
            content = String.join((CharSequence)"\n", unhandledImports) + (String)(((String)content).isEmpty() ? "" : "\n" + (String)content);
        }
        return content;
    }

    private static String rewriteCssUrlsForStaticResources(File baseFolder, File cssFile, String contextPath, String content) {
        Matcher urlMatcher = URL_PATTERN.matcher(content);
        content = urlMatcher.replaceAll(result -> {
            String url = CssBundler.getNonNullGroup(result, 2, 3, 4);
            if (url == null || url.trim().endsWith(".css")) {
                return Matcher.quoteReplacement(urlMatcher.group());
            }
            String sanitized = CssBundler.sanitizeUrl(url);
            if (sanitized == null) {
                return Matcher.quoteReplacement(urlMatcher.group());
            }
            String trimmed = sanitized.trim();
            if (trimmed.startsWith("/") || PROTOCOL_PATTER_FOR_URLS.matcher(trimmed).matches()) {
                return Matcher.quoteReplacement(urlMatcher.group());
            }
            try {
                Path target = cssFile.getParentFile().toPath().resolve(trimmed).normalize();
                if (Files.exists(target, new LinkOption[0])) {
                    String rebased = CssBundler.rebaseToContextPath(baseFolder, contextPath, target);
                    return Matcher.quoteReplacement("url('" + rebased + "')");
                }
            }
            catch (Exception e) {
                CssBundler.getLogger().debug("Unable to resolve url: {}", (Object)urlMatcher.group());
            }
            return Matcher.quoteReplacement(urlMatcher.group());
        });
        return content;
    }

    private static String rewriteCssUrlsForThemes(File baseFolder, File cssFile, Set<String> assetAliases, Matcher urlMatcher) {
        String content = urlMatcher.replaceAll(result -> {
            String url = CssBundler.getNonNullGroup(result, 2, 3, 4);
            if (url == null || url.trim().endsWith(".css")) {
                return Matcher.quoteReplacement(urlMatcher.group());
            }
            File potentialFile = new File(cssFile.getParentFile(), url.trim());
            if (potentialFile.exists()) {
                String relativePath = baseFolder.getParentFile().toPath().relativize(potentialFile.toPath()).toString().replaceAll("\\\\", "/");
                return Matcher.quoteReplacement("url('VAADIN/themes/" + relativePath + "')");
            }
            if (CssBundler.isPotentialThemeAsset(baseFolder, assetAliases, potentialFile)) {
                String relativePath = baseFolder.getParentFile().toPath().relativize(potentialFile.toPath()).toString().replaceAll("\\\\", "/");
                return Matcher.quoteReplacement("url('VAADIN/themes/" + relativePath + "')");
            }
            return Matcher.quoteReplacement(urlMatcher.group());
        });
        return content;
    }

    private static String rebaseToContextPath(File baseFolder, String contextPath, Path target) {
        Object context;
        String publicRelativePath = baseFolder.toPath().relativize(target).toString().replaceAll("\\\\", "/");
        Object object = context = contextPath == null ? "" : contextPath.trim();
        if (!((String)context).isEmpty() && !((String)context).startsWith("/")) {
            context = "/" + (String)context;
        }
        if (((String)context).endsWith("/")) {
            context = ((String)context).substring(0, ((String)context).length() - 1);
        }
        return (String)(((String)context).isEmpty() ? "" : context) + "/" + publicRelativePath;
    }

    private static boolean isPotentialThemeAsset(File themeFolder, Set<String> assetAliases, File potentialFile) {
        boolean potentialAsset = false;
        if (!assetAliases.isEmpty()) {
            Path themeFolderPath = themeFolder.toPath().normalize();
            try {
                Path normalized = themeFolderPath.resolve(potentialFile.toPath()).normalize();
                if (normalized.startsWith(themeFolderPath)) {
                    String relativePath = themeFolderPath.relativize(normalized).toString().replaceAll("\\\\", "/");
                    potentialAsset = assetAliases.stream().anyMatch(relativePath::startsWith);
                    if (potentialAsset) {
                        CssBundler.getLogger().debug("Considering '{}' a potential asset of theme '{}'", (Object)relativePath, (Object)themeFolder.getName());
                    }
                }
            }
            catch (IllegalArgumentException e) {
                CssBundler.getLogger().debug("Unresolvable path '{}'. Not considered as a asset of theme '{}'", (Object)potentialFile, (Object)themeFolder.getName());
                return false;
            }
        }
        return potentialAsset;
    }

    private static Set<String> getThemeAssetsAliases(JsonNode themeJson) {
        JsonNode assets = themeJson != null && themeJson.has("assets") ? themeJson.get("assets") : null;
        HashSet<String> aliases = new HashSet<String>();
        if (assets != null) {
            for (String nmpPackage : JacksonUtils.getKeys(assets)) {
                JsonNode packageAliases = assets.get(nmpPackage);
                for (String path : JacksonUtils.getKeys(packageAliases)) {
                    aliases.add(packageAliases.get(path).textValue() + "/");
                }
            }
        }
        return aliases;
    }

    private static String getNonNullGroup(MatchResult result, int ... groupId) {
        for (int i : groupId) {
            String res = result.group(i);
            if (res == null) continue;
            return res;
        }
        return null;
    }

    private static String sanitizeUrl(String url) {
        if (url == null) {
            return null;
        }
        return url.trim().split("\\?")[0];
    }

    private static File resolveImportPath(String importPath, File cssFileDir, File nodeModulesFolder) {
        File nodeModulesFile;
        File relativeFile = new File(cssFileDir, importPath);
        if (relativeFile.exists()) {
            return relativeFile;
        }
        if (nodeModulesFolder != null && !importPath.startsWith("./") && !importPath.startsWith("../") && (nodeModulesFile = new File(nodeModulesFolder, importPath)).exists()) {
            return nodeModulesFile;
        }
        return null;
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(CssBundler.class);
    }

    public static String minifyCss(String css) {
        css = StringUtil.removeComments(css, true);
        css = css.replaceAll("\\s+", " ");
        css = css.replaceAll("\\s*([{};,>~])\\s*", "$1");
        css = css.replaceAll(";}", "}");
        return css.trim();
    }

    private static enum BundleFor {
        THEMES,
        STATIC_RESOURCES;

    }
}

