class VaadinCommercialBanner extends HTMLElement {
  constructor() {
    super();
    // Create a shadow DOM for encapsulation
    const shadowRoot = this.attachShadow({ mode: 'closed' });

    // Initialize the component
    this.render(shadowRoot);
  }

  render(shadowRoot) {
    const styles = `<style>
      :host {
        align-items: center;
        background: #0d1219;
        color: #eaf0f8;
        display: flex;
        font-family: nb_international_pro, ui-sans-serif, system-ui, -apple-system, BlinkMacSystemFont, Segoe UI, Roboto, Helvetica Neue, Arial, Noto Sans, sans-serif, Apple Color Emoji, Segoe UI Emoji, Segoe UI Symbol, Noto Color emoji;
        font-size: 1rem;
        font-weight: 500;
        gap: 2rem;
        inset: auto 0 0 0;
        justify-content: center;
        line-height: 1.6;
        padding: 9px 32px;
        position: fixed;
        z-index: 9999;
      }
      
      p {
        margin: 0;
      }
      
      a {
        align-items: center;
        color: #57a1f8;
        display: inline-flex;
        gap: 0.25rem;
      }
      
      a svg {
        fill: currentColor;
      }
        
      button {
        align-items: center;
        background: none;
        border: none;
        color: currentColor;
        display: flex;
        height: 2.375rem;
        justify-content: center;
        margin: 0;
        padding: 0;
        width: 2.375rem;
      }
      
      button svg {
        fill: currentColor;
      }
    </style>`;

    shadowRoot.innerHTML = `
      ${styles}
      <svg role="img" aria-labelledby="logoTitle" height="24" viewBox="0 0 871 200" xmlns="http://www.w3.org/2000/svg"> 
       <title id="logoTitle">Vaadin Logo</title>
       <path d="M589.86 48.5319C594.425 42.7664 608.358 37.2412 618.448 37.2412C656.163 37.2412 669.136 64.1467 669.136 94.4154V159.998C669.136 160.718 668.655 161.199 667.934 161.199H641.509C640.789 161.199 640.308 160.718 640.308 159.998V94.4154C640.308 80.0017 632.621 63.6662 613.643 63.6662C594.905 63.6662 587.218 77.5994 587.218 92.0131V159.998C587.218 160.718 586.737 161.199 586.017 161.199H559.592C558.871 161.199 558.391 160.718 558.391 159.998V40.8446C558.391 40.1239 558.871 39.6435 559.592 39.6435H582.413C583.855 39.6435 584.335 39.8837 584.575 40.8446L587.218 48.2917C587.458 49.2526 588.9 49.7331 589.86 48.5319Z" fill="currentColor"></path>
       <path d="M536.466 161.201H510.041C509.32 161.201 508.84 160.72 508.84 159.999V40.8465C508.84 40.1258 509.32 39.6454 510.041 39.6454H536.466C537.187 39.6454 537.667 40.1258 537.667 40.8465V159.999C537.667 160.72 537.187 161.201 536.466 161.201Z" fill="currentColor"></path>
       <path d="M536.468 28.8317H510.043C509.322 28.8317 508.842 28.7177 508.842 28.5468V0.284898C508.842 0.113961 509.322 0 510.043 0H536.468C537.189 0 537.669 0.113961 537.669 0.284898V28.5468C537.669 28.7177 537.189 28.8317 536.468 28.8317Z" fill="currentColor"></path>
       <path d="M456.671 152.311C450.906 158.077 438.174 163.602 425.922 163.602C392.05 163.602 370.91 137.897 370.91 100.422C370.91 62.9464 394.212 37.242 425.922 37.242C441.297 37.242 452.347 43.9684 457.152 48.7729C458.113 49.7338 459.314 49.2534 459.314 48.0523V1.20114C459.314 0.480467 459.794 0 460.515 0H486.94C487.661 0 488.141 0.480467 488.141 1.20114V159.998C488.141 160.719 487.661 161.199 486.94 161.199H464.118C462.677 161.199 461.956 160.959 461.716 159.998L459.314 152.311C459.074 151.35 457.632 151.35 456.671 152.311ZM399.737 100.422C399.737 122.042 410.307 137.177 430.727 137.177C449.945 137.177 459.314 122.042 459.314 100.422C459.314 76.3991 449.945 63.667 430.727 63.667C410.307 63.667 399.737 78.8014 399.737 100.422Z" fill="currentColor"></path>
       <path d="M199.738 152.474C193.492 158.72 186.951 163.601 167.973 163.601C137.464 163.601 121.609 146.785 121.609 124.924C121.609 104.265 140.107 86.0074 173.018 86.0074H194.398C199.203 86.0074 201.605 83.1247 201.605 80.7224C201.605 75.6776 201.125 63.6662 177.582 63.6662C159.325 63.6662 155.241 71.3535 154.521 79.5213C154.521 80.2419 154.04 80.7224 153.319 80.7224H127.135C126.414 80.7224 125.933 80.2419 125.933 79.5213C125.933 51.1744 149.236 37.2412 177.582 37.2412C210.734 37.2412 230.432 52.856 230.432 82.8844V129.489V134.034V135.382V138.953L230.613 153.464V161.199H214.771C202.28 161.199 205.861 162.375 201.9 152.474C201.42 151.754 200.459 151.754 199.738 152.474ZM167.973 137.176C192.717 137.176 201.605 123.243 201.605 111.231C201.605 110.511 201.125 110.03 200.404 110.03H174.219C154.04 110.03 150.437 118.678 150.437 124.924C150.437 129.969 154.761 137.176 167.973 137.176Z" fill="currentColor"></path>
       <path d="M324.492 152.474C318.246 158.72 311.705 163.601 292.727 163.601C262.218 163.601 246.363 146.785 246.363 124.924C246.363 104.265 264.861 86.0074 297.772 86.0074H319.152C323.957 86.0074 326.359 83.1247 326.359 80.7224C326.359 75.6776 325.879 63.6662 302.336 63.6662C284.079 63.6662 279.995 71.3535 279.274 79.5213C279.274 80.2419 278.794 80.7224 278.073 80.7224H251.889C251.168 80.7224 250.687 80.2419 250.687 79.5213C250.687 51.1744 273.989 37.2412 302.336 37.2412C335.488 37.2412 355.186 52.856 355.186 82.8844V129.489V134.034V135.382V138.953L355.367 153.464V161.199H339.525C327.034 161.199 330.615 162.375 326.654 152.474C326.174 151.754 325.213 151.754 324.492 152.474ZM292.727 137.176C317.471 137.176 326.359 123.243 326.359 111.231C326.359 110.511 325.879 110.03 325.158 110.03H298.973C278.794 110.03 275.191 118.678 275.191 124.924C275.191 129.969 279.515 137.176 292.727 137.176Z" fill="currentColor"></path>
       <path d="M62.0399 133.815L91.1075 41.327C91.3477 40.3661 92.3086 39.6454 93.0293 39.6454H120.175C121.136 39.6454 121.616 40.3661 121.376 41.327L81.7386 159.999C81.4984 160.72 81.0179 161.201 80.2972 161.201H41.3804C40.6597 161.201 40.1792 160.72 39.939 159.999L0.0612182 41.327C-0.179009 40.3661 0.301446 39.6454 1.26236 39.6454H28.8885C29.6092 39.6454 30.3299 40.3661 30.5701 41.327L59.6377 133.815C60.1181 135.016 61.5595 135.016 62.0399 133.815Z" fill="currentColor"></path>
       <path d="M702.115 198.837V176.431C702.115 175.733 702.584 175.5 703.288 175.5H713.845C720.648 175.5 726.512 169.683 726.512 162.935V127.959C726.512 109.112 734.723 103.111 740.353 101.25C742.212 100.635 742.26 98.988 740.353 98.3333C734.254 96.2392 726.512 91.353 726.512 71.8079V37.0648C726.512 30.3171 720.648 24.5001 713.845 24.5001H703.288C702.584 24.5001 702.115 24.2675 702.115 23.5694V1.16339C702.115 0.465365 702.584 0 703.288 0H716.19C738.476 0 753.479 10.9359 753.479 33.0404V78.3229C753.479 85.3033 756.942 90.8876 769.873 90.8876H773.895C774.599 90.8876 775.068 91.3529 775.068 92.051V108.182C775.068 108.88 774.599 109.345 773.895 109.345H769.873C759.912 109.345 753.479 114.929 753.479 121.677V167.192C753.479 189.297 738.476 200 716.19 200H703.288C702.584 200 702.115 199.535 702.115 198.837Z" fill="#007BFF"></path>
       <path d="M833.605 98.5612L777.005 74.8648C776.228 74.4099 776.073 73.5 776.073 72.8177L776.073 44.7533C776.073 44.071 776.383 43.3886 777.16 43.8435L870.099 90.3853C870.565 90.6128 870.876 91.0677 870.876 91.75L870.876 107.886C870.876 108.569 870.565 109.024 870.099 109.251L777.006 156.123C776.229 156.578 775.918 156.123 775.918 155.213L776.072 126.128C776.072 125.445 776.383 124.536 777.005 124.308L833.605 100.225C833.889 100.225 833.889 98.5612 833.605 98.5612Z" fill="#007BFF"></path> 
      </svg>
        <p>
          Commercial features require a subscription – 
          <a href="https://vaadin.com/commercial-license-info" target="_blank">
            commercial license info
            <svg aria-label="(opens new tab)" xmlns="http://www.w3.org/2000/svg" height="18" viewBox="0 -960 960 960" width="18">
              <path d="m256-240-56-56 384-384H240v-80h480v480h-80v-344L256-240Z"></path>
            </svg>
          </a>
        </p>
        <button aria-label="Close" class="close" title="close">
          <svg aria-hidden="true" xmlns="http://www.w3.org/2000/svg" height="18" viewBox="0 -960 960 960" width="18"><path d="m256-200-56-56 224-224-224-224 56-56 224 224 224-224 56 56-224 224 224 224-56 56-224-224-224 224Z"></path></svg>
        </button>
      `;

    shadowRoot.querySelector('.close').addEventListener('click', () => {
      this.remove();
    });
  }
}

// Register the custom element
customElements.define('vaadin-commercial-banner', VaadinCommercialBanner);
