/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.internal.StringUtil;
import com.vaadin.flow.server.frontend.AbstractTaskClientGenerator;
import com.vaadin.flow.server.frontend.Options;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public class TaskGenerateServiceWorker
extends AbstractTaskClientGenerator {
    private Options options;

    TaskGenerateServiceWorker(Options options) {
        this.options = options;
    }

    @Override
    protected String getFileContent() throws IOException {
        try (InputStream swStream = this.getClass().getResourceAsStream("sw.ts");){
            String string = StringUtil.toUTF8String(swStream);
            return string;
        }
    }

    @Override
    protected File getGeneratedFile() {
        return new File(this.options.getBuildDirectory(), "sw.ts");
    }

    @Override
    protected boolean shouldGenerate() {
        File serviceWorker = new File(this.options.getFrontendDirectory(), "sw.ts");
        File serviceWorkerJs = new File(this.options.getFrontendDirectory(), "sw.js");
        return !serviceWorker.exists() && !serviceWorkerJs.exists();
    }
}

