/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.communication.rpc;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.page.History;
import com.vaadin.flow.router.Location;
import com.vaadin.flow.router.NavigationTrigger;
import com.vaadin.flow.server.communication.rpc.RpcInvocationHandler;
import java.util.Optional;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.BaseJsonNode;

public class NavigationRpcHandler
implements RpcInvocationHandler {
    @Override
    public String getRpcType() {
        return "navigation";
    }

    @Override
    public Optional<Runnable> handle(UI ui, JsonNode invocationJson) {
        History history = ui.getPage().getHistory();
        History.HistoryStateChangeHandler historyStateChangeHandler = history.getHistoryStateChangeHandler();
        if (historyStateChangeHandler != null) {
            BaseJsonNode state = (BaseJsonNode)invocationJson.get("state");
            String location = invocationJson.get("location").asString();
            boolean triggeredByLink = invocationJson.has("link");
            NavigationTrigger trigger = triggeredByLink ? NavigationTrigger.ROUTER_LINK : NavigationTrigger.HISTORY;
            History.HistoryStateChangeEvent event = new History.HistoryStateChangeEvent(history, state, new Location(location), trigger);
            historyStateChangeHandler.onHistoryStateChange(event);
        }
        return Optional.empty();
    }
}

