/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.function.DeploymentConfiguration;
import com.vaadin.flow.internal.JacksonUtils;
import com.vaadin.flow.server.DefaultDeploymentConfiguration;
import com.vaadin.flow.server.PropertyDeploymentConfiguration;
import com.vaadin.flow.server.VaadinConfig;
import com.vaadin.flow.server.startup.AbstractConfigurationFactory;
import com.vaadin.flow.server.startup.ApplicationConfiguration;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import org.slf4j.LoggerFactory;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.ObjectNode;

public class DeploymentConfigurationFactory
extends AbstractConfigurationFactory
implements Serializable {
    public DeploymentConfiguration createDeploymentConfiguration(Class<?> systemPropertyBaseClass, VaadinConfig vaadinConfig) {
        return new DefaultDeploymentConfiguration(ApplicationConfiguration.get(vaadinConfig.getVaadinContext()), systemPropertyBaseClass, this.createInitParameters(systemPropertyBaseClass, vaadinConfig));
    }

    public DeploymentConfiguration createPropertyDeploymentConfiguration(Class<?> systemPropertyBaseClass, VaadinConfig vaadinConfig) {
        return new PropertyDeploymentConfiguration(ApplicationConfiguration.get(vaadinConfig.getVaadinContext()), systemPropertyBaseClass, this.createInitParameters(systemPropertyBaseClass, vaadinConfig));
    }

    protected Properties createInitParameters(Class<?> systemPropertyBaseClass, VaadinConfig vaadinConfig) {
        Properties initParameters = new Properties();
        DeploymentConfigurationFactory.readUiFromEnclosingClass(systemPropertyBaseClass, initParameters);
        Enumeration<String> e = vaadinConfig.getConfigParameterNames();
        while (e.hasMoreElements()) {
            String name = e.nextElement();
            String value = vaadinConfig.getConfigParameter(name);
            if (value != null) {
                initParameters.setProperty(name, value);
                continue;
            }
            LoggerFactory.getLogger(DeploymentConfigurationFactory.class).debug("Ignoring NULL init parameter {}", (Object)name);
        }
        this.readBuildInfo(initParameters);
        return initParameters;
    }

    private void readBuildInfo(Properties initParameters) {
        String json = this.getTokenFileContent(initParameters::getProperty);
        if (json != null) {
            ObjectNode buildInfo = JacksonUtils.readTree(json);
            Map<String, String> properties = this.getConfigParametersUsingTokenData((JsonNode)buildInfo);
            for (Map.Entry<String, String> entry : properties.entrySet()) {
                if (initParameters.containsKey(entry.getKey())) continue;
                initParameters.put(entry.getKey(), entry.getValue());
            }
        }
    }

    private static void readUiFromEnclosingClass(Class<?> systemPropertyBaseClass, Properties initParameters) {
        Class<?> enclosingClass = systemPropertyBaseClass.getEnclosingClass();
        if (enclosingClass != null && UI.class.isAssignableFrom(enclosingClass)) {
            initParameters.put("UI", enclosingClass.getName());
        }
    }
}

