/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.server.ExecutionFailedException;
import com.vaadin.flow.server.frontend.FallibleCommand;
import com.vaadin.flow.server.frontend.Options;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskUpdateOldIndexTs
implements FallibleCommand {
    private final File frontendDirectory;

    TaskUpdateOldIndexTs(Options options) {
        this.frontendDirectory = options.getFrontendDirectory();
    }

    @Override
    public void execute() throws ExecutionFailedException {
        Arrays.asList("index.tsx", "index.ts", "index.js").stream().map(type -> new File(this.frontendDirectory, (String)type)).filter(File::exists).forEach(this::modifyImportsIfNeeded);
    }

    private void modifyImportsIfNeeded(File indexFile) {
        try {
            String content = Files.readString(indexFile.toPath(), StandardCharsets.UTF_8);
            String updated = content.replaceFirst("(['\"])../target/frontend/generated-flow-imports", "$1Frontend/generated/flow/generated-flow-imports.js");
            if (!updated.equals(content)) {
                Files.writeString(indexFile.toPath(), (CharSequence)updated, new OpenOption[0]);
            }
        }
        catch (IOException e) {
            this.getLogger().error("Unable to read or update " + String.valueOf(indexFile), (Throwable)e);
        }
    }

    private Logger getLogger() {
        return LoggerFactory.getLogger(this.getClass());
    }
}

