/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.server.frontend.FrontendTools;
import com.vaadin.flow.server.frontend.FrontendToolsLocator;
import com.vaadin.flow.server.frontend.FrontendUtils;
import com.vaadin.flow.server.frontend.FrontendVersion;
import com.vaadin.flow.server.frontend.installer.InstallationException;
import com.vaadin.flow.server.frontend.installer.NodeInstaller;
import com.vaadin.flow.server.frontend.installer.ProxyConfig;
import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NodeResolver
implements Serializable {
    private final FrontendToolsLocator frontendToolsLocator = new FrontendToolsLocator();
    private final String alternativeDir;
    private final String nodeVersion;
    private final URI nodeDownloadRoot;
    private final boolean forceAlternativeNode;
    private final List<ProxyConfig.Proxy> proxies;

    NodeResolver(String alternativeDir, String nodeVersion, URI nodeDownloadRoot, boolean forceAlternativeNode, List<ProxyConfig.Proxy> proxies) {
        this.alternativeDir = Objects.requireNonNull(alternativeDir);
        this.nodeVersion = Objects.requireNonNull(nodeVersion);
        this.nodeDownloadRoot = Objects.requireNonNull(nodeDownloadRoot);
        this.forceAlternativeNode = forceAlternativeNode;
        this.proxies = Objects.requireNonNull(proxies);
    }

    ActiveNodeInstallation resolve() {
        ActiveNodeInstallation globalInstallation;
        if (!this.forceAlternativeNode && (globalInstallation = this.tryUseGlobalNode()) != null) {
            return globalInstallation;
        }
        return this.resolveOrInstallAlternativeNode();
    }

    private ActiveNodeInstallation tryUseGlobalNode() {
        String nodeCommand = FrontendUtils.isWindows() ? "node.exe" : "node";
        File nodeExecutable = this.frontendToolsLocator.tryLocateTool(nodeCommand).orElse(null);
        if (nodeExecutable == null) {
            return null;
        }
        try {
            String npmVersion;
            ArrayList<String> versionCommand = new ArrayList<String>();
            versionCommand.add(nodeExecutable.getAbsolutePath());
            versionCommand.add("--version");
            FrontendVersion installedNodeVersion = FrontendUtils.getVersion("node", versionCommand);
            if (installedNodeVersion.isOlderThan(FrontendTools.SUPPORTED_NODE_VERSION)) {
                this.getLogger().info("The globally installed Node.js version {} is older than the required minimum version {}. Using Node.js from {}.", new Object[]{installedNodeVersion.getFullVersion(), FrontendTools.SUPPORTED_NODE_VERSION.getFullVersion(), this.alternativeDir});
                return null;
            }
            if (installedNodeVersion.getMajorVersion() > 24) {
                this.getLogger().info("The globally installed Node.js version {}.x is newer than the maximum supported version {}.x and may not be compatible. Using Node.js from {}.", new Object[]{installedNodeVersion.getMajorVersion(), 24, this.alternativeDir});
                return null;
            }
            String npmCliScript = this.getGlobalNpmCliScript(nodeExecutable);
            if (npmCliScript == null) {
                this.getLogger().debug("npm-cli.js not found in global Node.js installation, will use alternative directory");
                return null;
            }
            try {
                npmVersion = FrontendUtils.getVersion("npm", List.of(nodeExecutable.getAbsolutePath(), npmCliScript, "--version")).getFullVersion();
            }
            catch (FrontendUtils.UnknownVersionException e) {
                this.getLogger().debug("Could not determine npm version from global installation", (Throwable)e);
                npmVersion = "unknown";
            }
            this.getLogger().info("Using globally installed Node.js version {}", (Object)installedNodeVersion.getFullVersion());
            return new ActiveNodeInstallation(nodeExecutable.getAbsolutePath(), installedNodeVersion.getFullVersion(), npmCliScript, npmVersion);
        }
        catch (FrontendUtils.UnknownVersionException e) {
            this.getLogger().error("Failed to get version for installed node.", (Throwable)e);
            return null;
        }
    }

    private String getGlobalNpmCliScript(File nodeExecutable) {
        String[] possiblePaths;
        String[] stringArray;
        File nodeDir = nodeExecutable.getParentFile();
        boolean isWindows = FrontendUtils.isWindows();
        if (isWindows) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "..\\node_modules\\npm\\bin\\npm-cli.js";
        } else {
            String[] stringArray3 = new String[1];
            stringArray = stringArray3;
            stringArray3[0] = "../lib/node_modules/npm/bin/npm-cli.js";
        }
        for (String path : possiblePaths = stringArray) {
            File npmCliScript = new File(nodeDir, path);
            if (!npmCliScript.exists()) continue;
            return npmCliScript.getAbsolutePath();
        }
        return null;
    }

    private ActiveNodeInstallation resolveOrInstallAlternativeNode() {
        String fallbackVersion;
        String versionToUse;
        File nodeExecutable;
        File alternativeDirFile = new File(this.alternativeDir);
        NodeInstaller nodeInstaller = new NodeInstaller(alternativeDirFile, this.proxies);
        if (this.nodeDownloadRoot != null) {
            nodeInstaller.setNodeDownloadRoot(this.nodeDownloadRoot);
        }
        if ((nodeExecutable = this.getNodeExecutableForVersion(alternativeDirFile, versionToUse = this.nodeVersion)).exists()) {
            try {
                String normalizedRequested;
                String installedVersion = FrontendUtils.getVersion("node", List.of(nodeExecutable.getAbsolutePath(), "--version")).getFullVersion();
                String normalizedInstalled = installedVersion.startsWith("v") ? installedVersion.substring(1) : installedVersion;
                String string = normalizedRequested = this.nodeVersion.startsWith("v") ? this.nodeVersion.substring(1) : this.nodeVersion;
                if (normalizedInstalled.equals(normalizedRequested)) {
                    this.getLogger().info("Node {} is already installed in {}", (Object)this.nodeVersion, (Object)this.alternativeDir);
                    return this.createActiveInstallation(nodeExecutable, versionToUse, alternativeDirFile);
                }
            }
            catch (FrontendUtils.UnknownVersionException e) {
                this.getLogger().debug("Could not verify version of existing node installation", (Throwable)e);
            }
        }
        if ((fallbackVersion = this.findCompatibleInstalledVersion(alternativeDirFile)) != null) {
            this.getLogger().debug("Using existing Node {} instead of installing {}", (Object)fallbackVersion, (Object)this.nodeVersion);
            versionToUse = fallbackVersion;
            nodeExecutable = this.getNodeExecutableForVersion(alternativeDirFile, versionToUse);
            return this.createActiveInstallation(nodeExecutable, versionToUse, alternativeDirFile);
        }
        this.getLogger().info("Installing Node {} to {}", (Object)this.nodeVersion, (Object)this.alternativeDir);
        try {
            nodeInstaller.setNodeVersion(this.nodeVersion);
            nodeInstaller.install();
            nodeExecutable = this.getNodeExecutableForVersion(alternativeDirFile, this.nodeVersion);
            return this.createActiveInstallation(nodeExecutable, this.nodeVersion, alternativeDirFile);
        }
        catch (InstallationException e) {
            throw new IllegalStateException("Failed to install Node", e);
        }
    }

    private ActiveNodeInstallation createActiveInstallation(File nodeExecutable, String version, File installDir) {
        String npmVersion;
        String nodePath;
        String string = nodePath = nodeExecutable.exists() ? nodeExecutable.getAbsolutePath() : null;
        if (nodePath == null) {
            throw new IllegalStateException("Node installation failed - executable not found at " + String.valueOf(nodeExecutable));
        }
        String npmCliScript = this.getNpmCliScriptPath(installDir, version);
        if (npmCliScript == null) {
            String versionedPath = "node-v" + (version.startsWith("v") ? version.substring(1) : version);
            boolean isWindows = FrontendUtils.isWindows();
            String expectedNpmPath = isWindows ? versionedPath + "\\node_modules\\npm\\bin\\npm-cli.js" : versionedPath + "/lib/node_modules/npm/bin/npm-cli.js";
            File expectedNpmFile = new File(installDir, expectedNpmPath);
            throw new IllegalStateException("npm-cli.js not found at expected location: " + expectedNpmFile.getAbsolutePath());
        }
        try {
            npmVersion = FrontendUtils.getVersion("npm", List.of(nodePath, npmCliScript, "--version")).getFullVersion();
        }
        catch (FrontendUtils.UnknownVersionException e) {
            this.getLogger().debug("Could not determine npm version", (Throwable)e);
            npmVersion = "unknown";
        }
        return new ActiveNodeInstallation(nodePath, version, npmCliScript, npmVersion);
    }

    private String findCompatibleInstalledVersion(File installDir) {
        if (!installDir.exists() || !installDir.isDirectory()) {
            return null;
        }
        File[] nodeDirs = installDir.listFiles(file -> file.isDirectory() && file.getName().startsWith("node-v"));
        if (nodeDirs == null || nodeDirs.length == 0) {
            return null;
        }
        FrontendVersion bestVersion = null;
        String bestVersionString = null;
        for (File nodeDir : nodeDirs) {
            String dirName = nodeDir.getName();
            String versionString = dirName.substring("node-".length());
            try {
                FrontendVersion version = new FrontendVersion(versionString);
                if (version.isOlderThan(FrontendTools.MINIMUM_AUTO_INSTALLED_NODE)) {
                    this.getLogger().debug("Skipping {} - older than minimum auto-installed {}", (Object)versionString, (Object)FrontendTools.MINIMUM_AUTO_INSTALLED_NODE.getFullVersion());
                    continue;
                }
                if (version.getMajorVersion() > 24) {
                    this.getLogger().debug("Skipping {} - major version {} is newer than maximum supported {}", new Object[]{versionString, version.getMajorVersion(), 24});
                    continue;
                }
                File nodeExecutable = this.getNodeExecutableForVersion(installDir, versionString);
                if (!nodeExecutable.exists()) {
                    this.getLogger().debug("Skipping {} - executable not found at {}", (Object)versionString, (Object)nodeExecutable);
                    continue;
                }
                if (bestVersion != null && !version.isNewerThan(bestVersion)) continue;
                bestVersion = version;
                bestVersionString = versionString;
            }
            catch (NumberFormatException e) {
                this.getLogger().debug("Could not parse version from directory: {}", (Object)dirName);
            }
        }
        return bestVersionString;
    }

    private File getNodeExecutableForVersion(File installDir, String version) {
        String versionedPath = "node-v" + (version.startsWith("v") ? version.substring(1) : version);
        boolean isWindows = FrontendUtils.isWindows();
        String nodeExecutable = isWindows ? versionedPath + "\\node.exe" : versionedPath + "/bin/node";
        return new File(installDir, nodeExecutable);
    }

    private String getNpmCliScriptPath(File installDir, String version) {
        String versionedPath = "node-v" + (version.startsWith("v") ? version.substring(1) : version);
        boolean isWindows = FrontendUtils.isWindows();
        String npmPath = isWindows ? versionedPath + "\\node_modules\\npm\\bin\\npm-cli.js" : versionedPath + "/lib/node_modules/npm/bin/npm-cli.js";
        File npmCliScript = new File(installDir, npmPath);
        return npmCliScript.exists() ? npmCliScript.getAbsolutePath() : null;
    }

    private Logger getLogger() {
        return LoggerFactory.getLogger(NodeResolver.class);
    }

    record ActiveNodeInstallation(String nodeExecutable, String nodeVersion, String npmCliScript, String npmVersion) implements Serializable
    {
        ActiveNodeInstallation {
            Objects.requireNonNull(nodeExecutable);
            Objects.requireNonNull(nodeVersion);
            Objects.requireNonNull(npmCliScript);
            Objects.requireNonNull(npmVersion);
        }
    }
}

