/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.dom.Element;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import org.jsoup.helper.DataUtil;

public class Svg
extends Component {
    public Svg(InputStream stream) {
        this();
        this.setSvg(stream);
    }

    public Svg(String svg) {
        this();
        this.setSvg(svg);
    }

    public Svg() {
        super(new Element("div"));
    }

    public void setSvg(String svg) {
        if (svg == null || svg.isEmpty()) {
            this.setInnerHtml("");
        } else {
            this.validateAndSet(svg);
        }
    }

    public void setSvg(InputStream stream) {
        this.validateAndSet(this.readSvgStreamAsString(stream));
    }

    private String readSvgStreamAsString(InputStream stream) {
        if (stream == null) {
            throw new IllegalArgumentException("SVG stream cannot be null");
        }
        try {
            return StandardCharsets.UTF_8.decode(DataUtil.readToByteBuffer((InputStream)stream, (int)0)).toString();
        }
        catch (IOException e) {
            throw new UncheckedIOException("Unable to read SVG from stream", e);
        }
    }

    private void validateAndSet(String svgInput) {
        if (!svgInput.startsWith("<svg")) {
            int startIndex = svgInput.indexOf("<svg");
            if (startIndex == -1) {
                throw new IllegalArgumentException("The content don't appear to be SVG");
            }
            svgInput = svgInput.substring(startIndex);
        }
        this.setInnerHtml(svgInput);
    }

    private void setInnerHtml(String html) {
        this.getElement().setProperty("innerHTML", html);
    }
}

