/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component;

import com.vaadin.flow.internal.JacksonUtils;
import java.io.Serializable;
import tools.jackson.databind.node.ObjectNode;

public interface FocusOption
extends Serializable {
    public static ObjectNode buildOptions(FocusOption ... options) {
        FocusVisible focusVisible = FocusVisible.DEFAULT;
        PreventScroll preventScroll = PreventScroll.DEFAULT;
        for (FocusOption option : options) {
            if (option instanceof FocusVisible) {
                focusVisible = (FocusVisible)option;
                continue;
            }
            if (!(option instanceof PreventScroll)) continue;
            preventScroll = (PreventScroll)option;
        }
        if (preventScroll == PreventScroll.DEFAULT && focusVisible == FocusVisible.DEFAULT) {
            return null;
        }
        ObjectNode json = JacksonUtils.createObjectNode();
        if (preventScroll != PreventScroll.DEFAULT) {
            json.put("preventScroll", preventScroll == PreventScroll.ENABLED);
        }
        if (focusVisible != FocusVisible.DEFAULT) {
            json.put("focusVisible", focusVisible == FocusVisible.VISIBLE);
        }
        return json;
    }

    public static enum FocusVisible implements FocusOption
    {
        DEFAULT,
        VISIBLE,
        NOT_VISIBLE;

    }

    public static enum PreventScroll implements FocusOption
    {
        DEFAULT,
        ENABLED,
        DISABLED;

    }
}

