/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server;

import com.vaadin.flow.component.page.AppShellConfigurator;
import com.vaadin.flow.di.Lookup;
import com.vaadin.flow.di.ResourceProvider;
import com.vaadin.flow.internal.JacksonUtils;
import com.vaadin.flow.server.AppShellRegistry;
import com.vaadin.flow.server.BootstrapHandler;
import com.vaadin.flow.server.PWA;
import com.vaadin.flow.server.PwaConfiguration;
import com.vaadin.flow.server.PwaIcon;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinServletContext;
import com.vaadin.flow.server.VaadinServletService;
import com.vaadin.flow.server.startup.ApplicationConfiguration;
import com.vaadin.flow.server.startup.ApplicationRouteRegistry;
import jakarta.servlet.ServletContext;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.ArrayNode;
import tools.jackson.databind.node.ObjectNode;

public class PwaRegistry
implements Serializable {
    private static final String META_INF_RESOURCES = "/META-INF/resources";
    private static final String HEADLESS_PROPERTY = "java.awt.headless";
    private static final String APPLE_STARTUP_IMAGE = "apple-touch-startup-image";
    private static final String APPLE_IMAGE_MEDIA = "screen and (device-width: %dpx) and (device-height: %dpx) and (-webkit-device-pixel-ratio: %d) and (orientation: %s)";
    private static final String ORIENTATION_PORTRAIT = "portrait";
    private static final String ORIENTATION_LANDSCAPE = "landscape";
    private static final String WORKBOX_CACHE_FORMAT = "{ url: '%s', revision: '%s' }";
    private String offlineHtml = "";
    private String manifestJson = "";
    private String runtimeServiceWorkerJs = "";
    private long offlineHash;
    private List<PwaIcon> icons = new ArrayList<PwaIcon>();
    private final PwaConfiguration pwaConfiguration;
    private URL baseImageUrl;
    private BufferedImage baseImage;

    public PwaRegistry(PWA pwa, ServletContext servletContext) throws IOException {
        if (System.getProperty(HEADLESS_PROPERTY) == null) {
            System.setProperty(HEADLESS_PROPERTY, Boolean.TRUE.toString());
        }
        this.pwaConfiguration = pwa == null ? new PwaConfiguration() : new PwaConfiguration(pwa);
        this.initializeResources(servletContext);
    }

    BufferedImage getBaseImage() {
        if (this.baseImage == null && this.baseImageUrl != null) {
            try {
                this.baseImage = this.getBaseImage(this.baseImageUrl);
            }
            catch (IOException ex) {
                PwaRegistry.getLogger().error("Image is not found or can't be loaded: {}", (Object)this.baseImageUrl);
            }
            finally {
                this.baseImageUrl = null;
            }
        }
        return this.baseImage;
    }

    private void initializeResources(ServletContext servletContext) throws IOException {
        if (!this.pwaConfiguration.isEnabled()) {
            return;
        }
        long start = System.currentTimeMillis();
        URL logo = this.getResourceUrl(servletContext, this.pwaConfiguration.relIconPath());
        this.baseImageUrl = logo != null ? logo : BootstrapHandler.class.getResource("default-logo.png");
        URL offlinePage = this.pwaConfiguration.isOfflinePathEnabled() ? this.getResourceUrl(servletContext, this.pwaConfiguration.relOfflinePath()) : null;
        this.icons = this.initializeIcons(servletContext);
        this.offlineHtml = this.initializeOfflinePage(this.pwaConfiguration, offlinePage);
        this.offlineHash = this.offlineHtml.hashCode();
        this.manifestJson = this.initializeManifest().toString();
        this.runtimeServiceWorkerJs = this.initializeRuntimeServiceWorker(servletContext);
        PwaRegistry.getLogger().debug(this.getClass().getSimpleName() + " initialization took {}ms", (Object)(System.currentTimeMillis() - start));
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(PwaRegistry.class);
    }

    private URL getResourceUrl(ServletContext context, String path) throws MalformedURLException {
        URL resourceUrl = VaadinServletService.getStaticResource(context, path);
        if (resourceUrl == null) {
            String cpPath = path.startsWith("/") ? META_INF_RESOURCES + path : "/META-INF/resources/" + path;
            resourceUrl = PwaRegistry.class.getResource(cpPath);
        }
        return resourceUrl;
    }

    private List<PwaIcon> initializeIcons(ServletContext servletContext) {
        Optional<ResourceProvider> optionalResourceProvider = Optional.ofNullable(new VaadinServletContext(servletContext).getAttribute(Lookup.class)).map(lookup -> lookup.lookup(ResourceProvider.class));
        for (PwaIcon icon : PwaRegistry.getIconTemplates(this.pwaConfiguration.getIconPath())) {
            icon.setRegistry(this);
            String iconPath = "META-INF/VAADIN/webapp/pwa-icons/" + icon.getRelHref().substring(1);
            optionalResourceProvider.ifPresent(provider -> PwaRegistry.tryLoadGeneratedIcon(provider, icon, iconPath));
            if (!icon.isAvailable()) continue;
            this.icons.add(icon);
        }
        return this.icons;
    }

    private static void tryLoadGeneratedIcon(ResourceProvider resourceProvider, PwaIcon icon, String iconPath) {
        URL iconResource = resourceProvider.getApplicationResource(iconPath);
        if (iconResource != null) {
            try (InputStream data = iconResource.openStream();){
                icon.setImage(data);
                PwaRegistry.getLogger().trace("Loading generated PWA image from {}", (Object)iconPath);
            }
            catch (IOException ex) {
                PwaRegistry.getLogger().debug("Cannot load generated PWA image from {}. Icon will be regenerated at runtime.", (Object)iconPath, (Object)ex);
            }
        }
    }

    private JsonNode initializeManifest() {
        ObjectNode manifestData = JacksonUtils.createObjectNode();
        manifestData.put("name", this.pwaConfiguration.getAppName());
        manifestData.put("short_name", this.pwaConfiguration.getShortName());
        if (!this.pwaConfiguration.getDescription().isEmpty()) {
            manifestData.put("description", this.pwaConfiguration.getDescription());
        }
        manifestData.put("display", this.pwaConfiguration.getDisplay());
        manifestData.put("background_color", this.pwaConfiguration.getBackgroundColor());
        manifestData.put("theme_color", this.pwaConfiguration.getThemeColor());
        manifestData.put("start_url", this.pwaConfiguration.getStartUrl());
        ArrayNode iconList = JacksonUtils.createArrayNode();
        for (PwaIcon icon : this.getManifestIcons()) {
            ObjectNode iconData = JacksonUtils.createObjectNode();
            iconData.put("src", icon.getHref());
            iconData.put("sizes", icon.getSizes());
            iconData.put("type", icon.getType());
            iconList.add((JsonNode)iconData);
        }
        manifestData.set("icons", (JsonNode)iconList);
        return manifestData;
    }

    private String initializeRuntimeServiceWorker(ServletContext servletContext) {
        StringBuilder stringBuilder = new StringBuilder();
        Collection filesToCache = this.getIcons().stream().filter(PwaIcon::shouldBeCached).map(PwaIcon::getCacheFormat).collect(Collectors.toCollection(LinkedHashSet::new));
        if (this.pwaConfiguration.isOfflinePathEnabled()) {
            filesToCache.add(this.offlinePageCache(this.pwaConfiguration.getOfflinePath()));
        } else if (this.shouldCacheRoot()) {
            filesToCache.add(this.offlinePageCache("."));
        }
        filesToCache.add(this.offlinePageCache("offline-stub.html"));
        filesToCache.add(this.manifestCache());
        for (String resource : this.pwaConfiguration.getOfflineResources()) {
            filesToCache.add(String.format(WORKBOX_CACHE_FORMAT, resource.replaceAll("'", ""), servletContext.hashCode()));
        }
        stringBuilder.append("self.additionalManifestEntries = [\n");
        stringBuilder.append(String.join((CharSequence)",\n", filesToCache));
        stringBuilder.append("\n];\n");
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PwaRegistry getInstance(ServletContext servletContext) {
        Object attribute;
        assert (servletContext != null);
        ServletContext servletContext2 = servletContext;
        synchronized (servletContext2) {
            attribute = servletContext.getAttribute(PwaRegistry.class.getName());
            if (attribute == null) {
                VaadinServletContext context = new VaadinServletContext(servletContext);
                Class<AppShellConfigurator> clazz = AppShellRegistry.getInstance(context).getShell();
                if (clazz == null) {
                    clazz = ApplicationRouteRegistry.getInstance(context).getPwaConfigurationClass();
                }
                PWA pwa = clazz != null ? clazz.getAnnotation(PWA.class) : null;
                try {
                    attribute = new PwaRegistry(pwa, servletContext);
                    servletContext.setAttribute(PwaRegistry.class.getName(), attribute);
                }
                catch (IOException ioe) {
                    throw new UncheckedIOException("Failed to initialize the PWA registry", ioe);
                }
            }
        }
        if (attribute instanceof PwaRegistry) {
            return (PwaRegistry)attribute;
        }
        throw new IllegalStateException("Unknown servlet context attribute value: " + String.valueOf(attribute));
    }

    private String initializeOfflinePage(PwaConfiguration config, URL resource) throws IOException {
        List iconList = this.getIcons().stream().filter(PwaIcon::shouldBeCached).collect(Collectors.toList());
        String iconHead = iconList.stream().map(icon -> icon.asElement().toString()).collect(Collectors.joining("\n"));
        PwaIcon largest = iconList.stream().min((icon1, icon2) -> icon2.getWidth() - icon1.getWidth()).orElse(null);
        URLConnection connection = resource != null ? resource.openConnection() : BootstrapHandler.class.getResource("default-offline-page.html").openConnection();
        String offlinePage = this.getOfflinePageFromContext(connection);
        return offlinePage.replace("%%%PROJECT_NAME%%%", config.getAppName()).replace("%%%BACKGROUND_COLOR%%%", config.getBackgroundColor()).replace("%%%LOGO_PATH%%%", largest != null ? largest.getHref() : "").replace("%%%META_ICONS%%%", iconHead);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private String getOfflinePageFromContext(URLConnection connection) {
        try (InputStream stream = connection.getInputStream();){
            String string;
            try (BufferedReader bf = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));){
                StringBuilder builder = new StringBuilder();
                bf.lines().forEach(builder::append);
                string = builder.toString();
            }
            return string;
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to retrieve offline page from the servlet context", e);
        }
    }

    private BufferedImage getBaseImage(URL logo) throws IOException {
        URLConnection logoResource = logo != null ? logo.openConnection() : BootstrapHandler.class.getResource("default-logo.png").openConnection();
        try (InputStream inputStream = logoResource.getInputStream();){
            BufferedImage bufferedImage = ImageIO.read(inputStream);
            return bufferedImage;
        }
    }

    public String getOfflineHtml() {
        return this.offlineHtml;
    }

    public String getManifestJson() {
        return this.manifestJson;
    }

    public String getRuntimeServiceWorkerJs() {
        return this.runtimeServiceWorkerJs;
    }

    private String offlinePageCache(String offlinePath) {
        return String.format(WORKBOX_CACHE_FORMAT, offlinePath, this.offlineHash);
    }

    private String manifestCache() {
        return String.format(WORKBOX_CACHE_FORMAT, this.pwaConfiguration.getManifestPath(), this.manifestJson.hashCode());
    }

    public List<PwaIcon> getHeaderIcons() {
        return this.getIcons(PwaIcon.Domain.HEADER);
    }

    public List<PwaIcon> getManifestIcons() {
        return this.getIcons(PwaIcon.Domain.MANIFEST);
    }

    public List<PwaIcon> getIcons() {
        return new ArrayList<PwaIcon>(this.icons);
    }

    private List<PwaIcon> getIcons(PwaIcon.Domain domain) {
        return this.icons.stream().filter(icon -> icon.getDomain().equals((Object)domain)).collect(Collectors.toList());
    }

    public PwaConfiguration getPwaConfiguration() {
        return this.pwaConfiguration;
    }

    public static List<PwaIcon> getIconTemplates(String baseName) {
        ArrayList<PwaIcon> icons = new ArrayList<PwaIcon>();
        icons.add(new PwaIcon(144, 144, baseName, PwaIcon.Domain.MANIFEST, true));
        icons.add(new PwaIcon(192, 192, baseName, PwaIcon.Domain.MANIFEST, true));
        icons.add(new PwaIcon(512, 512, baseName, PwaIcon.Domain.MANIFEST, true));
        icons.add(new PwaIcon(16, 16, baseName, PwaIcon.Domain.HEADER, true, "shortcut icon", ""));
        icons.add(new PwaIcon(32, 32, baseName, PwaIcon.Domain.HEADER, true));
        icons.add(new PwaIcon(96, 96, baseName));
        icons.add(new PwaIcon(180, 180, baseName, PwaIcon.Domain.HEADER, false, "apple-touch-icon", ""));
        icons.add(new PwaIcon(2048, 2732, baseName, PwaIcon.Domain.HEADER, false, APPLE_STARTUP_IMAGE, String.format(APPLE_IMAGE_MEDIA, 1024, 1366, 2, ORIENTATION_PORTRAIT)));
        icons.add(new PwaIcon(2732, 2048, baseName, PwaIcon.Domain.HEADER, false, APPLE_STARTUP_IMAGE, String.format(APPLE_IMAGE_MEDIA, 1024, 1366, 2, ORIENTATION_LANDSCAPE)));
        icons.add(new PwaIcon(1668, 2388, baseName, PwaIcon.Domain.HEADER, false, APPLE_STARTUP_IMAGE, String.format(APPLE_IMAGE_MEDIA, 834, 1194, 2, ORIENTATION_PORTRAIT)));
        icons.add(new PwaIcon(2388, 1668, baseName, PwaIcon.Domain.HEADER, false, APPLE_STARTUP_IMAGE, String.format(APPLE_IMAGE_MEDIA, 834, 1194, 2, ORIENTATION_LANDSCAPE)));
        icons.add(new PwaIcon(1668, 2224, baseName, PwaIcon.Domain.HEADER, false, APPLE_STARTUP_IMAGE, String.format(APPLE_IMAGE_MEDIA, 834, 1112, 2, ORIENTATION_PORTRAIT)));
        icons.add(new PwaIcon(2224, 1668, baseName, PwaIcon.Domain.HEADER, false, APPLE_STARTUP_IMAGE, String.format(APPLE_IMAGE_MEDIA, 834, 1112, 2, ORIENTATION_LANDSCAPE)));
        icons.add(new PwaIcon(1620, 2160, baseName, PwaIcon.Domain.HEADER, false, APPLE_STARTUP_IMAGE, String.format(APPLE_IMAGE_MEDIA, 768, 1024, 2, ORIENTATION_PORTRAIT)));
        icons.add(new PwaIcon(2160, 1620, baseName, PwaIcon.Domain.HEADER, false, APPLE_STARTUP_IMAGE, String.format(APPLE_IMAGE_MEDIA, 768, 1024, 2, ORIENTATION_LANDSCAPE)));
        icons.add(new PwaIcon(1536, 2048, baseName, PwaIcon.Domain.HEADER, false, APPLE_STARTUP_IMAGE, String.format(APPLE_IMAGE_MEDIA, 768, 1024, 2, ORIENTATION_PORTRAIT)));
        icons.add(new PwaIcon(2048, 1536, baseName, PwaIcon.Domain.HEADER, false, APPLE_STARTUP_IMAGE, String.format(APPLE_IMAGE_MEDIA, 768, 1024, 2, ORIENTATION_LANDSCAPE)));
        icons.add(new PwaIcon(1284, 2778, baseName, PwaIcon.Domain.HEADER, false, APPLE_STARTUP_IMAGE, String.format(APPLE_IMAGE_MEDIA, 428, 926, 3, ORIENTATION_PORTRAIT)));
        icons.add(new PwaIcon(2778, 1284, baseName, PwaIcon.Domain.HEADER, false, APPLE_STARTUP_IMAGE, String.format(APPLE_IMAGE_MEDIA, 428, 926, 3, ORIENTATION_LANDSCAPE)));
        icons.add(new PwaIcon(1170, 2532, baseName, PwaIcon.Domain.HEADER, false, APPLE_STARTUP_IMAGE, String.format(APPLE_IMAGE_MEDIA, 390, 844, 3, ORIENTATION_PORTRAIT)));
        icons.add(new PwaIcon(2532, 1170, baseName, PwaIcon.Domain.HEADER, false, APPLE_STARTUP_IMAGE, String.format(APPLE_IMAGE_MEDIA, 390, 844, 3, ORIENTATION_LANDSCAPE)));
        icons.add(new PwaIcon(1125, 2436, baseName, PwaIcon.Domain.HEADER, false, APPLE_STARTUP_IMAGE, String.format(APPLE_IMAGE_MEDIA, 375, 812, 3, ORIENTATION_PORTRAIT)));
        icons.add(new PwaIcon(2436, 1125, baseName, PwaIcon.Domain.HEADER, false, APPLE_STARTUP_IMAGE, String.format(APPLE_IMAGE_MEDIA, 375, 812, 3, ORIENTATION_LANDSCAPE)));
        icons.add(new PwaIcon(1242, 2688, baseName, PwaIcon.Domain.HEADER, false, APPLE_STARTUP_IMAGE, String.format(APPLE_IMAGE_MEDIA, 414, 896, 3, ORIENTATION_PORTRAIT)));
        icons.add(new PwaIcon(2688, 1242, baseName, PwaIcon.Domain.HEADER, false, APPLE_STARTUP_IMAGE, String.format(APPLE_IMAGE_MEDIA, 414, 896, 3, ORIENTATION_LANDSCAPE)));
        icons.add(new PwaIcon(828, 1792, baseName, PwaIcon.Domain.HEADER, false, APPLE_STARTUP_IMAGE, String.format(APPLE_IMAGE_MEDIA, 414, 896, 2, ORIENTATION_PORTRAIT)));
        icons.add(new PwaIcon(1792, 828, baseName, PwaIcon.Domain.HEADER, false, APPLE_STARTUP_IMAGE, String.format(APPLE_IMAGE_MEDIA, 414, 896, 2, ORIENTATION_LANDSCAPE)));
        icons.add(new PwaIcon(1242, 2208, baseName, PwaIcon.Domain.HEADER, false, APPLE_STARTUP_IMAGE, String.format(APPLE_IMAGE_MEDIA, 414, 736, 3, ORIENTATION_PORTRAIT)));
        icons.add(new PwaIcon(2208, 1242, baseName, PwaIcon.Domain.HEADER, false, APPLE_STARTUP_IMAGE, String.format(APPLE_IMAGE_MEDIA, 414, 736, 3, ORIENTATION_LANDSCAPE)));
        icons.add(new PwaIcon(750, 1334, baseName, PwaIcon.Domain.HEADER, false, APPLE_STARTUP_IMAGE, String.format(APPLE_IMAGE_MEDIA, 375, 667, 2, ORIENTATION_PORTRAIT)));
        icons.add(new PwaIcon(1334, 750, baseName, PwaIcon.Domain.HEADER, false, APPLE_STARTUP_IMAGE, String.format(APPLE_IMAGE_MEDIA, 375, 667, 2, ORIENTATION_LANDSCAPE)));
        icons.add(new PwaIcon(640, 1136, baseName, PwaIcon.Domain.HEADER, false, APPLE_STARTUP_IMAGE, String.format(APPLE_IMAGE_MEDIA, 320, 568, 2, ORIENTATION_PORTRAIT)));
        icons.add(new PwaIcon(1136, 640, baseName, PwaIcon.Domain.HEADER, false, APPLE_STARTUP_IMAGE, String.format(APPLE_IMAGE_MEDIA, 320, 568, 2, ORIENTATION_LANDSCAPE)));
        return icons;
    }

    private boolean shouldCacheRoot() {
        VaadinContext context = VaadinService.getCurrent().getContext();
        ApplicationConfiguration configuration = ApplicationConfiguration.get(context);
        return configuration != null && !configuration.isProductionMode();
    }
}

