/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.internal;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.dependency.StyleSheet;
import com.vaadin.flow.component.page.AppShellConfigurator;
import com.vaadin.flow.hotswap.HotswapClassEvent;
import com.vaadin.flow.hotswap.HotswapClassSessionEvent;
import com.vaadin.flow.hotswap.HotswapCompleteEvent;
import com.vaadin.flow.hotswap.HotswapResourceEvent;
import com.vaadin.flow.hotswap.UIUpdateStrategy;
import com.vaadin.flow.hotswap.VaadinHotswapper;
import com.vaadin.flow.internal.AnnotationReader;
import com.vaadin.flow.server.AppShellRegistry;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.frontend.FrontendUtils;
import com.vaadin.flow.shared.ui.Dependency;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StyleSheetHotswapper
implements VaadinHotswapper {
    public static final Logger LOGGER = LoggerFactory.getLogger(StyleSheetHotswapper.class);
    private static final String STYLESHEET_REGISTRY_KEY = Registry.class.getName();
    private final ConcurrentHashMap<String, Set<String>> appShellStylesheets = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Set<String>> componentStylesheets = new ConcurrentHashMap();

    @Override
    public void onInit(VaadinService vaadinService) {
        AppShellRegistry appShellRegistry = AppShellRegistry.getInstance(vaadinService.getContext());
        Class<? extends AppShellConfigurator> appShellClass = appShellRegistry.getShell();
        if (appShellClass != null) {
            this.appShellStylesheets.put(appShellClass.getName(), StyleSheetHotswapper.getStyleSheetUrls(appShellClass));
        }
    }

    @Override
    public void onHotswapComplete(HotswapCompleteEvent event) {
        event.getClasses().stream().filter(AppShellConfigurator.class::isAssignableFrom).forEach(clazz -> this.appShellStylesheets.put(clazz.getName(), StyleSheetHotswapper.getStyleSheetUrls(clazz)));
    }

    @Override
    public void onClassesChange(HotswapClassEvent event) {
        Set<Class<?>> classes = StyleSheetHotswapper.filterClasses(event);
        if (classes.isEmpty()) {
            return;
        }
        for (Class<?> clazz : classes) {
            if (!Component.class.isAssignableFrom(clazz)) continue;
            List<String> styleSheets = ComponentUtil.getDependencies(event.getVaadinService(), clazz).getStyleSheets().stream().map(StyleSheet::value).toList();
            if (!styleSheets.isEmpty()) {
                this.componentStylesheets.put(clazz.getName(), new LinkedHashSet<String>(styleSheets));
                continue;
            }
            this.componentStylesheets.remove(clazz.getName());
        }
    }

    @Override
    public void onClassesChange(HotswapClassSessionEvent event) {
        Set<Class<?>> classes = StyleSheetHotswapper.filterClasses(event);
        if (classes.isEmpty()) {
            return;
        }
        VaadinSession session = event.getVaadinSession();
        Registry registry = this.getRegistry(session);
        if (!event.isRedefined()) {
            this.getRegistry(session).updateState(classes);
            return;
        }
        for (Class<?> clazz : classes) {
            try {
                this.handleClassChange(event, clazz, registry);
            }
            catch (Exception e) {
                LOGGER.debug("Failed to handle stylesheet changes for class {}", (Object)clazz.getName(), (Object)e);
            }
        }
    }

    private static Set<Class<?>> filterClasses(HotswapClassEvent event) {
        return event.getChangedClasses().stream().filter(clazz -> Component.class.isAssignableFrom((Class<?>)clazz) || AppShellConfigurator.class.isAssignableFrom((Class<?>)clazz)).collect(Collectors.toSet());
    }

    private void handleClassChange(HotswapClassSessionEvent event, Class<?> clazz, Registry registry) {
        boolean isAppShellConfigurator = AppShellConfigurator.class.isAssignableFrom(clazz);
        boolean isComponent = Component.class.isAssignableFrom(clazz);
        Set<String> currentStylesheets = StyleSheetHotswapper.getStyleSheetUrls(clazz);
        Set<String> previousStylesheets = registry.previousState(clazz);
        if (previousStylesheets == null) {
            previousStylesheets = new LinkedHashSet<String>();
            ConcurrentHashMap<String, Set<String>> initialState = isAppShellConfigurator ? this.appShellStylesheets : this.componentStylesheets;
            Set initialStyles = (Set)initialState.get(clazz.getName());
            if (initialStyles != null) {
                previousStylesheets.addAll(initialStyles);
            }
        }
        LinkedHashSet<String> addedStylesheets = new LinkedHashSet<String>(currentStylesheets);
        addedStylesheets.removeAll(previousStylesheets);
        LinkedHashSet<String> removedStylesheets = new LinkedHashSet<String>(previousStylesheets);
        removedStylesheets.removeAll(currentStylesheets);
        if (addedStylesheets.isEmpty() && removedStylesheets.isEmpty()) {
            return;
        }
        if (isAppShellConfigurator) {
            this.handleAppShellConfiguratorChange(event, clazz, addedStylesheets, removedStylesheets, registry);
        } else if (isComponent) {
            this.handleComponentChange(event, clazz, addedStylesheets, removedStylesheets, registry);
        }
        registry.updateState(clazz, currentStylesheets);
    }

    private void handleAppShellConfiguratorChange(HotswapClassSessionEvent event, Class<?> clazz, Set<String> addedStylesheets, Set<String> removedStylesheets, Registry registry) {
        AppShellRegistry appShellRegistry = AppShellRegistry.getInstance(event.getVaadinService().getContext());
        Class<? extends AppShellConfigurator> appShellClass = appShellRegistry.getShell();
        if (appShellClass == null || !appShellClass.getName().equals(clazz.getName())) {
            return;
        }
        LOGGER.debug("Processing AppShellConfigurator stylesheet changes for {}: added={}, removed={}", new Object[]{clazz.getName(), addedStylesheets, removedStylesheets});
        this.updateUIs(event, clazz, addedStylesheets, removedStylesheets, registry);
    }

    private void handleComponentChange(HotswapClassSessionEvent event, Class<?> clazz, Set<String> addedStylesheets, Set<String> removedStylesheets, Registry registry) {
        LOGGER.debug("Processing Component stylesheet changes for {}: added={}, removed={}", new Object[]{clazz.getName(), addedStylesheets, removedStylesheets});
        this.updateUIs(event, clazz, addedStylesheets, removedStylesheets, registry);
    }

    private void updateUIs(HotswapClassSessionEvent event, Class<?> clazz, Set<String> addedStylesheets, Set<String> removedStylesheets, Registry registry) {
        boolean isAppShell = AppShellConfigurator.class.isAssignableFrom(clazz);
        VaadinSession session = event.getVaadinSession();
        for (UI ui : session.getUIs()) {
            Dependency dependency;
            if (ui.isClosing() || !isAppShell && !this.isComponentInUse(ui, clazz)) continue;
            for (String url : removedStylesheets) {
                if (registry.previousState(clazz) == null) {
                    dependency = ui.getInternals().getDependencyList().getDependencyByUrl(url, Dependency.Type.STYLESHEET);
                    if (dependency != null) {
                        ui.getInternals().removeStyleSheet(dependency.getId());
                        event.triggerUpdate(ui, UIUpdateStrategy.REFRESH);
                    }
                } else {
                    registry.removeRegistration(clazz, url).ifPresent(dependencyId -> {
                        ui.getInternals().removeStyleSheet((String)dependencyId);
                        event.triggerUpdate(ui, UIUpdateStrategy.REFRESH);
                    });
                }
                if (isAppShell) {
                    ui.getInternals().removeStyleSheet("appShell-" + url);
                    event.triggerUpdate(ui, UIUpdateStrategy.REFRESH);
                }
                LOGGER.debug("Removed stylesheet {} from Component {}", (Object)url, (Object)clazz.getName());
            }
            for (String url : addedStylesheets) {
                try {
                    ui.getPage().addStyleSheet(url);
                    dependency = ui.getInternals().getDependencyList().getDependencyByUrl(url, Dependency.Type.STYLESHEET);
                    registry.addRegistration(clazz, dependency);
                    event.triggerUpdate(ui, UIUpdateStrategy.REFRESH);
                    LOGGER.debug("Added stylesheet {} to Component {}", (Object)url, (Object)clazz.getName());
                }
                catch (Exception e) {
                    LOGGER.debug("Failed to add stylesheet {} to Component {}", new Object[]{url, clazz.getName(), e});
                }
            }
        }
    }

    @Override
    public void onResourcesChange(HotswapResourceEvent event) {
        if (event.anyMatches(".*\\.css")) {
            LOGGER.debug("Triggering browser live reload because of CSS resources changes");
            VaadinService vaadinService = event.getVaadinService();
            File buildResourcesFolder = vaadinService.getDeploymentConfiguration().getOutputResourceFolder();
            List<String> publicStaticResourcesPaths = Stream.of("META-INF/resources", "resources", "static", "public").map(path -> new File(buildResourcesFolder, (String)path)).filter(File::exists).map(staticResourceFolder -> FrontendUtils.getUnixPath(staticResourceFolder.toPath())).toList();
            event.getChangedResources().stream().filter(uri -> !new File(uri.getPath()).isDirectory()).forEach(resource -> {
                String resourcePath = resource.getPath();
                for (String staticResourcesPath : publicStaticResourcesPaths) {
                    if (!resourcePath.startsWith(staticResourcesPath)) continue;
                    String path = resourcePath.replace(staticResourcesPath, "");
                    if (path.startsWith("/")) {
                        path = path.substring(1);
                    }
                    event.updateClientResource("context://" + path, null);
                }
            });
        }
    }

    private boolean isComponentInUse(UI ui, Class<?> componentClass) {
        return ui.getChildren().anyMatch(component -> componentClass.isInstance(component) || this.hasChildOfType((Component)component, componentClass));
    }

    private boolean hasChildOfType(Component component, Class<?> targetClass) {
        if (targetClass.isInstance(component)) {
            return true;
        }
        return component.getChildren().anyMatch(child -> this.hasChildOfType((Component)child, targetClass));
    }

    private static Set<String> getStyleSheetUrls(Class<?> clazz) {
        LinkedHashSet<String> urls = new LinkedHashSet<String>();
        if (Component.class.isAssignableFrom(clazz)) {
            Class<?> componentClass = clazz;
            List<StyleSheet> annotations = AnnotationReader.getStyleSheetAnnotations(componentClass);
            for (StyleSheet annotation : annotations) {
                String url = annotation.value();
                if (url == null || url.isEmpty()) continue;
                urls.add(url);
            }
        } else {
            StyleSheet[] annotations;
            for (StyleSheet annotation : annotations = (StyleSheet[])clazz.getAnnotationsByType(StyleSheet.class)) {
                String url = annotation.value();
                if (url == null || url.isEmpty()) continue;
                urls.add(url);
            }
        }
        return urls;
    }

    private Registry getRegistry(VaadinSession session) {
        Registry registry = (Registry)session.getAttribute(STYLESHEET_REGISTRY_KEY);
        if (registry == null) {
            registry = new Registry();
            session.setAttribute(STYLESHEET_REGISTRY_KEY, registry);
        }
        return registry;
    }

    private static class Registry
    implements Serializable {
        private transient Map<String, RegistryEntry> entries = new ConcurrentHashMap<String, RegistryEntry>();

        private Registry() {
        }

        Set<String> previousState(Class<?> clazz) {
            RegistryEntry entry = this.entries.get(clazz.getName());
            if (entry != null) {
                return new LinkedHashSet<String>(entry.previousState);
            }
            return null;
        }

        void updateState(Class<?> clazz, Set<String> stylesheets) {
            this.entries.computeIfAbsent(clazz.getName(), k -> new RegistryEntry()).updateState(stylesheets);
        }

        void updateState(Set<Class<?>> classes) {
            for (Class<?> clazz : classes) {
                Set<String> stylesheets = StyleSheetHotswapper.getStyleSheetUrls(clazz);
                if (stylesheets.isEmpty()) continue;
                this.updateState(clazz, stylesheets);
            }
        }

        Optional<String> removeRegistration(Class<?> clazz, String url) {
            return Optional.ofNullable(this.entries.get(clazz.getName())).flatMap(entry -> entry.removeRegistration(url));
        }

        void addRegistration(Class<?> clazz, Dependency dependency) {
            this.entries.computeIfAbsent(clazz.getName(), k -> new RegistryEntry()).addRegistration(dependency);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            this.entries = new ConcurrentHashMap<String, RegistryEntry>();
        }
    }

    private static class RegistryEntry {
        private final Map<String, String> registrations = new LinkedHashMap<String, String>();
        private final Set<String> previousState = new LinkedHashSet<String>();

        private RegistryEntry() {
        }

        void updateState(Set<String> stylesheets) {
            this.previousState.clear();
            this.previousState.addAll(stylesheets);
        }

        Optional<String> removeRegistration(String url) {
            return Optional.ofNullable(this.registrations.remove(url));
        }

        void addRegistration(Dependency dependency) {
            if (dependency != null) {
                this.registrations.put(dependency.getUrl(), dependency.getId());
            }
        }
    }
}

