/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend.scanner;

import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.dependency.JavaScript;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.server.frontend.scanner.ClassInfo;
import com.vaadin.flow.server.frontend.scanner.CssAnnotationVisitor;
import com.vaadin.flow.server.frontend.scanner.RepeatedAnnotationVisitor;
import com.vaadin.flow.theme.NoTheme;
import com.vaadin.flow.theme.Theme;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Handle;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

final class FrontendClassVisitor
extends ClassVisitor {
    private static final Pattern SIGNATURE_PATTERN = Pattern.compile("(^\\([\\[ZBFDJICL]*|^[\\[ZBFDJICL]+|;?\\)[\\[ZBFDJICLV]*|;[\\[ZBFDJICL]*)");
    private static final String VARIANT = "variant";
    private static final String LAYOUT = "layout";
    static final String VALUE = "value";
    static final String THEME_CLASS = "themeClass";
    static final String VERSION = "version";
    static final String ASSETS = "assets";
    static final String DEV = "dev";
    static final String ID = "id";
    static final String INCLUDE = "include";
    static final String THEME_FOR = "themeFor";
    private final MethodVisitor methodVisitor;
    private final AnnotationVisitor annotationVisitor;
    private final AnnotationVisitor routeVisitor;
    private final AnnotationVisitor themeVisitor;
    private final AnnotationVisitor jsModuleVisitor;
    private final AnnotationVisitor jScriptVisitor;
    private ClassInfo classInfo;

    FrontendClassVisitor(final ClassInfo classInfo) {
        super(589824);
        this.classInfo = classInfo;
        this.methodVisitor = new FrontendMethodVisitor();
        this.routeVisitor = new RepeatedAnnotationVisitor(this){

            @Override
            public void visit(String name, Object value) {
                if (FrontendClassVisitor.LAYOUT.equals(name)) {
                    classInfo.layout = ((Type)value).getClassName();
                    classInfo.children.add(classInfo.layout);
                }
                if (FrontendClassVisitor.VALUE.equals(name)) {
                    classInfo.route = value.toString();
                }
            }
        };
        this.themeVisitor = new RepeatedAnnotationVisitor(this){

            @Override
            public void visit(String name, Object value) {
                if (FrontendClassVisitor.VALUE.equals(name)) {
                    classInfo.theme.themeName = (String)value;
                } else if (FrontendClassVisitor.THEME_CLASS.equals(name)) {
                    classInfo.theme.themeClass = ((Type)value).getClassName();
                    classInfo.children.add(classInfo.theme.themeClass);
                } else if (FrontendClassVisitor.VARIANT.equals(name)) {
                    classInfo.theme.variant = value.toString();
                }
            }
        };
        this.jsModuleVisitor = new JSAnnotationVisitor(classInfo.modules, classInfo.modulesDevelopmentOnly);
        this.jScriptVisitor = new JSAnnotationVisitor(classInfo.scripts, classInfo.scriptsDevelopmentOnly);
        this.annotationVisitor = new RepeatedAnnotationVisitor(){

            @Override
            public void visit(String name, Object value) {
                if (value != null && !value.getClass().isPrimitive() && !value.getClass().equals(String.class)) {
                    FrontendClassVisitor.this.addSignatureToClasses(classInfo.children, value.toString());
                }
            }
        };
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.addSignatureToClasses(this.classInfo.children, superName);
        for (String implementedInterface : interfaces) {
            this.addSignatureToClasses(this.classInfo.children, implementedInterface);
        }
    }

    public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
        this.addSignatureToClasses(this.classInfo.children, descriptor);
        return this.methodVisitor;
    }

    public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
        this.addSignatureToClasses(this.classInfo.children, descriptor);
        String annotationClassName = descriptor.replace("/", ".");
        if (annotationClassName.contains(Route.class.getName())) {
            return this.routeVisitor;
        }
        if (annotationClassName.contains(JsModule.class.getName())) {
            return this.jsModuleVisitor;
        }
        if (annotationClassName.contains(JavaScript.class.getName())) {
            return this.jScriptVisitor;
        }
        if (annotationClassName.contains(NoTheme.class.getName())) {
            this.classInfo.theme.notheme = true;
            return null;
        }
        if (annotationClassName.contains(Theme.class.getName())) {
            this.classInfo.theme.themeAnnotationPresent = true;
            return this.themeVisitor;
        }
        if (annotationClassName.contains(CssImport.class.getName())) {
            return new CssAnnotationVisitor(this.classInfo.css);
        }
        return this.annotationVisitor;
    }

    public FieldVisitor visitField(int access, String name, String descriptor, String signature, Object value) {
        this.addSignatureToClasses(this.classInfo.children, descriptor);
        return null;
    }

    void addSignatureToClasses(Set<String> classes, String signature) {
        String[] tmp;
        if (signature == null || signature.isEmpty()) {
            return;
        }
        for (String cls : tmp = SIGNATURE_PATTERN.split(signature.replace("/", "."))) {
            if (cls.isBlank()) continue;
            classes.add(cls);
        }
    }

    private final class FrontendMethodVisitor
    extends MethodVisitor {
        public FrontendMethodVisitor() {
            super(589824);
        }

        public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
            FrontendClassVisitor.this.addSignatureToClasses(FrontendClassVisitor.this.classInfo.children, descriptor);
            return FrontendClassVisitor.this.annotationVisitor;
        }

        public void visitTypeInsn(int opcode, String type) {
            FrontendClassVisitor.this.addSignatureToClasses(FrontendClassVisitor.this.classInfo.children, type);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
            FrontendClassVisitor.this.addSignatureToClasses(FrontendClassVisitor.this.classInfo.children, owner);
            FrontendClassVisitor.this.addSignatureToClasses(FrontendClassVisitor.this.classInfo.children, descriptor);
        }

        public void visitFieldInsn(int opcode, String owner, String name, String descriptor) {
            FrontendClassVisitor.this.addSignatureToClasses(FrontendClassVisitor.this.classInfo.children, owner);
            FrontendClassVisitor.this.addSignatureToClasses(FrontendClassVisitor.this.classInfo.children, descriptor);
        }

        public void visitLdcInsn(Object value) {
            if (value instanceof Type) {
                FrontendClassVisitor.this.addSignatureToClasses(FrontendClassVisitor.this.classInfo.children, value.toString());
            }
        }

        public void visitInvokeDynamicInsn(String name, String descriptor, Handle bootstrapMethodHandle, Object ... bootstrapMethodArguments) {
            FrontendClassVisitor.this.addSignatureToClasses(FrontendClassVisitor.this.classInfo.children, descriptor);
            FrontendClassVisitor.this.addSignatureToClasses(FrontendClassVisitor.this.classInfo.children, bootstrapMethodHandle.getOwner());
            FrontendClassVisitor.this.addSignatureToClasses(FrontendClassVisitor.this.classInfo.children, bootstrapMethodHandle.getDesc());
            for (Object obj : bootstrapMethodArguments) {
                if (obj instanceof Type) {
                    FrontendClassVisitor.this.addSignatureToClasses(FrontendClassVisitor.this.classInfo.children, obj.toString());
                    continue;
                }
                if (!(obj instanceof Handle)) continue;
                FrontendClassVisitor.this.addSignatureToClasses(FrontendClassVisitor.this.classInfo.children, ((Handle)obj).getOwner());
            }
        }
    }

    private static final class JSAnnotationVisitor
    extends RepeatedAnnotationVisitor {
        boolean currentDevOnly = false;
        private String currentModule;
        private LinkedHashSet<String> target;
        private LinkedHashSet<String> targetDevelopmentOnly;

        public JSAnnotationVisitor(LinkedHashSet<String> target, LinkedHashSet<String> targetDevelopmentOnly) {
            this.target = target;
            this.targetDevelopmentOnly = targetDevelopmentOnly;
        }

        @Override
        public void visit(String name, Object value) {
            if (name.equals("developmentOnly")) {
                Boolean developmentOnly = (Boolean)value;
                if (developmentOnly != null && developmentOnly.booleanValue()) {
                    this.currentDevOnly = true;
                }
            } else if (name.equals(FrontendClassVisitor.VALUE)) {
                this.currentModule = value.toString();
            }
        }

        public void visitEnd() {
            super.visitEnd();
            if (this.currentModule != null) {
                if (this.currentDevOnly) {
                    this.targetDevelopmentOnly.add(this.currentModule);
                } else {
                    this.target.add(this.currentModule);
                }
            }
            this.currentModule = null;
            this.currentDevOnly = false;
        }
    }
}

