/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.router;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.router.NavigationState;
import com.vaadin.flow.router.RouteParameters;
import com.vaadin.flow.router.Router;
import com.vaadin.flow.router.internal.RouteTarget;

public class NavigationStateBuilder {
    private NavigationState currentState;
    private final Router router;

    public NavigationStateBuilder(Router router) {
        this.currentState = new NavigationState(router);
        this.router = router;
    }

    public NavigationStateBuilder withTarget(Class<? extends Component> navigationTarget, RouteParameters parameters) {
        this.currentState.setNavigationTarget(navigationTarget);
        this.currentState.setRouteParameters(parameters);
        return this;
    }

    public NavigationStateBuilder withTarget(RouteTarget routeTarget, RouteParameters parameters) {
        this.currentState.setRouteTarget(routeTarget);
        this.currentState.setRouteParameters(parameters);
        return this;
    }

    public NavigationStateBuilder withTarget(Class<? extends Component> navigationTarget) {
        this.currentState.setNavigationTarget(navigationTarget);
        return this;
    }

    public NavigationStateBuilder withPath(String path) {
        this.currentState.setResolvedPath(path);
        return this;
    }

    public NavigationState build() {
        NavigationState toReturn = this.currentState;
        this.currentState = new NavigationState(this.router);
        return toReturn;
    }
}

