/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class MessageDigestUtil {
    private MessageDigestUtil() {
    }

    public static byte[] sha256(String string) {
        return MessageDigestUtil.sha256(string, StandardCharsets.UTF_16);
    }

    public static byte[] sha256(String string, Charset charset) {
        return MessageDigestUtil.getSha256(null).digest(string.getBytes(charset));
    }

    public static byte[] sha256(String string, byte[] salt, Charset charset) {
        return MessageDigestUtil.getSha256(salt).digest(string.getBytes(charset));
    }

    public static String sha256Hex(byte[] content) {
        return MessageDigestUtil.sha256Hex(content, null);
    }

    public static String sha256Hex(byte[] content, byte[] salt) {
        byte[] digest = MessageDigestUtil.getSha256(salt).digest(content);
        StringBuilder hexString = new StringBuilder();
        for (int i = 0; i < digest.length; ++i) {
            String hex = Integer.toHexString(0xFF & digest[i]);
            if (hex.length() == 1) {
                hexString.append('0');
            }
            hexString.append(hex);
        }
        return hexString.toString();
    }

    private static MessageDigest getSha256(byte[] salt) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            assert (digest.getDigestLength() == 32);
            if (salt != null && salt.length > 0) {
                digest.update(salt);
            }
            return digest;
        }
        catch (NoSuchAlgorithmException e) {
            throw new UnsupportedOperationException("Your Java implementation does not support SHA-256, even though it is required by the Java specification. Change to an implementation which follows the specification.", e);
        }
    }
}

