/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.internal.JacksonUtils;
import com.vaadin.flow.server.ExecutionFailedException;
import com.vaadin.flow.server.frontend.BundleValidationUtil;
import com.vaadin.flow.server.frontend.FallibleCommand;
import com.vaadin.flow.server.frontend.FileIOUtils;
import com.vaadin.flow.server.frontend.JarContentsManager;
import com.vaadin.flow.server.frontend.Options;
import com.vaadin.flow.server.frontend.ProdBundleUtils;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import tools.jackson.databind.node.ObjectNode;

public class TaskPrepareProdBundle
implements FallibleCommand {
    private final Options options;

    public TaskPrepareProdBundle(Options options) {
        this.options = options;
    }

    @Override
    public void execute() throws ExecutionFailedException {
        if (this.hasProdBundle()) {
            ProdBundleUtils.unpackBundle(this.options.getNpmFolder(), this.options.getResourceOutputDirectory());
        } else {
            this.copyDefaultBundleFilesFromJar();
        }
        this.copyProjectThemes();
        this.writePreCompiledMarker();
    }

    private void copyProjectThemes() {
        File localThemesRoot = new File(this.options.getFrontendDirectory(), "themes");
        if (localThemesRoot.exists()) {
            File webappResourcesDirectory = this.options.getWebappResourcesDirectory();
            if (webappResourcesDirectory == null) {
                String buildDirectory = this.options.getBuildDirectoryName();
                webappResourcesDirectory = new File(buildDirectory, Paths.get("classes", "META-INF/VAADIN/webapp/").toString());
            }
            File target = new File(webappResourcesDirectory, Paths.get("VAADIN/static/", "themes").toString());
            File[] localThemes = localThemesRoot.listFiles(File::isDirectory);
            if (localThemes == null) {
                throw new IllegalStateException();
            }
            for (File theme : localThemes) {
                try {
                    FileIOUtils.copyDirectory(theme, new File(target, theme.getName()));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private void copyDefaultBundleFilesFromJar() throws ExecutionFailedException {
        URL statsJson = BundleValidationUtil.getProdBundleResource("config/stats.json", this.options.getClassFinder());
        if (statsJson == null) {
            throw new IllegalStateException("Could not copy production bundle files, because couldn't find production bundle in the class-path");
        }
        String pathToJar = statsJson.getPath();
        int index = pathToJar.lastIndexOf(".jar!/");
        if (index >= 0) {
            pathToJar = pathToJar.substring(0, index + 4);
        }
        try {
            URI jarUri = new URI(pathToJar);
            JarContentsManager jarContentsManager = new JarContentsManager();
            jarContentsManager.copyIncludedFilesFromJarTrimmingBasePath(new File(jarUri), "vaadin-prod-bundle", this.options.getResourceOutputDirectory(), "**/*.*");
        }
        catch (URISyntaxException e) {
            throw new ExecutionFailedException("Couldn't copy production bundle files", e);
        }
    }

    private boolean hasProdBundle() {
        File prodBundleFolder = new File(this.options.getNpmFolder(), "src/main/bundles/prod.bundle");
        return prodBundleFolder.exists();
    }

    private void writePreCompiledMarker() throws ExecutionFailedException {
        try {
            File statsJsonFile = new File(this.options.getResourceOutputDirectory(), "config/stats.json");
            ObjectNode statsJsonContent = JacksonUtils.readTree(Files.readString(statsJsonFile.toPath(), StandardCharsets.UTF_8));
            statsJsonContent.put("pre-compiled", true);
            Files.writeString(statsJsonFile.toPath(), (CharSequence)(String.valueOf(statsJsonContent) + "\n"), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new ExecutionFailedException("Couldn't access stats.json file", e);
        }
    }
}

