/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server;

import com.vaadin.flow.server.PwaIcon;
import com.vaadin.flow.server.PwaRegistry;
import com.vaadin.flow.server.SystemMessages;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinSession;
import jakarta.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class HandlerHelper
implements Serializable {
    static final SystemMessages DEFAULT_SYSTEM_MESSAGES = new SystemMessages();
    static final String UNSAFE_PATH_ERROR_MESSAGE_PATTERN = "Blocked attempt to access file: {}";
    private static final Pattern PARENT_DIRECTORY_REGEX = Pattern.compile("(/|\\\\)\\.\\.(/|\\\\)?", 2);
    private static final String FETCH_DEST_HEADER = "Sec-Fetch-Dest";
    private static final Set<String> nonHtmlFetchDests;
    private static final String[] publicResourcesRoot;
    private static final String[] publicResources;

    private HandlerHelper() {
    }

    public static boolean isRequestType(VaadinRequest request, RequestType requestType) {
        return requestType.getIdentifier().equals(request.getParameter("v-r"));
    }

    public static boolean isFrameworkInternalRequest(String servletMappingPath, HttpServletRequest request) {
        return HandlerHelper.isFrameworkInternalRequest(servletMappingPath, HandlerHelper.getRequestPathInsideContext(request), request.getParameter("v-r"));
    }

    private static boolean isFrameworkInternalRequest(String servletMappingPath, String requestedPath, String requestTypeParameter) {
        if (HandlerHelper.isHillaPush(requestedPath)) {
            return true;
        }
        Optional<String> requestedPathWithoutServletMapping = HandlerHelper.getPathIfInsideServlet(servletMappingPath, requestedPath);
        if (!requestedPathWithoutServletMapping.isPresent()) {
            return false;
        }
        if (HandlerHelper.isInternalRequestInsideServlet(requestedPathWithoutServletMapping.get(), requestTypeParameter)) {
            return true;
        }
        if (RequestType.PUSH.getIdentifier().equals(requestTypeParameter) && "VAADIN/push".equals(requestedPathWithoutServletMapping.get())) {
            return true;
        }
        if (HandlerHelper.isUploadRequest(requestedPathWithoutServletMapping.get())) {
            return true;
        }
        return HandlerHelper.isDynamicResourceRequest(requestedPathWithoutServletMapping.get());
    }

    private static boolean isUploadRequest(String requestedPathWithoutServletMapping) {
        return requestedPathWithoutServletMapping.matches("VAADIN/dynamic/resource/(\\d+)/([0-9a-z-]*)/upload");
    }

    private static boolean isDynamicResourceRequest(String requestedPathWithoutServletMapping) {
        if (HandlerHelper.isPathUnsafe(requestedPathWithoutServletMapping)) {
            return false;
        }
        return requestedPathWithoutServletMapping.startsWith("VAADIN/dynamic/resource/");
    }

    private static boolean isHillaPush(String requestedPathWithoutServletMapping) {
        return "HILLA/push".equals(requestedPathWithoutServletMapping);
    }

    static boolean isInternalRequestInsideServlet(String requestedPathWithoutServletMapping, String requestTypeParameter) {
        if (requestedPathWithoutServletMapping == null || requestedPathWithoutServletMapping.isEmpty() || "/".equals(requestedPathWithoutServletMapping)) {
            return requestTypeParameter != null;
        }
        return false;
    }

    public static Optional<String> getPathIfInsideServlet(String servletMappingPath, String requestedPath) {
        Objects.requireNonNull(servletMappingPath, "servletMappingPath cannot be null");
        Objects.requireNonNull(requestedPath, "requestedPath cannot be null");
        if ("/*".equals(servletMappingPath) || "/".equals(servletMappingPath)) {
            return Optional.of(requestedPath);
        }
        if (servletMappingPath.startsWith("/") && servletMappingPath.endsWith("/*")) {
            String directory = servletMappingPath.substring(1, servletMappingPath.length() - 2);
            String directoryWithSlash = directory + "/";
            String relativeRequestedPath = requestedPath.replaceFirst("^/", "");
            if (relativeRequestedPath.equals(directory)) {
                return Optional.of("");
            }
            if (relativeRequestedPath.startsWith(directoryWithSlash)) {
                return Optional.of(relativeRequestedPath.substring(directoryWithSlash.length()));
            }
            return Optional.empty();
        }
        String servletMappingWithoutSlash = servletMappingPath.startsWith("/") ? servletMappingPath.substring(1) : servletMappingPath;
        if (requestedPath.equals(servletMappingWithoutSlash)) {
            return Optional.of(requestedPath.substring(servletMappingWithoutSlash.length()));
        }
        return Optional.empty();
    }

    public static String getRequestPathInsideContext(HttpServletRequest request) {
        String servletPath = request.getServletPath();
        String pathInfo = request.getPathInfo();
        Object url = "";
        if (servletPath != null) {
            url = servletPath.startsWith("/") ? (String)url + servletPath.substring(1) : (String)url + servletPath;
        }
        if (pathInfo != null) {
            url = (String)url + pathInfo;
        }
        return url;
    }

    public static Locale findLocale(VaadinSession session, VaadinRequest request) {
        Locale locale;
        if (session == null) {
            session = VaadinSession.getCurrent();
        }
        if (session != null && (locale = session.getLocale()) != null) {
            return locale;
        }
        if (request == null) {
            request = VaadinService.getCurrentRequest();
        }
        if (request != null && (locale = request.getLocale()) != null) {
            return locale;
        }
        return Locale.getDefault();
    }

    public static void setResponseNoCacheHeaders(BiConsumer<String, String> headerSetter, BiConsumer<String, Long> longHeaderSetter) {
        headerSetter.accept("Cache-Control", "no-cache, no-store");
        headerSetter.accept("Pragma", "no-cache");
        longHeaderSetter.accept("Expires", 0L);
    }

    public static String getCancelingRelativePath(String pathToCancel) {
        StringBuilder sb = new StringBuilder(".");
        for (int i = 1; i < pathToCancel.length(); ++i) {
            if (pathToCancel.charAt(i) != '/') continue;
            sb.append("/..");
        }
        return sb.toString();
    }

    public static boolean isPathUnsafe(String path) {
        try {
            path = URLDecoder.decode(path, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("An error occurred during decoding URL.", e);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return PARENT_DIRECTORY_REGEX.matcher(path).find();
    }

    public static String[] getPublicResources() {
        return publicResources;
    }

    public static String[] getPublicResourcesRoot() {
        return publicResourcesRoot;
    }

    public static List<String> getIconVariants(String iconPath) {
        return PwaRegistry.getIconTemplates(iconPath).stream().map(PwaIcon::getRelHref).collect(Collectors.toList());
    }

    public static String[] getPublicResourcesRequiringSecurityContext() {
        return new String[]{"/VAADIN/**"};
    }

    public static boolean isNonHtmlInitiatedRequest(HttpServletRequest request) {
        return HandlerHelper.isNonHtmlInitiatedRequest(request.getHeader(FETCH_DEST_HEADER));
    }

    public static boolean isNonHtmlInitiatedRequest(VaadinRequest request) {
        return HandlerHelper.isNonHtmlInitiatedRequest(request.getHeader(FETCH_DEST_HEADER));
    }

    private static boolean isNonHtmlInitiatedRequest(String fetchDest) {
        if (fetchDest == null) {
            return false;
        }
        return nonHtmlFetchDests.contains(fetchDest);
    }

    static {
        HashSet<String> dests = new HashSet<String>();
        dests.add("audio");
        dests.add("audioworklet");
        dests.add("font");
        dests.add("image");
        dests.add("manifest");
        dests.add("paintworklet");
        dests.add("script");
        dests.add("serviceworker");
        dests.add("sharedworker");
        dests.add("style");
        dests.add("track");
        dests.add("video");
        dests.add("worker");
        dests.add("xslt");
        nonHtmlFetchDests = Collections.unmodifiableSet(dests);
        ArrayList<String> resources = new ArrayList<String>();
        resources.add("/manifest.webmanifest");
        resources.add("/sw.js");
        resources.add("/sw-runtime-resources-precache.js");
        resources.add("/offline.html");
        resources.add("/offline-stub.html");
        resources.add("/icons/icon.png");
        resources.add("/styles.css");
        resources.add("/themes/**");
        resources.add("/aura/**");
        resources.add("/lumo/**");
        resources.add("/assets/**");
        resources.addAll(HandlerHelper.getIconVariants("icons/icon.png"));
        publicResources = resources.toArray(new String[resources.size()]);
        ArrayList<String> rootResources = new ArrayList<String>();
        rootResources.add("/favicon.ico");
        publicResourcesRoot = rootResources.toArray(new String[rootResources.size()]);
    }

    public static enum RequestType {
        INIT("init"),
        UIDL("uidl"),
        WEBCOMPONENT_RESYNC("webcomponent-resync"),
        HEARTBEAT("heartbeat"),
        PUSH("push"),
        BROWSER_TOO_OLD("oldbrowser"),
        TRANSLATION_FILE("i18n");

        private final String identifier;

        private RequestType(String identifier) {
            this.identifier = identifier;
        }

        public String getIdentifier() {
            return this.identifier;
        }
    }
}

