/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal.nodefeature;

import com.vaadin.flow.component.page.LoadingIndicatorConfiguration;
import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.internal.nodefeature.NodeMap;

public class LoadingIndicatorConfigurationMap
extends NodeMap
implements LoadingIndicatorConfiguration {
    public static final String FIRST_DELAY_KEY = "first";
    public static final int FIRST_DELAY_DEFAULT = 450;
    public static final String SECOND_DELAY_KEY = "second";
    public static final int SECOND_DELAY_DEFAULT = 1500;
    public static final String THIRD_DELAY_KEY = "third";
    public static final int THIRD_DELAY_DEFAULT = 5000;
    public static final String DEFAULT_THEME_APPLIED_KEY = "theme";
    public static final boolean DEFAULT_THEME_APPLIED_DEFAULT = true;

    public LoadingIndicatorConfigurationMap(StateNode node) {
        super(node);
    }

    @Override
    public void setFirstDelay(int firstDelay) {
        this.put(FIRST_DELAY_KEY, Integer.valueOf(firstDelay));
    }

    @Override
    public int getFirstDelay() {
        return this.getOrDefault(FIRST_DELAY_KEY, 450);
    }

    @Override
    public void setSecondDelay(int secondDelay) {
        this.put(SECOND_DELAY_KEY, Integer.valueOf(secondDelay));
    }

    @Override
    public int getSecondDelay() {
        return this.getOrDefault(SECOND_DELAY_KEY, 1500);
    }

    @Override
    public void setThirdDelay(int thirdDelay) {
        this.put(THIRD_DELAY_KEY, Integer.valueOf(thirdDelay));
    }

    @Override
    public int getThirdDelay() {
        return this.getOrDefault(THIRD_DELAY_KEY, 5000);
    }

    @Override
    public boolean isApplyDefaultTheme() {
        return this.getOrDefault(DEFAULT_THEME_APPLIED_KEY, true);
    }

    @Override
    public void setApplyDefaultTheme(boolean applyDefaultTheme) {
        this.put(DEFAULT_THEME_APPLIED_KEY, Boolean.valueOf(applyDefaultTheme));
    }
}

