/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.communication;

import com.vaadin.flow.component.PushConfiguration;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.page.ExtendedClientDetails;
import com.vaadin.flow.internal.BootstrapHandlerHelper;
import com.vaadin.flow.internal.DevModeHandler;
import com.vaadin.flow.internal.DevModeHandlerManager;
import com.vaadin.flow.internal.JacksonUtils;
import com.vaadin.flow.internal.UsageStatistics;
import com.vaadin.flow.router.InvalidLocationException;
import com.vaadin.flow.router.Location;
import com.vaadin.flow.router.LocationUtil;
import com.vaadin.flow.router.QueryParameters;
import com.vaadin.flow.server.AppShellRegistry;
import com.vaadin.flow.server.BootstrapHandler;
import com.vaadin.flow.server.HandlerHelper;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinResponse;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinServletRequest;
import com.vaadin.flow.server.VaadinSession;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.ObjectNode;

public class JavaScriptBootstrapHandler
extends BootstrapHandler {
    public JavaScriptBootstrapHandler() {
        super(context -> null);
    }

    @Override
    protected boolean canHandleRequest(VaadinRequest request) {
        return HandlerHelper.isRequestType(request, HandlerHelper.RequestType.INIT) && this.isServletRootRequest(request);
    }

    private boolean isServletRootRequest(VaadinRequest request) {
        String pathInfo = request.getPathInfo();
        return pathInfo == null || "".equals(pathInfo) || "/".equals(pathInfo);
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger((String)JavaScriptBootstrapHandler.class.getName());
    }

    protected String getRequestUrl(VaadinRequest request) {
        return ((VaadinServletRequest)request).getRequestURL().toString();
    }

    @Override
    protected BootstrapHandler.BootstrapContext createAndInitUI(Class<? extends UI> uiClass, VaadinRequest request, VaadinResponse response, VaadinSession session) {
        BootstrapHandler.BootstrapContext context = super.createAndInitUI(UI.class, request, response, session);
        ObjectNode config = context.getApplicationParameters();
        String requestURL = this.getRequestUrl(request);
        PushConfiguration pushConfiguration = context.getUI().getPushConfiguration();
        pushConfiguration.setPushServletMapping(BootstrapHandlerHelper.determinePushServletMapping(session));
        AppShellRegistry registry = AppShellRegistry.getInstance(session.getService().getContext());
        registry.modifyPushConfiguration(pushConfiguration);
        config.put("requestURL", requestURL);
        this.extractAndStoreBrowserDetails(request, context.getUI());
        return context;
    }

    private void extractAndStoreBrowserDetails(VaadinRequest request, UI ui) {
        String browserDetailsJson = request.getParameter("v-browserDetails");
        if (browserDetailsJson != null && !browserDetailsJson.isEmpty()) {
            try {
                ObjectNode json = JacksonUtils.readTree(browserDetailsJson);
                ExtendedClientDetails details = ExtendedClientDetails.fromJson(ui, (JsonNode)json);
                ui.getInternals().setExtendedClientDetails(details);
            }
            catch (Exception e) {
                JavaScriptBootstrapHandler.getLogger().debug("Failed to parse browser details from init request", (Throwable)e);
            }
        }
    }

    @Override
    protected void initializeUIWithRouter(BootstrapHandler.BootstrapContext context, UI ui) {
    }

    @Override
    protected BootstrapHandler.BootstrapContext createBootstrapContext(VaadinRequest request, VaadinResponse response, UI ui, Function<VaadinRequest, String> callback) {
        return new JavaScriptBootstrapContext(request, response, ui, callback);
    }

    @Override
    public boolean synchronizedHandleRequest(VaadinSession session, VaadinRequest request, VaadinResponse response) throws IOException {
        try {
            String pathAndParams = request.getParameter("location");
            if (pathAndParams == null) {
                throw new InvalidLocationException("Location parameter missing from bootstrap request to server.");
            }
            LocationUtil.parsePathToSegments(pathAndParams, false);
        }
        catch (InvalidLocationException invalidLocationException) {
            response.sendError(400, "Invalid location: " + invalidLocationException.getMessage());
            return true;
        }
        HandlerHelper.setResponseNoCacheHeaders(response::setHeader, response::setDateHeader);
        this.writeResponse(response, this.getInitialJson(request, response, session));
        return true;
    }

    protected static String getServiceUrl(VaadinRequest vaadinRequest) {
        return BootstrapHandlerHelper.getServiceUrl(vaadinRequest);
    }

    private ObjectNode getStats() {
        ObjectNode stats = JacksonUtils.createObjectNode();
        UsageStatistics.getEntries().forEach(entry -> {
            String name = entry.getName();
            String version = entry.getVersion();
            ObjectNode json = JacksonUtils.createObjectNode();
            json.put("is", name);
            json.put("version", version);
            String escapedName = JacksonUtils.createNode(name).toString();
            stats.set(escapedName, (JsonNode)json);
        });
        return stats;
    }

    private JsonNode getErrors(VaadinService service) {
        String errorMsg;
        ObjectNode errors = JacksonUtils.createObjectNode();
        Optional<DevModeHandler> devModeHandler = DevModeHandlerManager.getDevModeHandler(service);
        if (devModeHandler.isPresent() && (errorMsg = devModeHandler.get().getFailedOutput()) != null) {
            errors.put("webpack-dev-server", errorMsg);
        }
        return JacksonUtils.getKeys((JsonNode)errors).isEmpty() ? JacksonUtils.nullNode() : errors;
    }

    private void writeResponse(VaadinResponse response, ObjectNode json) throws IOException {
        response.setContentType("application/json");
        response.setStatus(200);
        response.getOutputStream().write(json.toString().getBytes("UTF-8"));
    }

    protected ObjectNode getInitialJson(VaadinRequest request, VaadinResponse response, VaadinSession session) {
        BootstrapHandler.BootstrapContext context = this.createAndInitUI(UI.class, request, response, session);
        ObjectNode initial = JacksonUtils.createObjectNode();
        boolean productionMode = context.getSession().getConfiguration().isProductionMode();
        ObjectNode appConfig = context.getApplicationParameters();
        appConfig.set("productionMode", JacksonUtils.createNode(productionMode));
        appConfig.put("appId", context.getAppId());
        appConfig.set("uidl", (JsonNode)JavaScriptBootstrapHandler.getInitialUidl(context.getUI()));
        initial.set("appConfig", (JsonNode)appConfig);
        if (context.getPushMode().isEnabled()) {
            initial.put("pushScript", JavaScriptBootstrapHandler.getPushScript(context));
        }
        if (!session.getConfiguration().isProductionMode()) {
            initial.set("stats", (JsonNode)this.getStats());
        }
        initial.set("errors", this.getErrors(request.getService()));
        return initial;
    }

    public static class JavaScriptBootstrapContext
    extends BootstrapHandler.BootstrapContext {
        public JavaScriptBootstrapContext(VaadinRequest request, VaadinResponse response, UI ui, Function<VaadinRequest, String> callback) {
            super(request, response, ui.getInternals().getSession(), ui, callback, JavaScriptBootstrapContext::initRoute);
        }

        private static Location initRoute(VaadinRequest request) {
            String path = request.getParameter("location");
            String params = request.getParameter("query");
            if (path != null) {
                return new Location(path, QueryParameters.fromString(params));
            }
            Map<String, String[]> parameterMap = request.getParameterMap();
            if (parameterMap != null && !parameterMap.isEmpty()) {
                return new Location(request.getPathInfo(), QueryParameters.full(parameterMap));
            }
            return new Location(request.getPathInfo(), QueryParameters.empty());
        }
    }
}

