/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.server.ErrorHandler;
import com.vaadin.flow.server.VaadinSession;
import java.io.Serializable;
import java.util.Optional;

public class ErrorEvent
implements Serializable {
    private final Throwable throwable;
    private final StateNode componentNode;

    public ErrorEvent(Throwable throwable) {
        this.throwable = throwable;
        this.componentNode = null;
    }

    public ErrorEvent(Throwable throwable, StateNode componentNode) {
        this.throwable = throwable;
        this.componentNode = componentNode;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public Optional<Component> getComponent() {
        return this.getElement().flatMap(Element::getComponent);
    }

    public Optional<Element> getElement() {
        if (this.componentNode != null) {
            try {
                return Optional.ofNullable(Element.get(this.componentNode));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return Optional.empty();
    }

    public static ErrorHandler findErrorHandler(VaadinSession session) {
        if (session == null) {
            return null;
        }
        return session.getErrorHandler();
    }
}

