/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal.nodefeature;

import com.vaadin.flow.component.EventData;
import com.vaadin.flow.component.template.internal.DeprecatedPolymerTemplate;
import com.vaadin.flow.dom.DisabledUpdateMode;
import com.vaadin.flow.internal.ReflectTools;
import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.internal.nodefeature.AbstractServerHandlers;
import com.vaadin.flow.internal.nodefeature.PolymerEventListenerMap;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Stream;

@Deprecated
public class PolymerServerEventHandlers
extends AbstractServerHandlers<DeprecatedPolymerTemplate> {
    private static final String VALUE = "value";
    private static final String REPEAT_INDEX_VALUE = "event.model.index";
    private static final String MODEL_ITEM_FQN = "com.vaadin.flow.component.polymertemplate.ModelItem";
    private static final String REPEAT_INDEX_FQN = "com.vaadin.flow.component.polymertemplate.RepeatIndex";

    public PolymerServerEventHandlers(StateNode node) {
        super(node);
    }

    @Override
    protected void addHandlerMethod(Method method, Collection<Method> methods) {
        super.addHandlerMethod(method, methods);
        this.addMethodParameters(method);
    }

    @Override
    protected void ensureSupportedParameterTypes(Method method) {
        Stream.of(method.getParameters()).forEach(parameter -> this.checkParameterTypeAndAnnotation(method, (Parameter)parameter));
    }

    @Override
    protected String getHandlerAnnotationFqn() {
        return "com.vaadin.flow.component.polymertemplate.EventHandler";
    }

    @Override
    protected void ensureSupportedReturnType(Method method) {
        if (!Void.TYPE.equals(method.getReturnType())) {
            String msg = String.format(Locale.ENGLISH, "Only void handler methods are supported. Component '%s' has method '%s' annotated with '%s' whose return type is not void but \"%s\"", method.getDeclaringClass().getName(), method.getName(), this.getHandlerAnnotationFqn(), method.getReturnType().getSimpleName());
            throw new IllegalStateException(msg);
        }
    }

    @Override
    protected DisabledUpdateMode getUpdateMode(Method method) {
        Optional<Annotation> annotation = ReflectTools.getAnnotation(method, this.getHandlerAnnotationFqn());
        assert (annotation.isPresent());
        Object value = ReflectTools.getAnnotationMethodValue(annotation.get(), VALUE);
        return DisabledUpdateMode.valueOf(value.toString());
    }

    private void checkParameterTypeAndAnnotation(Method method, Parameter parameter) {
        Class<?> parameterType;
        boolean hasRepeatIndexAnnotation;
        boolean hasEventDataAnnotation = parameter.isAnnotationPresent(EventData.class) || ReflectTools.hasAnnotation(parameter, MODEL_ITEM_FQN);
        if (!Boolean.logicalXor(hasEventDataAnnotation, hasRepeatIndexAnnotation = ReflectTools.hasAnnotation(parameter, REPEAT_INDEX_FQN))) {
            throw new IllegalStateException(String.format("EventHandler method '%s' should have the parameter with index %s annotated either with @EventData annotation (to get any particular data from the event) or have 'int' or 'Integer' type and be annotated with @RepeatIndex annotation (to get element index in dom-repeat)", method.getName(), PolymerServerEventHandlers.getParameterIndex(parameter)));
        }
        if (!(hasEventDataAnnotation || (parameterType = parameter.getType()).equals(Integer.TYPE) || parameterType.equals(Integer.class))) {
            throw new IllegalStateException(String.format("EventHandler method '%s' has parameter with index %s, annotated with @RepeatIndex that has incorrect type '%s', should be 'int' or 'Integer'", method.getName(), PolymerServerEventHandlers.getParameterIndex(parameter), parameterType));
        }
    }

    private static String getParameterIndex(Parameter parameter) {
        return parameter.getName().replace("arg", "");
    }

    private void addMethodParameters(Method method) {
        this.getNode().getFeature(PolymerEventListenerMap.class).add(method.getName(), this.getParameters(method));
    }

    private String[] getParameters(Method method) {
        ArrayList<String> result = new ArrayList<String>();
        for (Parameter parameter : method.getParameters()) {
            Optional<Annotation> annotation;
            EventData eventData = parameter.getAnnotation(EventData.class);
            if (eventData != null) {
                result.add(eventData.value());
            }
            if (ReflectTools.hasAnnotation(parameter, REPEAT_INDEX_FQN)) {
                result.add(REPEAT_INDEX_VALUE);
            }
            if (!(annotation = ReflectTools.getAnnotation(parameter, MODEL_ITEM_FQN)).isPresent()) continue;
            result.add(ReflectTools.getAnnotationMethodValue(annotation.get(), VALUE).toString());
        }
        return result.toArray(new String[result.size()]);
    }
}

