/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.internal;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.router.internal.AbstractNavigationStateRenderer;
import com.vaadin.flow.server.AbstractConfiguration;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.startup.ApplicationConfiguration;
import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.WeakHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ComponentTracker {
    private static Map<Component, Throwable> createThrowable = Collections.synchronizedMap(new WeakHashMap());
    private static Map<Component, Throwable> attachThrowable = Collections.synchronizedMap(new WeakHashMap());
    private static Map<Component, Location> createLocation = Collections.synchronizedMap(new WeakHashMap());
    private static Map<Component, Location> attachLocation = Collections.synchronizedMap(new WeakHashMap());
    private static Map<Component, Location[]> createLocations = Collections.synchronizedMap(new WeakHashMap());
    private static Map<Component, Location[]> attachLocations = Collections.synchronizedMap(new WeakHashMap());
    private static Boolean disabled = null;
    private static String[] prefixesToSkip = new String[]{"com.vaadin.flow.component.", "com.vaadin.flow.di.", "com.vaadin.flow.dom.", "com.vaadin.flow.internal.", "com.vaadin.flow.spring.", "com.vaadin.cdi.", "java.", "jdk.", "org.springframework.beans.", "org.jboss.weld."};

    public static Location findCreate(Component component) {
        return ComponentTracker.computeFilteredLocation(component, createLocation, createThrowable, null);
    }

    public static Location[] findCreateLocations(Component component) {
        return ComponentTracker.computeAllLocations(component, createLocations, createThrowable);
    }

    public static void trackCreate(Component component) {
        if (ComponentTracker.isDisabled()) {
            return;
        }
        createThrowable.put(component, new Throwable());
    }

    public static Location findAttach(Component component) {
        return ComponentTracker.computeFilteredLocation(component, attachLocation, attachThrowable, ComponentTracker.findCreate(component));
    }

    public static Location[] findAttachLocations(Component component) {
        return ComponentTracker.computeAllLocations(component, attachLocations, attachThrowable);
    }

    public static void trackAttach(Component component) {
        if (ComponentTracker.isDisabled()) {
            return;
        }
        attachThrowable.put(component, new Throwable());
    }

    public static void refreshLocation(Location location, int offset) {
        ComponentTracker.forceLazyEvaluation();
        ComponentTracker.refreshLocationMap(createLocation, location, offset);
        ComponentTracker.refreshLocations(createLocations, location, offset);
        ComponentTracker.refreshLocationMap(attachLocation, location, offset);
        ComponentTracker.refreshLocations(attachLocations, location, offset);
    }

    private static void forceLazyEvaluation() {
        for (Component component : createThrowable.keySet()) {
            ComponentTracker.findCreate(component);
            ComponentTracker.findCreateLocations(component);
        }
        for (Component component : attachThrowable.keySet()) {
            ComponentTracker.findAttach(component);
            ComponentTracker.findAttachLocations(component);
        }
    }

    private static boolean needsUpdate(Location l, Location referenceLocation) {
        return Objects.equals(l.className, referenceLocation.className) && l.lineNumber > referenceLocation.lineNumber;
    }

    private static Location updateLocation(Location l, int offset) {
        return new Location(l.className, l.filename, l.methodName, l.lineNumber + offset);
    }

    private static void refreshLocationMap(Map<Component, Location> targetRef, Location referenceLocation, int offset) {
        HashMap<Component, Location> updatedLocations = new HashMap<Component, Location>();
        for (Component c : targetRef.keySet()) {
            Location l = targetRef.get(c);
            if (!ComponentTracker.needsUpdate(l, referenceLocation)) continue;
            updatedLocations.put(c, ComponentTracker.updateLocation(l, offset));
        }
        targetRef.putAll(updatedLocations);
    }

    private static void refreshLocations(Map<Component, Location[]> targetRef, Location referenceLocation, int offset) {
        HashMap updatedLocations = new HashMap();
        for (Component c : targetRef.keySet()) {
            Location[] locations = targetRef.get(c);
            for (int i = 0; i < locations.length; ++i) {
                if (!ComponentTracker.needsUpdate(locations[i], referenceLocation)) continue;
                locations[i] = ComponentTracker.updateLocation(locations[i], offset);
            }
        }
        targetRef.putAll(updatedLocations);
    }

    private static boolean isNavigatorCreate(Location location) {
        return location.className().equals(AbstractNavigationStateRenderer.class.getName());
    }

    private static Location[] findRelevantLocations(Location[] locations) {
        return (Location[])Stream.of(locations).filter(location -> {
            for (String prefixToSkip : prefixesToSkip) {
                if (!location.className().startsWith(prefixToSkip)) continue;
                return false;
            }
            return true;
        }).toArray(Location[]::new);
    }

    private static Location findRelevantLocation(Class<? extends Component> excludeClass, Location[] locations, Location preferredClass) {
        Optional<Location> preferredCandidate;
        List candidates = Arrays.stream(locations).filter(location -> excludeClass == null || !location.className().equals(excludeClass.getName())).filter(location -> {
            for (String prefixToSkip : prefixesToSkip) {
                if (!location.className().startsWith(prefixToSkip)) continue;
                return false;
            }
            return true;
        }).collect(Collectors.toList());
        if (preferredClass != null && (preferredCandidate = candidates.stream().filter(location -> location.className().equals(preferredClass.className())).findFirst()).isPresent()) {
            return preferredCandidate.get();
        }
        return candidates.isEmpty() ? null : (Location)candidates.get(0);
    }

    private static boolean isDisabled() {
        if (disabled != null) {
            return disabled;
        }
        VaadinService service = VaadinService.getCurrent();
        if (service == null) {
            return true;
        }
        VaadinContext context = service.getContext();
        if (context == null) {
            return true;
        }
        ApplicationConfiguration applicationConfiguration = ApplicationConfiguration.get(context);
        if (applicationConfiguration == null) {
            return true;
        }
        disabled = applicationConfiguration.isProductionMode() || !applicationConfiguration.getBooleanProperty("devmode.componentTracker.enabled", true);
        return disabled;
    }

    private static Location computeFilteredLocation(Component component, Map<Component, Location> locationCache, Map<Component, Throwable> throwableMap, Location referenceLocation) {
        Location cached = locationCache.get(component);
        if (cached != null) {
            return cached;
        }
        Throwable throwable = throwableMap.get(component);
        if (throwable == null) {
            return null;
        }
        StackTraceElement[] stack = throwable.getStackTrace();
        Location[] allLocations = (Location[])Stream.of(stack).map(ComponentTracker::toLocation).toArray(Location[]::new);
        Location[] relevantLocations = ComponentTracker.findRelevantLocations(allLocations);
        Location location = ComponentTracker.findRelevantLocation(component.getClass(), relevantLocations, referenceLocation);
        if (ComponentTracker.isNavigatorCreate(location)) {
            location = referenceLocation != null ? referenceLocation : ComponentTracker.findRelevantLocation(null, relevantLocations, null);
        }
        locationCache.put(component, location);
        return location;
    }

    private static Location[] computeAllLocations(Component component, Map<Component, Location[]> locationsCache, Map<Component, Throwable> throwableMap) {
        Location[] cached = locationsCache.get(component);
        if (cached != null) {
            return cached;
        }
        Throwable throwable = throwableMap.get(component);
        if (throwable == null) {
            return null;
        }
        Location[] locations = (Location[])Stream.of(throwable.getStackTrace()).map(ComponentTracker::toLocation).toArray(Location[]::new);
        locationsCache.put(component, locations);
        return locations;
    }

    private static Location toLocation(StackTraceElement stackTraceElement) {
        if (stackTraceElement == null) {
            return null;
        }
        String className = stackTraceElement.getClassName();
        String fileName = stackTraceElement.getFileName();
        String methodName = stackTraceElement.getMethodName();
        int lineNumber = stackTraceElement.getLineNumber();
        return new Location(className, fileName, methodName, lineNumber);
    }

    public static class Location
    implements Serializable {
        private static final Pattern MAYBE_INNER_CLASS = Pattern.compile("(.*\\.[^$.]+)\\$[^.]+$");
        private final String className;
        private final String filename;
        private final String methodName;
        private final int lineNumber;

        public Location(String className, String filename, String methodName, int lineNumber) {
            this.className = className;
            this.filename = filename;
            this.methodName = methodName;
            this.lineNumber = lineNumber;
        }

        public String className() {
            return this.className;
        }

        public String filename() {
            return this.filename;
        }

        public String methodName() {
            return this.methodName;
        }

        public int lineNumber() {
            return this.lineNumber;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Location location = (Location)o;
            if (this.lineNumber != location.lineNumber) {
                return false;
            }
            if (!Objects.equals(this.className, location.className)) {
                return false;
            }
            if (!Objects.equals(this.filename, location.filename)) {
                return false;
            }
            return Objects.equals(this.methodName, location.methodName);
        }

        public int hashCode() {
            int result = this.className != null ? this.className.hashCode() : 0;
            result = 31 * result + (this.filename != null ? this.filename.hashCode() : 0);
            result = 31 * result + (this.methodName != null ? this.methodName.hashCode() : 0);
            result = 31 * result + this.lineNumber;
            return result;
        }

        public File findSourceFile(AbstractConfiguration configuration) {
            Matcher matcher;
            String cls = this.className();
            int indexOfExt = this.filename().lastIndexOf(".");
            String ext = this.filename().substring(indexOfExt);
            if (!ext.equals(".java") && !ext.equals(".kt")) {
                return null;
            }
            String filenameNoExt = this.filename().substring(0, indexOfExt);
            if (!cls.endsWith(filenameNoExt) && (matcher = MAYBE_INNER_CLASS.matcher(cls)).find()) {
                cls = matcher.group(1);
            }
            if (!cls.endsWith(filenameNoExt)) {
                return null;
            }
            File src = configuration.getJavaSourceFolder();
            String path = src.getPath().replaceAll("\\\\", "/");
            if (ext.equals(".kt") && path.endsWith("/java")) {
                src = new File(path.substring(0, path.lastIndexOf("/java")) + "/kotlin");
            }
            File javaFile = new File(src, cls.replace(".", File.separator) + ext);
            return javaFile;
        }

        public String toString() {
            return "Component '" + this.className + "' at '" + this.filename + "' (" + this.methodName + " LINE " + this.lineNumber + ")";
        }
    }
}

