/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.startup;

import com.vaadin.flow.server.InvalidRouteConfigurationException;
import com.vaadin.flow.server.InvalidRouteLayoutConfigurationException;
import com.vaadin.flow.server.VaadinServletContext;
import com.vaadin.flow.server.startup.ClassLoaderAwareServletContainerInitializer;
import com.vaadin.flow.server.startup.VaadinContextStartupInitializer;
import com.vaadin.flow.server.startup.VaadinInitializerException;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FunctionalInterface
public interface VaadinServletContextStartupInitializer
extends ClassLoaderAwareServletContainerInitializer,
VaadinContextStartupInitializer {
    @Override
    default public void process(Set<Class<?>> classSet, ServletContext context) throws ServletException {
        try {
            this.initialize(classSet, new VaadinServletContext(context));
        }
        catch (VaadinInitializerException e) {
            if (e.getCause() instanceof InvalidRouteConfigurationException || e.getCause() instanceof InvalidRouteLayoutConfigurationException) {
                VaadinServletContextStartupInitializer.getLogger().error("Route configuration error found:");
                VaadinServletContextStartupInitializer.getLogger().error(e.getCause().getMessage());
            }
            throw new ServletException((Throwable)e);
        }
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(VaadinServletContextStartupInitializer.class);
    }
}

