/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.router;

import com.fasterxml.jackson.databind.node.BaseJsonNode;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.internal.JacksonUtils;
import com.vaadin.flow.router.ErrorNavigationEvent;
import com.vaadin.flow.router.ErrorParameter;
import com.vaadin.flow.router.InternalServerError;
import com.vaadin.flow.router.Location;
import com.vaadin.flow.router.NavigationEvent;
import com.vaadin.flow.router.NavigationHandler;
import com.vaadin.flow.router.NavigationState;
import com.vaadin.flow.router.NavigationStateBuilder;
import com.vaadin.flow.router.NavigationTrigger;
import com.vaadin.flow.router.NotFoundException;
import com.vaadin.flow.router.QueryParameters;
import com.vaadin.flow.router.RouteResolver;
import com.vaadin.flow.router.internal.DefaultRouteResolver;
import com.vaadin.flow.router.internal.ErrorStateRenderer;
import com.vaadin.flow.router.internal.ErrorTargetEntry;
import com.vaadin.flow.router.internal.InternalRedirectHandler;
import com.vaadin.flow.router.internal.NavigationStateRenderer;
import com.vaadin.flow.router.internal.ResolveRequest;
import com.vaadin.flow.server.ErrorRouteRegistry;
import com.vaadin.flow.server.HttpStatusCode;
import com.vaadin.flow.server.RouteRegistry;
import com.vaadin.flow.server.SessionRouteRegistry;
import com.vaadin.flow.server.VaadinResponse;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinSession;
import elemental.json.JsonValue;
import java.io.Serializable;
import java.util.Map;
import java.util.Optional;
import java.util.function.IntConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Router
implements Serializable {
    private RouteResolver routeResolver;
    private final RouteRegistry registry;

    public Router(RouteRegistry registry) {
        assert (registry != null);
        this.registry = registry;
        this.routeResolver = new DefaultRouteResolver();
    }

    public void initializeUI(UI ui, Location location) {
        ui.getPage().getHistory().setHistoryStateChangeHandler(e -> this.navigate(ui, e.getLocation(), e.getTrigger(), JacksonUtils.mapElemental(e.getState().orElse(null))));
        int statusCode = this.navigate(ui, location, NavigationTrigger.PAGE_LOAD);
        VaadinResponse response = VaadinService.getCurrentResponse();
        if (response != null) {
            response.setStatus(statusCode);
        }
    }

    public Optional<NavigationState> resolveNavigationTarget(String pathInfo, Map<String, String[]> parameterMap) {
        Location location = new Location(pathInfo, QueryParameters.full(parameterMap));
        return this.resolveNavigationTarget(location);
    }

    public Optional<NavigationState> resolveNavigationTarget(Location location) {
        NavigationState resolve = null;
        try {
            resolve = this.getRouteResolver().resolve(new ResolveRequest(this, location));
        }
        catch (NotFoundException nfe) {
            LoggerFactory.getLogger((String)Router.class.getName()).warn("Failed to resolve navigation target for path: {}", (Object)location.getPath(), (Object)nfe);
        }
        return Optional.ofNullable(resolve);
    }

    public Optional<NavigationState> resolveRouteNotFoundNavigationTarget() {
        Optional<ErrorTargetEntry> errorTargetEntry = this.getErrorNavigationTarget(new NotFoundException());
        NavigationState result = null;
        if (errorTargetEntry.isPresent()) {
            result = new NavigationStateBuilder(this).withTarget(errorTargetEntry.get().getNavigationTarget()).build();
        }
        return Optional.ofNullable(result);
    }

    public int navigate(UI ui, Location location, NavigationTrigger trigger) {
        return this.navigate(ui, location, trigger, (BaseJsonNode)null);
    }

    public int navigate(UI ui, Location location, NavigationTrigger trigger, BaseJsonNode state) {
        return this.navigate(ui, location, trigger, state, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int navigate(UI ui, Location location, NavigationTrigger trigger, BaseJsonNode state, boolean forceInstantiation, boolean recreateLayoutChain) {
        assert (ui != null);
        assert (location != null);
        assert (trigger != null);
        ui.getSession().checkHasLock();
        if (this.handleNavigationForLocation(ui, location)) {
            ui.getInternals().setLastHandledNavigation(location);
            try {
                int n = this.handleNavigation(ui, location, trigger, state, forceInstantiation, recreateLayoutChain);
                return n;
            }
            catch (Exception exception) {
                int n = this.handleExceptionNavigation(ui, location, exception, trigger, state);
                return n;
            }
            finally {
                ui.getInternals().clearLastHandledNavigation();
            }
        }
        return HttpStatusCode.NOT_MODIFIED.getCode();
    }

    @Deprecated
    public int navigate(UI ui, Location location, NavigationTrigger trigger, JsonValue state) {
        return this.navigate(ui, location, trigger, state, false, false);
    }

    @Deprecated
    public int navigate(UI ui, Location location, NavigationTrigger trigger, JsonValue state, boolean forceInstantiation, boolean recreateLayoutChain) {
        return this.navigate(ui, location, trigger, JacksonUtils.mapElemental(state), forceInstantiation, recreateLayoutChain);
    }

    private boolean handleNavigationForLocation(UI ui, Location location) {
        if (ui.getInternals().hasLastHandledLocation()) {
            return !location.getPathWithQueryParameters().equals(ui.getInternals().getLastHandledLocation().getPathWithQueryParameters());
        }
        return true;
    }

    private int handleNavigation(UI ui, Location location, NavigationTrigger trigger, BaseJsonNode state, boolean forceInstantiation, boolean recreateLayoutChain) {
        NavigationState newState = this.getRouteResolver().resolve(new ResolveRequest(this, location));
        NavigationEvent navigationEvent = null;
        NavigationHandler handler = null;
        if (newState != null) {
            navigationEvent = new NavigationEvent(this, location, ui, trigger, state, false, forceInstantiation, recreateLayoutChain);
            handler = new NavigationStateRenderer(newState);
        } else if (!location.getPath().isEmpty()) {
            Location slashToggledLocation = location.toggleTrailingSlash();
            NavigationState slashToggledState = this.getRouteResolver().resolve(new ResolveRequest(this, slashToggledLocation));
            if (slashToggledState != null) {
                navigationEvent = new NavigationEvent(this, slashToggledLocation, ui, trigger, state, false, forceInstantiation, recreateLayoutChain);
                handler = new InternalRedirectHandler(slashToggledLocation);
            }
        }
        if (navigationEvent == null || handler == null) {
            throw new NotFoundException("Couldn't find route for '" + location.getPath() + "'");
        }
        return this.executeNavigation(ui, location, navigationEvent, handler, null);
    }

    public int handleExceptionNavigation(UI ui, Location location, Exception exception, NavigationTrigger trigger, BaseJsonNode state) {
        Optional<ErrorTargetEntry> maybeLookupResult = this.getErrorNavigationTarget(exception);
        if (maybeLookupResult.isEmpty()) {
            String message = String.format("No error view found for exception '%s'", exception.getClass().getName());
            throw new RuntimeException(message, exception);
        }
        ErrorTargetEntry lookupResult = maybeLookupResult.get();
        ErrorParameter<? extends Exception> errorParameter = new ErrorParameter<Exception>(lookupResult.getHandledExceptionType(), exception, exception.getMessage());
        ErrorStateRenderer handler = new ErrorStateRenderer(new NavigationStateBuilder(this).withTarget(lookupResult.getNavigationTarget()).build());
        ErrorNavigationEvent navigationEvent = new ErrorNavigationEvent(this, location, ui, trigger, errorParameter, state);
        try {
            return handler.handle(navigationEvent);
        }
        catch (Exception errorHandlingException) {
            Logger logger = LoggerFactory.getLogger(Router.class);
            logger.error("Exception occurred while rendering error view '{}' for '{}'. Falling back to InternalServerError.", new Object[]{lookupResult.getNavigationTarget(), location.getPath(), errorHandlingException});
            ErrorParameter<Exception> fallbackParameter = new ErrorParameter<Exception>(Exception.class, exception, exception.getMessage());
            ErrorStateRenderer fallbackHandler = new ErrorStateRenderer(new NavigationStateBuilder(this).withTarget(InternalServerError.class).build());
            ErrorNavigationEvent fallbackEvent = new ErrorNavigationEvent(this, location, ui, trigger, fallbackParameter, state);
            return fallbackHandler.handle(fallbackEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeNavigation(UI ui, Location location, NavigationEvent navigationEvent, NavigationHandler handler, IntConsumer onSuccess) {
        ui.getInternals().setLastHandledNavigation(location);
        try {
            int result = handler.handle(navigationEvent);
            if (onSuccess != null) {
                onSuccess.accept(result);
            }
            int n = result;
            return n;
        }
        catch (Exception exception) {
            int n = this.handleExceptionNavigation(ui, location, exception, navigationEvent.getTrigger(), navigationEvent.getState().orElse(null));
            return n;
        }
        finally {
            ui.getInternals().clearLastHandledNavigation();
        }
    }

    private RouteResolver getRouteResolver() {
        return this.routeResolver;
    }

    public RouteRegistry getRegistry() {
        if (VaadinSession.getCurrent() != null) {
            return SessionRouteRegistry.getSessionRegistry(VaadinSession.getCurrent());
        }
        return this.registry;
    }

    public Optional<ErrorTargetEntry> getErrorNavigationTarget(Exception exception) {
        if (this.registry instanceof ErrorRouteRegistry) {
            return ((ErrorRouteRegistry)((Object)this.registry)).getErrorNavigationTarget(exception);
        }
        return Optional.empty();
    }
}

