/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal;

import com.vaadin.flow.server.HandlerHelper;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinServletRequest;
import com.vaadin.flow.server.VaadinServletService;
import com.vaadin.flow.server.VaadinSession;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletRegistration;
import jakarta.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.util.Map;
import java.util.Optional;

public final class BootstrapHandlerHelper
implements Serializable {
    private BootstrapHandlerHelper() {
    }

    public static String getServiceUrl(VaadinRequest vaadinRequest) {
        String pathInfo = vaadinRequest.getPathInfo();
        if (pathInfo == null) {
            return ".";
        }
        String rawPathInfo = BootstrapHandlerHelper.getRawPathInfo(vaadinRequest);
        return HandlerHelper.getCancelingRelativePath(rawPathInfo != null ? rawPathInfo : pathInfo);
    }

    private static String getRawPathInfo(VaadinRequest vaadinRequest) {
        if (vaadinRequest instanceof VaadinServletRequest) {
            VaadinServletRequest servletRequest = (VaadinServletRequest)vaadinRequest;
            HttpServletRequest httpRequest = servletRequest.getHttpServletRequest();
            String requestURI = httpRequest.getRequestURI();
            String contextPath = httpRequest.getContextPath();
            String servletPath = httpRequest.getServletPath();
            if (requestURI != null && contextPath != null && servletPath != null) {
                int prefixLength = contextPath.length() + servletPath.length();
                if (requestURI.length() >= prefixLength) {
                    return requestURI.substring(prefixLength);
                }
            }
        }
        return null;
    }

    public static String getPushURL(VaadinSession vaadinSession, VaadinRequest vaadinRequest) {
        String pushServletMapping = BootstrapHandlerHelper.determinePushServletMapping(vaadinSession);
        Object pushURL = pushServletMapping + "VAADIN/push";
        String contextPath = vaadinRequest.getService().getContextRootRelativePath(vaadinRequest);
        if (contextPath.endsWith("/") && ((String)pushURL).startsWith("/")) {
            pushURL = ((String)pushURL).substring(1);
        }
        return contextPath + (String)pushURL;
    }

    public static String determinePushServletMapping(VaadinSession vaadinSession) {
        Optional<ServletRegistration> servletRegistration;
        String pushServletMapping = BootstrapHandlerHelper.getCleanedPushServletMapping(vaadinSession.getConfiguration().getPushServletMapping());
        if (pushServletMapping == null && vaadinSession.getService() instanceof VaadinServletService && (servletRegistration = BootstrapHandlerHelper.getServletRegistration((ServletConfig)((VaadinServletService)vaadinSession.getService()).getServlet())).isPresent()) {
            pushServletMapping = BootstrapHandlerHelper.findFirstUrlMapping(servletRegistration.get());
        }
        return pushServletMapping;
    }

    public static String getCleanedPushServletMapping(String pushServletMapping) {
        if (pushServletMapping == null || ((String)pushServletMapping).trim().isEmpty()) {
            return null;
        }
        if (!((String)pushServletMapping).startsWith("/")) {
            pushServletMapping = "/" + (String)pushServletMapping;
        }
        if (((String)pushServletMapping).endsWith("/*")) {
            pushServletMapping = ((String)pushServletMapping).replace("/*", "/");
        }
        if (!((String)pushServletMapping).endsWith("/")) {
            pushServletMapping = (String)pushServletMapping + "/";
        }
        return pushServletMapping;
    }

    public static Optional<ServletRegistration> getServletRegistration(ServletConfig servletConfig) {
        Map regs;
        String name = servletConfig.getServletName();
        if (name != null && (regs = servletConfig.getServletContext().getServletRegistrations()) != null) {
            return Optional.ofNullable((ServletRegistration)servletConfig.getServletContext().getServletRegistrations().get(name));
        }
        return Optional.empty();
    }

    public static String findFirstUrlMapping(ServletRegistration registration) {
        String firstMapping = registration.getMappings().stream().filter(mapping -> !mapping.equals("/VAADIN/*") && !mapping.equals("/vaadinServlet/*")).sorted().findFirst().orElse("/");
        return firstMapping.replace("/*", "/");
    }
}

