/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal.change;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.NumericNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.fasterxml.jackson.databind.node.ValueNode;
import com.vaadin.flow.internal.ConstantPool;
import com.vaadin.flow.internal.JacksonCodec;
import com.vaadin.flow.internal.JacksonUtils;
import com.vaadin.flow.internal.JsonCodec;
import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.internal.change.NodeFeatureChange;
import com.vaadin.flow.internal.nodefeature.NodeFeature;
import elemental.json.Json;
import elemental.json.JsonObject;
import elemental.json.JsonValue;

public class MapPutChange
extends NodeFeatureChange {
    private final String key;
    private final Object value;

    public MapPutChange(NodeFeature map, String key, Object value) {
        super(map);
        assert (key != null);
        this.key = key;
        this.value = value;
    }

    public String getKey() {
        return this.key;
    }

    public Object getValue() {
        return this.value;
    }

    @Override
    protected void populateJson(JsonObject json, ConstantPool constantPool) {
        json.put("type", "put");
        json.put("key", this.key);
        super.populateJson(json, constantPool);
        Object object = this.value;
        if (object instanceof StateNode) {
            StateNode node = (StateNode)object;
            json.put("nodeValue", (JsonValue)Json.create((double)node.getId()));
        } else {
            object = this.value;
            if (object instanceof ObjectNode) {
                ObjectNode node = (ObjectNode)object;
                json.put("value", (JsonValue)Json.parse((String)JacksonCodec.encodeWithConstantPool(node, constantPool).toString()));
            } else {
                object = this.value;
                if (object instanceof NumericNode) {
                    NumericNode node = (NumericNode)object;
                    json.put("value", (JsonValue)Json.create((double)JacksonCodec.encodeWithConstantPool(node, constantPool).doubleValue()));
                } else {
                    object = this.value;
                    if (object instanceof BooleanNode) {
                        BooleanNode node = (BooleanNode)object;
                        json.put("value", (JsonValue)Json.create((boolean)JacksonCodec.encodeWithConstantPool(node, constantPool).booleanValue()));
                    } else {
                        object = this.value;
                        if (object instanceof TextNode) {
                            TextNode node = (TextNode)object;
                            json.put("value", (JsonValue)Json.create((String)JacksonCodec.encodeWithConstantPool(node, constantPool).textValue()));
                        } else {
                            object = this.value;
                            if (object instanceof ArrayNode) {
                                ArrayNode node = (ArrayNode)object;
                                json.put("value", (JsonValue)JacksonUtils.createElementalArray((ArrayNode)JacksonCodec.encodeWithConstantPool(node, constantPool)));
                            } else {
                                object = this.value;
                                if (object instanceof ValueNode) {
                                    ValueNode node = (ValueNode)object;
                                    json.put("value", (JsonValue)Json.create((String)JacksonCodec.encodeWithConstantPool(node, constantPool).toString()));
                                } else {
                                    json.put("value", JsonCodec.encodeWithConstantPool(this.value, constantPool));
                                }
                            }
                        }
                    }
                }
            }
        }
    }
}

