/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component;

import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.EventListener;
import java.util.Objects;
import java.util.Optional;

public interface HasValue<E extends ValueChangeEvent<V>, V>
extends Serializable {
    public void setValue(V var1);

    public V getValue();

    public Registration addValueChangeListener(ValueChangeListener<? super E> var1);

    default public V getEmptyValue() {
        return null;
    }

    default public Optional<V> getOptionalValue() {
        return this.isEmpty() ? Optional.empty() : Optional.ofNullable(this.getValue());
    }

    default public boolean isEmpty() {
        return Objects.equals(this.getValue(), this.getEmptyValue());
    }

    default public void clear() {
        this.setValue(this.getEmptyValue());
    }

    public void setReadOnly(boolean var1);

    public boolean isReadOnly();

    public void setRequiredIndicatorVisible(boolean var1);

    public boolean isRequiredIndicatorVisible();

    @FunctionalInterface
    public static interface ValueChangeListener<E extends ValueChangeEvent<?>>
    extends EventListener,
    Serializable {
        public void valueChanged(E var1);
    }

    public static interface ValueChangeEvent<V>
    extends Serializable {
        public HasValue<?, V> getHasValue();

        public boolean isFromClient();

        public V getOldValue();

        public V getValue();
    }
}

