/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.server.frontend.FileIOUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public final class GeneratedFilesSupport {
    private final Set<Path> fileList = new HashSet<Path>();

    public boolean writeIfChanged(File file, List<String> content) throws IOException {
        boolean written = FileIOUtils.writeIfChanged(file, String.join((CharSequence)"\n", content));
        this.track(file);
        return written;
    }

    public boolean writeIfChanged(Path file, List<String> content) throws IOException {
        return this.writeIfChanged(file.toFile(), content);
    }

    public boolean writeIfChanged(File file, String content) throws IOException {
        boolean written = FileIOUtils.writeIfChanged(file, content);
        this.track(file);
        return written;
    }

    public boolean writeIfChanged(Path file, String content) throws IOException {
        return this.writeIfChanged(file.toFile(), content);
    }

    public void track(File file) {
        this.fileList.add(file.toPath().normalize().toAbsolutePath());
    }

    public void track(Path file) {
        this.fileList.add(file.normalize().toAbsolutePath());
    }

    public Set<Path> getFiles() {
        return new HashSet<Path>(this.fileList);
    }

    public Set<Path> getFiles(Path root) {
        Objects.requireNonNull(root, "root path is mandatory");
        Path absolute = root.normalize().toAbsolutePath();
        return this.fileList.stream().filter(p -> p.startsWith(absolute)).collect(Collectors.toCollection(HashSet::new));
    }
}

